/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.dynamicbuffer;

import com.mojang.blaze3d.pipeline.RenderTarget;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilLevelPerspectiveRenderer;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.FramebufferStack;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferManger;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DynamicBufferShard
extends RenderStateShard {
    public DynamicBufferShard(String name, Supplier<RenderTarget> targetSupplier) {
        this(Veil.veilPath("dynamic_" + name), targetSupplier);
    }

    public DynamicBufferShard(ResourceLocation name, Supplier<RenderTarget> targetSupplier) {
        super("veil:dynamic_buffer", () -> {
            DynamicBufferManger dynamicBufferManger;
            if (!Veil.platform().hasErrors() && !VeilLevelPerspectiveRenderer.isRenderingPerspective() && (dynamicBufferManger = VeilRenderSystem.renderer().getDynamicBufferManger()).isEnabled()) {
                FramebufferStack.push(name);
                dynamicBufferManger.setupRenderState(name, (RenderTarget)targetSupplier.get(), true);
            }
        }, () -> {
            if (!Veil.platform().hasErrors() && !VeilLevelPerspectiveRenderer.isRenderingPerspective() && VeilRenderSystem.renderer().getDynamicBufferManger().isEnabled()) {
                FramebufferStack.pop(name);
            }
        });
    }
}

