/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.color.Color;
import foundry.veil.api.client.color.Colorc;
import foundry.veil.api.client.color.theme.NumberThemeProperty;
import foundry.veil.api.client.tooltip.Tooltippable;
import foundry.veil.api.client.tooltip.VeilUIItemTooltipDataHolder;
import foundry.veil.api.client.util.SpaceHelper;
import foundry.veil.api.client.util.UIUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Deprecated
@ApiStatus.Internal
public class VeilUITooltipRenderer {
    public static int hoverTicks = 0;
    public static Vec3 lastHoveredPos = null;
    public static Vec3 currentPos = null;
    public static Vec3 desiredPos = null;

    public static void renderOverlay(GuiGraphics graphics, DeltaTracker deltaTracker) {
        int n;
        ItemStack istack;
        BlockHitResult blockHitResult;
        BlockEntity blockEntity;
        EntityHitResult entityHitResult;
        Entity entity;
        PoseStack stack = graphics.pose();
        int width = graphics.guiWidth();
        int height = graphics.guiHeight();
        stack.pushPose();
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        HitResult result = mc.hitResult;
        Vec3 pos = null;
        Tooltippable tooltippable = null;
        if (result instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)result).getEntity()) instanceof Tooltippable) {
            Tooltippable tooltippable1;
            tooltippable = tooltippable1 = (Tooltippable)entity;
            pos = entityHitResult.getEntity().getPosition(0.0f).add(0.0, (double)(entityHitResult.getEntity().getEyeHeight() / 2.0f), 0.0);
        }
        if (result instanceof BlockHitResult && (blockEntity = mc.level.getBlockEntity(BlockPos.containing((Position)(pos = Vec3.atCenterOf((Vec3i)(blockHitResult = (BlockHitResult)result).getBlockPos()))))) instanceof Tooltippable) {
            Tooltippable tooltippable1 = (Tooltippable)blockEntity;
            tooltippable = tooltippable1;
        }
        if (tooltippable == null || !tooltippable.isTooltipEnabled()) {
            hoverTicks = 0;
            lastHoveredPos = null;
            return;
        }
        ++hoverTicks;
        lastHoveredPos = pos;
        List<Component> tooltip = tooltippable.getTooltip();
        if (tooltip.isEmpty()) {
            hoverTicks = 0;
            return;
        }
        stack.pushPose();
        int tooltipTextWidth = 0;
        for (FormattedText formattedText : tooltip) {
            int textLineWidth = mc.font.width(formattedText);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += 2 + (tooltip.size() - 1) * 10;
        }
        int n2 = width / 2 + 20;
        int tooltipY = height / 2;
        int desiredX = n2;
        int desiredY = tooltipY;
        int n3 = Math.min(n2, width - tooltipTextWidth - 20);
        tooltipY = Math.min(tooltipY, height - tooltipHeight - 20);
        float partialTicks = deltaTracker.getRealtimeDeltaTicks();
        float fade = Mth.clamp((float)(((float)hoverTicks + partialTicks) / 24.0f), (float)0.0f, (float)1.0f);
        Colorc background = tooltippable.getTheme().getColor("background");
        Colorc borderTop = tooltippable.getTheme().getColor("topBorder");
        Colorc borderBottom = tooltippable.getTheme().getColor("bottomBorder");
        float heightBonus = tooltippable.getTooltipHeight();
        float widthBonus = tooltippable.getTooltipWidth();
        float textXOffset = tooltippable.getTooltipXOffset();
        float textYOffset = tooltippable.getTooltipYOffset();
        List<VeilUIItemTooltipDataHolder> items = tooltippable.getItems();
        ItemStack itemStack = istack = tooltippable.getStack() == null ? ItemStack.EMPTY : tooltippable.getStack();
        if (pos != lastHoveredPos) {
            currentPos = null;
            desiredPos = null;
        }
        if (tooltippable.getWorldspace()) {
            currentPos = currentPos == null ? pos : currentPos;
            Vec3 playerPos = mc.gameRenderer.getMainCamera().getPosition();
            Vec3i playerPosInt = new Vec3i((int)playerPos.x, (int)playerPos.y, (int)playerPos.z);
            Vec3i cornerInt = new Vec3i((int)pos.x, (int)pos.y, (int)pos.z);
            Vec3i diff = playerPosInt.subtract(cornerInt);
            desiredPos = pos.add((double)((float)Math.round((float)Mth.clamp((int)diff.getX(), (int)-1, (int)1) * 0.5f) - 0.5f), 0.5, (double)((float)Math.round((float)Mth.clamp((int)Math.round(diff.getZ()), (int)-1, (int)1) * 0.5f) - 0.5f));
            if (fade == 0.0f) {
                currentPos = currentPos.add(0.0, -0.25, 0.0);
                background = new Color(background).alpha(fade);
                borderTop = new Color(borderTop).alpha(fade);
                borderBottom = new Color(borderBottom).alpha(fade);
            }
            currentPos = currentPos.lerp(desiredPos, (double)0.05f);
            Vector3f screenSpacePos = SpaceHelper.worldToScreenSpace(currentPos, partialTicks);
            Vector3f desiredScreenSpacePos = SpaceHelper.worldToScreenSpace(desiredPos, partialTicks);
            float f = Mth.clamp((float)screenSpacePos.x(), (float)0.0f, (float)width);
            float f2 = screenSpacePos.y();
            Objects.requireNonNull(mc.font);
            screenSpacePos = new Vector3f(f, Mth.clamp((float)f2, (float)0.0f, (float)(height - 9 * tooltip.size())), screenSpacePos.z());
            float f3 = Mth.clamp((float)desiredScreenSpacePos.x(), (float)0.0f, (float)width);
            float f4 = desiredScreenSpacePos.y();
            Objects.requireNonNull(mc.font);
            desiredScreenSpacePos = new Vector3f(f3, Mth.clamp((float)f4, (float)0.0f, (float)(height - 9 * tooltip.size())), desiredScreenSpacePos.z());
            n = (int)screenSpacePos.x();
            tooltipY = (int)screenSpacePos.y();
            desiredX = (int)desiredScreenSpacePos.x();
            desiredY = (int)desiredScreenSpacePos.y();
        }
        UIUtils.drawHoverText(tooltippable, partialTicks, istack, stack, tooltip, (int)(n + (int)textXOffset), tooltipY + (int)textYOffset, width, height, -1, background.argb(), borderTop.argb(), borderBottom.argb(), mc.font, (int)widthBonus, (int)heightBonus, items, desiredX, desiredY);
        stack.popPose();
    }

    public static void drawConnectionLine(PoseStack stack, Tooltippable tooltippable, int tooltipX, int tooltipY, int desiredX, int desiredY) {
        if (tooltippable.getTheme().getColor("connectingLine") != null) {
            stack.pushPose();
            Colorc color = tooltippable.getTheme().getColor("connectingLine");
            float thickness = ((NumberThemeProperty)tooltippable.getTheme().getProperty("connectingLineThickness")).getValue(Float.class).floatValue();
            Matrix4f mat = stack.last().pose();
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.lineWidth((float)2.0f);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            buffer.addVertex(mat, (float)desiredX + thickness, (float)desiredY, 399.0f).setColor(color.argb());
            buffer.addVertex(mat, (float)desiredX - thickness, (float)desiredY, 399.0f).setColor(color.argb());
            buffer.addVertex(mat, (float)tooltipX - thickness, (float)(tooltipY + 3) - (float)tooltippable.getTooltipHeight() / 2.0f, 399.0f).setColor(color.argb());
            buffer.addVertex(mat, (float)tooltipX + thickness, (float)(tooltipY + 3) - (float)tooltippable.getTooltipHeight() / 2.0f, 399.0f).setColor(color.argb());
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            RenderSystem.disableBlend();
            stack.popPose();
        }
    }
}

