/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import foundry.veil.Veil;
import foundry.veil.api.client.editor.SingleWindowInspector;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.render.shader.uniform.ShaderUniform;
import foundry.veil.api.client.util.TextureDownloader;
import imgui.ImGui;
import imgui.type.ImBoolean;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.system.NativeResource;

@ApiStatus.Internal
public class TextureInspector
extends SingleWindowInspector {
    public static final Component TITLE = Component.translatable((String)"inspector.veil.texture.title");
    public static final Component DOWNLOAD = Component.translatable((String)"inspector.veil.texture.button.download");
    public static final Component POP_OUT = Component.translatable((String)"inspector.veil.texture.toggle.pop_out");
    public static final Component FLIP_X = Component.translatable((String)"inspector.veil.texture.toggle.flip_x");
    public static final Component FLIP_Y = Component.translatable((String)"inspector.veil.texture.toggle.flip_y");
    public static final Component NO_TEXTURE = Component.translatable((String)"inspector.veil.texture.asset.missing");
    private static final ResourceLocation DEBUG_CUBEMAP_SHADER = Veil.veilPath("debug/cubemap");
    private static final ResourceLocation DEBUG_ARRAY_SHADER = Veil.veilPath("debug/array");
    private final IntSet texturesSet = new IntArraySet();
    private final Int2ObjectMap<OpenTexture> openTextures = new Int2ObjectArrayMap();
    private final Int2ObjectMap<TextureStorage> textureStorage = new Int2ObjectArrayMap();
    private final ImBoolean flipX = new ImBoolean();
    private final ImBoolean flipY = new ImBoolean();
    private int[] textures = new int[0];
    private int selectedTexture = 0;
    private int selectedTarget = 0;
    private boolean downloadTextures;
    private CompletableFuture<?> downloadFuture = null;

    private void scanTextures() {
        this.texturesSet.clear();
        for (int i = 0; i < 10000; ++i) {
            if (!GL20C.glIsTexture((int)i)) continue;
            this.texturesSet.add(i);
        }
        if (this.textures.length != this.texturesSet.size()) {
            if (!this.texturesSet.contains(this.selectedTexture)) {
                this.selectedTexture = 0;
            }
            this.textures = this.texturesSet.toIntArray();
            this.openTextures.keySet().removeIf(a -> !this.texturesSet.contains(a));
            ObjectIterator iterator = this.textureStorage.int2ObjectEntrySet().iterator();
            while (iterator.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
                if (this.texturesSet.contains(entry.getIntKey())) continue;
                ((TextureStorage)entry.getValue()).free();
                iterator.remove();
            }
        }
    }

    @Override
    public Component getDisplayName() {
        return TITLE;
    }

    @Override
    public Component getGroup() {
        return RENDERER_GROUP;
    }

    private int getSelectedTexture() {
        return this.selectedTexture < 0 || this.selectedTexture >= this.textures.length ? 0 : this.textures[this.selectedTexture];
    }

    @Override
    protected void renderComponents() {
        this.scanTextures();
        int selectedId = this.getSelectedTexture();
        int[] value = new int[]{this.selectedTexture};
        ImGui.beginDisabled((this.textures.length == 0 ? 1 : 0) != 0);
        ImGui.setNextItemWidth((float)(ImGui.getContentRegionAvailX() / 2.0f));
        if (ImGui.sliderInt((String)"##textures", (int[])value, (int)0, (int)(this.textures.length - 1), (String)(selectedId == 0 ? NO_TEXTURE.getString() : Integer.toString(selectedId)))) {
            this.selectedTexture = value[0];
            this.selectedTarget = 0;
        }
        ImGui.endDisabled();
        ImGui.sameLine();
        ImGui.pushButtonRepeat((boolean)true);
        ImGui.beginDisabled((this.selectedTexture <= 0 ? 1 : 0) != 0);
        if (ImGui.arrowButton((String)"##left", (int)0)) {
            --this.selectedTexture;
            this.selectedTarget = 0;
        }
        ImGui.endDisabled();
        ImGui.beginDisabled((this.selectedTexture >= this.textures.length - 1 ? 1 : 0) != 0);
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.arrowButton((String)"##right", (int)1)) {
            ++this.selectedTexture;
            this.selectedTarget = 0;
        }
        ImGui.endDisabled();
        ImGui.popButtonRepeat();
        ImGui.beginDisabled((this.downloadFuture != null && !this.downloadFuture.isDone() ? 1 : 0) != 0);
        ImGui.sameLine();
        if (ImGui.button((String)DOWNLOAD.getString())) {
            this.downloadTextures = true;
            this.downloadFuture = new CompletableFuture();
        }
        ImGui.endDisabled();
        selectedId = this.getSelectedTexture();
        ImGui.beginDisabled((this.openTextures.containsKey(selectedId) && ((OpenTexture)this.openTextures.get((int)selectedId)).visible.get() ? 1 : 0) != 0);
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.button((String)POP_OUT.getString())) {
            this.openTextures.put(selectedId, (Object)new OpenTexture(this.flipX.get(), this.flipY.get()));
        }
        ImGui.endDisabled();
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.checkbox((String)FLIP_X.getString(), (ImBoolean)this.flipX);
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.checkbox((String)FLIP_Y.getString(), (ImBoolean)this.flipY);
        if (selectedId != 0) {
            this.addImage(selectedId, this.flipX.get(), this.flipY.get());
        }
    }

    @Override
    public void render() {
        super.render();
        ObjectIterator iterator = this.openTextures.int2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            int id = entry.getIntKey();
            OpenTexture texture = (OpenTexture)entry.getValue();
            if (!texture.visible.get()) continue;
            ImBoolean open = texture.open;
            if (!open.get()) {
                open.set(true);
                ImGui.setNextWindowSize((float)800.0f, (float)600.0f);
            }
            if (ImGui.begin((String)I18n.get((String)"inspector.veil.texture.asset", (Object[])new Object[]{id}), (ImBoolean)open, (int)256)) {
                ImBoolean flipX = texture.flipX;
                ImBoolean flipY = texture.flipY;
                ImGui.checkbox((String)FLIP_X.getString(), (ImBoolean)flipX);
                ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
                ImGui.checkbox((String)FLIP_Y.getString(), (ImBoolean)flipY);
                this.addImage(id, flipX.get(), flipY.get());
            }
            ImGui.end();
            if (open.get()) continue;
            iterator.remove();
        }
    }

    @Override
    public void renderLast() {
        super.renderLast();
        if (this.downloadTextures) {
            this.downloadTextures = false;
            try {
                Minecraft client = Minecraft.getInstance();
                Path outputFolder = Paths.get(client.gameDirectory.toURI()).resolve("debug-out");
                if (!Files.exists(outputFolder, new LinkOption[0])) {
                    Files.createDirectories(outputFolder, new FileAttribute[0]);
                } else {
                    Files.walkFileTree(outputFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                LinkedList result = new LinkedList();
                IntIterator intIterator = this.texturesSet.iterator();
                while (intIterator.hasNext()) {
                    int i = (Integer)intIterator.next();
                    result.add(TextureDownloader.save(Integer.toString(i), outputFolder, i, false));
                }
                this.downloadFuture = CompletableFuture.allOf(result.toArray(new CompletableFuture[0])).thenRunAsync(() -> Util.getPlatform().openFile(outputFolder.toFile()), (Executor)client);
            }
            catch (Exception e) {
                Veil.LOGGER.error("Failed to download textures", (Throwable)e);
            }
        }
    }

    @Override
    public void renderMenuBar() {
        for (Int2ObjectMap.Entry entry : this.openTextures.int2ObjectEntrySet()) {
            ImGui.menuItem((String)I18n.get((String)"inspector.veil.texture.asset", (Object[])new Object[]{entry.getIntKey()}), null, (ImBoolean)((OpenTexture)entry.getValue()).visible);
        }
    }

    @Override
    public boolean isMenuBarEnabled() {
        return !this.openTextures.isEmpty();
    }

    @Override
    public void onHide() {
        super.onHide();
        this.texturesSet.clear();
        this.textureStorage.values().forEach(NativeResource::free);
        this.textureStorage.clear();
        this.textures = new int[0];
        this.selectedTexture = 0;
        this.selectedTarget = 0;
    }

    private int bindTexture(int texture) {
        if (this.selectedTarget == -1) {
            return 0;
        }
        if (this.selectedTarget == 0 && VeilRenderSystem.directStateAccessSupported()) {
            this.selectedTarget = GL45C.glGetTextureParameteri((int)texture, (int)4102);
        }
        if (this.selectedTarget != 0) {
            if (this.selectedTarget == 3553) {
                GlStateManager._bindTexture((int)texture);
            } else {
                GL11C.glBindTexture((int)this.selectedTarget, (int)texture);
            }
            return this.selectedTarget;
        }
        while (GL11C.glGetError() != 0) {
        }
        int old = GL11C.glGetInteger((int)32873);
        GlStateManager._bindTexture((int)texture);
        if (GL11C.glGetError() == 0) {
            this.selectedTarget = 3553;
            return 3553;
        }
        GlStateManager._bindTexture((int)old);
        old = GL11C.glGetInteger((int)35869);
        GL11C.glBindTexture((int)35866, (int)texture);
        if (GL11C.glGetError() == 0) {
            this.selectedTarget = 35866;
            return 35866;
        }
        GL11C.glBindTexture((int)35866, (int)old);
        old = GL11C.glGetInteger((int)34068);
        GL11C.glBindTexture((int)34067, (int)texture);
        if (GL11C.glGetError() == 0) {
            this.selectedTarget = 34067;
            return 34067;
        }
        GL11C.glBindTexture((int)34067, (int)old);
        this.selectedTarget = -1;
        return 0;
    }

    private void addImage(int selectedId, boolean flipX, boolean flipY) {
        int target = this.bindTexture(selectedId);
        if (target == 0) {
            return;
        }
        if (target == 34067) {
            TextureStorage storage = (TextureStorage)this.textureStorage.get(selectedId);
            if (!(storage instanceof CubemapStorage) && storage != null) {
                this.textureStorage.remove(selectedId);
                storage.free();
            }
            CubemapStorage cubemapStorage = (CubemapStorage)this.textureStorage.computeIfAbsent(selectedId, unused -> new CubemapStorage());
            float size = ImGui.getContentRegionAvailX();
            cubemapStorage.render((int)size, (int)(size / 2.0f));
            ImGui.image((long)cubemapStorage.renderedTextureId(), (float)size, (float)(size / 2.0f), (float)(flipX ? 1.0f : 0.0f), (float)(flipY ? 1.0f : 0.0f), (float)(flipX ? 0.0f : 1.0f), (float)(flipY ? 0.0f : 1.0f), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else if (target == 35866) {
            TextureStorage storage = (TextureStorage)this.textureStorage.get(selectedId);
            if (!(storage instanceof ArrayStorage) && storage != null) {
                this.textureStorage.remove(selectedId);
                storage.free();
            }
            ArrayStorage arrayStorage = (ArrayStorage)this.textureStorage.computeIfAbsent(selectedId, unused -> new ArrayStorage());
            int width = GL11C.glGetTexLevelParameteri((int)35866, (int)0, (int)4096);
            int height = GL11C.glGetTexLevelParameteri((int)35866, (int)0, (int)4097);
            int depth = GL11C.glGetTexLevelParameteri((int)35866, (int)0, (int)32881);
            float size = ImGui.getContentRegionAvailX();
            arrayStorage.render(selectedId, width, height, depth);
            for (int i = 0; i < depth; ++i) {
                ImGui.image((long)arrayStorage.renderedTextureId(i), (float)size, (float)(size * (float)height / (float)width), (float)(flipX ? 1.0f : 0.0f), (float)(flipY ? 1.0f : 0.0f), (float)(flipX ? 0.0f : 1.0f), (float)(flipY ? 0.0f : 1.0f), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        } else if (target == 3553) {
            TextureStorage storage = (TextureStorage)this.textureStorage.remove(selectedId);
            if (storage != null) {
                storage.free();
            }
            int width = GL11C.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            int height = GL11C.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            float size = ImGui.getContentRegionAvailX();
            ImGui.image((long)selectedId, (float)size, (float)(size * (float)height / (float)width), (float)(flipX ? 1.0f : 0.0f), (float)(flipY ? 1.0f : 0.0f), (float)(flipX ? 0.0f : 1.0f), (float)(flipY ? 0.0f : 1.0f), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static sealed interface TextureStorage
    extends NativeResource
    permits CubemapStorage, ArrayStorage {
    }

    private record OpenTexture(ImBoolean open, ImBoolean visible, ImBoolean flipX, ImBoolean flipY) {
        private OpenTexture(boolean flipX, boolean flipY) {
            this(new ImBoolean(), new ImBoolean(true), new ImBoolean(flipX), new ImBoolean(flipY));
        }
    }

    private static final class CubemapStorage
    implements TextureStorage {
        private AdvancedFbo fbo;

        private CubemapStorage() {
        }

        public void render(int width, int height) {
            ShaderProgram shaderProgram = VeilRenderSystem.setShader(DEBUG_CUBEMAP_SHADER);
            if (shaderProgram == null) {
                this.free();
                return;
            }
            if (this.fbo == null || this.fbo.getWidth() != width || this.fbo.getHeight() != height) {
                this.free();
                this.fbo = AdvancedFbo.withSize(width, height).addColorTextureBuffer().setDebugLabel("Texture Inspector Cubemap").build(true);
            }
            this.fbo.bind(true);
            this.fbo.clear();
            shaderProgram.bind();
            VeilRenderSystem.drawScreenQuad();
            AdvancedFbo.unbind();
        }

        public int renderedTextureId() {
            return this.fbo.getColorTextureAttachment(0).getId();
        }

        public void free() {
            if (this.fbo != null) {
                this.fbo.free();
                this.fbo = null;
            }
        }
    }

    private static final class ArrayStorage
    implements TextureStorage {
        private AdvancedFbo fbo;
        private int[] textures;

        private ArrayStorage() {
        }

        public void render(int texture, int width, int height, int layers) {
            ShaderProgram shaderProgram = VeilRenderSystem.setShader(DEBUG_ARRAY_SHADER);
            if (shaderProgram == null || layers == 0) {
                this.free();
                return;
            }
            if (this.textures == null || this.textures.length != layers) {
                if (this.textures != null) {
                    GL11C.glDeleteTextures((int[])this.textures);
                }
                this.textures = new int[layers];
                VeilRenderSystem.createTextures(3553, this.textures);
                for (int tex : this.textures) {
                    GlStateManager._bindTexture((int)tex);
                    TextureUtil.prepareImage((int)tex, (int)width, (int)height);
                }
                GL11C.glBindTexture((int)35866, (int)texture);
            }
            if (this.fbo == null || this.fbo.getWidth() != width || this.fbo.getHeight() != height) {
                if (this.fbo != null) {
                    this.fbo.free();
                    this.fbo = null;
                }
                this.fbo = AdvancedFbo.withSize(width, height).addColorTextureWrapper(this.textures[0]).setDebugLabel("Texture Inspector Array").build(true);
            }
            this.fbo.bind(true);
            shaderProgram.bind();
            ShaderUniform indexUniform = shaderProgram.getUniform("Index");
            for (int i = 0; i < layers; ++i) {
                this.fbo.setColorAttachmentTexture(0, this.textures[i]);
                this.fbo.clear();
                if (indexUniform != null) {
                    indexUniform.setInt(i);
                }
                VeilRenderSystem.drawScreenQuad();
            }
            AdvancedFbo.unbind();
        }

        public int renderedTextureId(int index) {
            return this.textures == null || index < 0 || index >= this.textures.length ? MissingTextureAtlasSprite.getTexture().getId() : this.textures[index];
        }

        public void free() {
            if (this.fbo != null) {
                this.fbo.free();
                this.fbo = null;
            }
            if (this.textures != null) {
                GL11C.glDeleteTextures((int[])this.textures);
                this.textures = null;
            }
        }
    }
}

