/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource.type;

import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.compat.SodiumCompat;
import foundry.veil.api.resource.VeilResource;
import foundry.veil.api.resource.VeilResourceAction;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.util.CompositeReloadListener;
import foundry.veil.ext.TextureAtlasExtension;
import foundry.veil.mixin.resource.accessor.ResourceAtlasSetAccessor;
import foundry.veil.mixin.resource.accessor.ResourceModelManagerAccessor;
import foundry.veil.mixin.resource.accessor.ResourceTextureAtlasAccessor;
import imgui.ImGui;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.resources.model.AtlasSet;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;

public record TextureResource(VeilResourceInfo resourceInfo) implements VeilResource<TextureResource>
{
    @Override
    public void render(boolean dragging, boolean fullName) {
        float size = ImGui.getTextLineHeight();
        int texture = Minecraft.getInstance().getTextureManager().getTexture(this.resourceInfo.location()).getId();
        ImGui.pushStyleColor((int)0, (int)(this.resourceInfo.isStatic() ? -5592406 : -1));
        if (dragging) {
            ImGui.image((long)texture, (float)(size * 8.0f), (float)(size * 8.0f));
            VeilImGuiUtil.resourceLocation(this.resourceInfo().location());
        } else {
            ImGui.pushStyleVar((int)14, (float)0.0f, (float)0.0f);
            ImGui.setItemAllowOverlap();
            ImGui.image((long)texture, (float)size, (float)size);
            ImGui.sameLine();
            ImGui.popStyleVar();
            if (ImGui.isItemHovered()) {
                ImGui.beginTooltip();
                ImGui.image((long)texture, (float)(size * 16.0f), (float)(size * 16.0f));
                ImGui.endTooltip();
            }
            ImGui.sameLine();
            if (fullName) {
                VeilImGuiUtil.resourceLocation(this.resourceInfo.location());
            } else {
                ImGui.text((String)this.resourceInfo.fileName());
            }
        }
        ImGui.popStyleColor();
    }

    @Override
    public List<VeilResourceAction<TextureResource>> getActions() {
        return List.of();
    }

    @Override
    public boolean canHotReload() {
        return true;
    }

    @Override
    public void hotReload(VeilResourceManager resourceManager) throws IOException {
        ResourceLocation location = this.resourceInfo.location();
        ResourceManager resources = resourceManager.resources(this.resourceInfo);
        Minecraft client = Minecraft.getInstance();
        TextureManager textureManager = client.getTextureManager();
        AbstractTexture texture = textureManager.getTexture(location, null);
        if (texture != null) {
            texture.reset(textureManager, resources, location, (Executor)client);
        }
        ModelManager modelManager = client.getModelManager();
        AtlasSet atlases = ((ResourceModelManagerAccessor)modelManager).getAtlases();
        ResourceLocation id = SpriteSource.TEXTURE_ID_CONVERTER.fileToId(location);
        boolean reloadRequired = false;
        for (Map.Entry<ResourceLocation, AtlasSet.AtlasEntry> entry : ((ResourceAtlasSetAccessor)atlases).getAtlases().entrySet()) {
            if (!((TextureAtlasExtension)entry.getValue().atlas()).veil$hasTexture(id)) continue;
            reloadRequired = true;
            break;
        }
        if (SodiumCompat.INSTANCE != null) {
            if (reloadRequired) {
                CompositeReloadListener.of(new PreparableReloadListener[]{modelManager, client.getBlockRenderer(), client.getItemRenderer()}).reload(CompletableFuture::completedFuture, resources, (ProfilerFiller)InactiveProfiler.INSTANCE, (ProfilerFiller)InactiveProfiler.INSTANCE, (Executor)Util.backgroundExecutor(), (Executor)client).thenRunAsync(VeilRenderSystem::rebuildChunks, VeilRenderSystem.renderThreadExecutor());
            }
        } else {
            for (Map.Entry<ResourceLocation, AtlasSet.AtlasEntry> entry : ((ResourceAtlasSetAccessor)atlases).getAtlases().entrySet()) {
                TextureAtlas atlas = entry.getValue().atlas();
                if (!((TextureAtlasExtension)atlas).veil$hasTexture(id)) continue;
                int mipLevel = ((ResourceTextureAtlasAccessor)atlas).getMipLevel();
                ((CompletableFuture)SpriteLoader.create((TextureAtlas)atlas).loadAndStitch(resources, entry.getValue().atlasInfoLocation(), mipLevel, (Executor)Util.backgroundExecutor()).thenCompose(SpriteLoader.Preparations::waitForUpload)).thenAcceptAsync(preparations -> {
                    atlas.upload(preparations);
                    VeilRenderSystem.rebuildChunks();
                }, VeilRenderSystem.renderThreadExecutor());
            }
        }
    }

    @Override
    public int getIconCode() {
        return 62405;
    }
}

