/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource.editor;

import foundry.veil.Veil;
import foundry.veil.api.client.imgui.CodeEditor;
import foundry.veil.api.resource.VeilEditorEnvironment;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.resource.editor.ResourceFileEditor;
import foundry.veil.api.resource.type.VeilTextResource;
import imgui.ImGui;
import imgui.extension.texteditor.TextEditor;
import imgui.extension.texteditor.TextEditorLanguageDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class TextFileEditor
implements ResourceFileEditor<VeilTextResource<?>> {
    private static final Component SAVE = Component.translatable((String)"gui.veil.save");
    private final VeilResourceManager resourceManager;
    private final VeilTextResource<?> resource;
    private final CodeEditor editor = new CodeEditor(SAVE);

    public TextFileEditor(VeilEditorEnvironment environment, VeilTextResource<?> resource) {
        this.editor.show(resource.resourceInfo().fileName(), "");
        this.editor.setSaveCallback(null);
        this.resourceManager = environment.getResourceManager();
        this.resource = resource;
        this.loadFromDisk();
    }

    @Override
    public void render() {
        this.editor.renderWindow();
        if (ImGui.beginPopupModal((String)"###open_failed")) {
            ImGui.text((String)"Failed to open file");
            ImGui.endPopup();
        }
    }

    @Override
    public void loadFromDisk() {
        VeilResourceInfo info = this.resource.resourceInfo();
        TextEditorLanguageDefinition languageDefinition = this.resource.languageDefinition();
        TextEditor editor = this.editor.getEditor();
        editor.setReadOnly(true);
        editor.setColorizerEnable(false);
        info.getResource(this.resourceManager).ifPresentOrElse(data -> CompletableFuture.supplyAsync(() -> {
            String string;
            block8: {
                InputStream stream = data.open();
                try {
                    string = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new CompletionException(e);
                    }
                }
                stream.close();
            }
            return string;
        }, Util.ioPool()).handleAsync((contents, error) -> {
            if (error != null) {
                this.editor.hide();
                ImGui.openPopup((String)"###open_failed");
                Veil.LOGGER.error("Failed to open file", error);
                return null;
            }
            this.editor.show(info.fileName(), (String)contents);
            this.editor.setSaveCallback((source, errorMap) -> this.save(source.getBytes(StandardCharsets.UTF_8), this.resourceManager, this.resource));
            editor.setReadOnly(info.isStatic());
            if (languageDefinition != null) {
                editor.setColorizerEnable(true);
                editor.setLanguageDefinition(languageDefinition);
            }
            return null;
        }, (Executor)Minecraft.getInstance()), () -> {
            this.editor.hide();
            ImGui.openPopup((String)"###open_failed");
        });
    }

    @Override
    public boolean isClosed() {
        return !this.editor.isOpen();
    }

    @Override
    public VeilTextResource<?> getResource() {
        return this.resource;
    }
}

