/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.network;

import foundry.veil.api.network.handler.ClientPacketContext;
import foundry.veil.api.network.handler.PacketContext;
import foundry.veil.api.network.handler.ServerPacketContext;
import foundry.veil.impl.network.ClientPacketSink;
import java.util.ArrayList;
import java.util.ServiceLoader;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkSource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface VeilPacketManager {
    public static final Factory FACTORY = ServiceLoader.load(Factory.class).findFirst().orElseThrow(() -> new RuntimeException("Failed to load packet provider"));

    public static VeilPacketManager create(String modId, String version) {
        return FACTORY.create(modId, version);
    }

    public <T extends CustomPacketPayload> void registerClientbound(CustomPacketPayload.Type<T> var1, StreamCodec<? super RegistryFriendlyByteBuf, T> var2, PacketHandler<ClientPacketContext, T> var3);

    public <T extends CustomPacketPayload> void registerServerbound(CustomPacketPayload.Type<T> var1, StreamCodec<? super RegistryFriendlyByteBuf, T> var2, PacketHandler<ServerPacketContext, T> var3);

    public static PacketSink server() {
        return ClientPacketSink.INSTANCE;
    }

    public static PacketSink player(ServerPlayer player) {
        return packet -> player.connection.send(packet);
    }

    public static PacketSink level(ServerLevel level) {
        return packet -> level.getServer().getPlayerList().broadcastAll(packet, level.dimension());
    }

    public static PacketSink around(@Nullable ServerPlayer excluded, ServerLevel level, double x, double y, double z, double radius) {
        return packet -> level.getServer().getPlayerList().broadcast((Player)excluded, x, y, z, radius, level.dimension(), packet);
    }

    public static PacketSink all(MinecraftServer server) {
        return packet -> server.getPlayerList().broadcastAll(packet);
    }

    public static PacketSink tracking(Entity entity) {
        return packet -> {
            ChunkSource patt0$temp = entity.level().getChunkSource();
            if (!(patt0$temp instanceof ServerChunkCache)) {
                throw new IllegalStateException("Cannot send clientbound payloads on the client");
            }
            ServerChunkCache chunkCache = (ServerChunkCache)patt0$temp;
            chunkCache.broadcast(entity, packet);
        };
    }

    public static PacketSink trackingAndSelf(Entity entity) {
        return packet -> {
            ChunkSource patt0$temp = entity.level().getChunkSource();
            if (!(patt0$temp instanceof ServerChunkCache)) {
                throw new IllegalStateException("Cannot send clientbound payloads on the client");
            }
            ServerChunkCache chunkCache = (ServerChunkCache)patt0$temp;
            chunkCache.broadcastAndSend(entity, packet);
        };
    }

    public static PacketSink tracking(ServerLevel level, ChunkPos pos) {
        return packet -> {
            for (ServerPlayer player : level.getChunkSource().chunkMap.getPlayers(pos, false)) {
                player.connection.send(packet);
            }
        };
    }

    public static PacketSink tracking(ServerLevel level, BlockPos pos) {
        return VeilPacketManager.tracking(level, new ChunkPos(pos));
    }

    public static PacketSink tracking(ServerLevel level, BlockPos min, BlockPos max) {
        return packet -> ChunkPos.rangeClosed((ChunkPos)new ChunkPos(min), (ChunkPos)new ChunkPos(max)).flatMap(pos -> level.getChunkSource().chunkMap.getPlayers(pos, false).stream()).distinct().forEach(player -> player.connection.send(packet));
    }

    public static PacketSink tracking(BlockEntity blockEntity) {
        Level level = blockEntity.getLevel();
        if (!(level instanceof ServerLevel)) {
            throw new IllegalArgumentException("Only supported on server levels!");
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return VeilPacketManager.tracking(serverLevel, blockEntity.getBlockPos());
    }

    @ApiStatus.Internal
    public static interface Factory {
        public VeilPacketManager create(String var1, String var2);
    }

    @FunctionalInterface
    public static interface PacketSink {
        default public void sendPacket(CustomPacketPayload ... payloads) {
            if (payloads.length == 0) {
                return;
            }
            if (payloads.length == 1) {
                this.sendPacket((Packet<?>)new ClientboundCustomPayloadPacket(payloads[0]));
                return;
            }
            ArrayList<ClientboundCustomPayloadPacket> packets = new ArrayList<ClientboundCustomPayloadPacket>();
            for (CustomPacketPayload payload : payloads) {
                packets.add(new ClientboundCustomPayloadPacket(payload));
            }
            this.sendPacket((Packet<?>)new ClientboundBundlePacket(packets));
        }

        public void sendPacket(Packet<?> var1);
    }

    @FunctionalInterface
    public static interface PacketHandler<T extends PacketContext, P extends CustomPacketPayload> {
        public void handlePacket(P var1, T var2);
    }
}

