/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.processor;

import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import io.github.ocelot.glslprocessor.api.GlslSyntaxException;
import io.github.ocelot.glslprocessor.api.node.GlslTree;
import io.github.ocelot.glslprocessor.lib.anarres.cpp.LexerException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;

public class ShaderImportProcessor
implements ShaderPreProcessor {
    private static final String INCLUDE_KEY = "#include ";

    @Override
    public void modify(ShaderPreProcessor.Context ctx, GlslTree tree) throws IOException, GlslSyntaxException, LexerException {
        ArrayList<String> imports = new ArrayList<String>();
        List directives = tree.getDirectives();
        for (String directive : directives) {
            if (!directive.startsWith(INCLUDE_KEY)) continue;
            imports.add(directive);
        }
        for (String directive : imports) {
            String importId = directive.substring(INCLUDE_KEY.length()).trim();
            try {
                ctx.include(tree, ResourceLocation.parse((String)importId), ShaderPreProcessor.IncludeOverloadStrategy.SOURCE);
            }
            catch (ResourceLocationException e) {
                throw new IOException("Invalid import: " + importId, e);
            }
        }
        directives.removeAll(imports);
    }
}

