/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import foundry.veil.Veil;
import foundry.veil.VeilClient;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.shader.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.ShaderSourceSet;
import foundry.veil.api.client.render.shader.compiler.ShaderCompiler;
import foundry.veil.api.client.render.shader.compiler.ShaderException;
import foundry.veil.api.client.render.shader.compiler.VeilShaderSource;
import foundry.veil.api.client.render.shader.processor.ShaderBindingProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderBufferProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderImportProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderImporter;
import foundry.veil.api.client.render.shader.processor.ShaderModifyProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderVersionProcessor;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.impl.ThreadTaskScheduler;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferManger;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferProcessor;
import foundry.veil.impl.client.render.shader.ShaderImporterImpl;
import foundry.veil.impl.client.render.shader.processor.ShaderProcessorList;
import foundry.veil.impl.client.render.shader.program.DynamicShaderProgramImpl;
import foundry.veil.impl.client.render.shader.program.ShaderProgramImpl;
import io.github.ocelot.glslprocessor.api.GlslParser;
import io.github.ocelot.glslprocessor.api.GlslSyntaxException;
import io.github.ocelot.glslprocessor.api.node.GlslTree;
import io.github.ocelot.glslprocessor.lib.anarres.cpp.LexerException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public class ShaderManager
implements PreparableReloadListener,
Closeable {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(ProgramDefinition.class, (Object)new ProgramDefinition.Deserializer()).create();
    public static final FileToIdConverter INCLUDE_LISTER = new FileToIdConverter("pinwheel/shaders/include", ".glsl");
    public static final ShaderSourceSet PROGRAM_SET = new ShaderSourceSet("pinwheel/shaders/program");
    private static final Map<Integer, String> TYPES = Map.of(35633, "vertex", 36488, "tesselation_control", 36487, "tesselation_evaluation", 36313, "geometry", 35632, "fragment", 37305, "compute");
    private final DynamicBufferManger dynamicBufferManager;
    private final ShaderSourceSet sourceSet;
    private final ShaderPreDefinitions definitions;
    private final Map<ResourceLocation, ShaderProgramImpl> shaders;
    private final Map<ResourceLocation, ShaderProgram> shadersView;
    private final Set<ResourceLocation> dirtyShaders;
    private final boolean shaderStorageSupported;
    private CompletableFuture<Void> recompileFuture;
    private CompletableFuture<Void> updateBuffersFuture;

    public ShaderManager(ShaderSourceSet sourceSet, ShaderPreDefinitions shaderPreDefinitions, DynamicBufferManger dynamicBufferManager) {
        this.dynamicBufferManager = dynamicBufferManager;
        this.sourceSet = sourceSet;
        this.definitions = shaderPreDefinitions;
        this.definitions.addListener(this::onDefinitionChanged);
        this.shaders = new HashMap<ResourceLocation, ShaderProgramImpl>();
        this.shadersView = Collections.unmodifiableMap(this.shaders);
        this.dirtyShaders = new HashSet<ResourceLocation>();
        this.shaderStorageSupported = VeilRenderSystem.shaderStorageBufferSupported();
        this.recompileFuture = CompletableFuture.completedFuture(null);
        this.updateBuffersFuture = CompletableFuture.completedFuture(null);
    }

    private void onDefinitionChanged(String definition) {
        this.shaders.values().forEach(shader -> {
            if (shader.getDefinitionDependencies().contains(definition)) {
                Veil.LOGGER.debug("{} changed, recompiling {}", (Object)definition, (Object)shader.getName());
                this.scheduleRecompile(shader.getName());
            }
        });
    }

    private void addProcessors(ShaderProcessorList processorList, ResourceProvider provider) {
        processorList.addPreprocessor(new ShaderImportProcessor());
        processorList.addPreprocessor(new ShaderBufferProcessor(this.shaderStorageSupported));
        processorList.addPreprocessor(new ShaderBindingProcessor());
        processorList.addPreprocessor(new ShaderVersionProcessor(), false);
        processorList.addPreprocessor(new ShaderModifyProcessor(), false);
        processorList.addPreprocessor(new DynamicBufferProcessor(), false);
        VeilClient.clientPlatform().onRegisterShaderPreProcessors(provider, processorList);
    }

    private ProgramDefinition parseDefinition(ResourceLocation id, ResourceProvider provider) throws IOException {
        ProgramDefinition programDefinition;
        block9: {
            BufferedReader reader = provider.openAsReader(this.sourceSet.getShaderDefinitionLister().idToFile(id));
            try {
                ProgramDefinition definition = (ProgramDefinition)GsonHelper.fromJson((Gson)GSON, (Reader)reader, ProgramDefinition.class);
                if (definition.vertex() == null && definition.tesselationControl() == null && definition.tesselationEvaluation() == null && definition.geometry() == null && definition.fragment() == null && definition.compute() == null) {
                    throw new JsonSyntaxException("Shader programs must define at least 1 shader type");
                }
                programDefinition = definition;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException e) {
                    throw new IOException(e);
                }
            }
            ((Reader)reader).close();
        }
        return programDefinition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readShader(ShaderProcessorList processorList, ResourceProvider resourceProvider, Map<ResourceLocation, ProgramDefinition> definitions, Map<ResourceLocation, VeilShaderSource> shaderSources, ResourceLocation definitionId, int activeBuffers) {
        HashSet<ResourceLocation> checkedSources = new HashSet<ResourceLocation>();
        ShaderPreProcessor processor = processorList.getProcessor();
        ShaderPreProcessor importProcessor = processorList.getImportProcessor();
        try {
            ProgramDefinition definition = this.parseDefinition(definitionId, resourceProvider);
            if (definitions.put(definitionId, definition) != null) {
                throw new IllegalStateException("Duplicate shader ignored with ID " + String.valueOf(definitionId));
            }
            HashMap<String, Object> customProgramData = new HashMap<String, Object>();
            for (Int2ObjectMap.Entry shader : definition.shaders().int2ObjectEntrySet()) {
                int type = shader.getIntKey();
                ResourceLocation shaderId = (ResourceLocation)shader.getValue();
                FileToIdConverter typeConverter = this.sourceSet.getTypeConverter(type);
                ResourceLocation location = typeConverter.idToFile(shaderId);
                if (!checkedSources.add(location)) continue;
                Resource resource = resourceProvider.getResourceOrThrow(location);
                try {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        String source = IOUtils.toString((Reader)reader);
                        processor.prepare();
                        importProcessor.prepare();
                        HashSet<String> dependencies = new HashSet<String>();
                        Map<String, String> macros = definition.getMacros(dependencies, this.definitions);
                        DynamicBufferType.addMacros(activeBuffers, macros);
                        GlslTree tree = GlslParser.preprocessParse((String)source, macros);
                        Object2IntArrayMap uniformBindings = new Object2IntArrayMap();
                        PreProcessorContext preProcessorContext = new PreProcessorContext(customProgramData, importProcessor, definition, this.definitions, processorList.getShaderImporter(), activeBuffers, type, (Object2IntMap<String>)uniformBindings, macros, shaderId, true);
                        processor.modify(preProcessorContext, tree);
                        GlslTree.stripGLMacros(macros);
                        tree.getMacros().putAll(macros);
                        shaderSources.put(location, new VeilShaderSource(shaderId, tree.toSourceString(), (Object2IntMap<String>)uniformBindings, dependencies, new HashSet<ResourceLocation>(processorList.getShaderImporter().addedImports())));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Throwable t) {
                    throw new IOException("Failed to load " + ShaderManager.getTypeName(type) + " shader", t);
                    return;
                }
            }
        }
        catch (JsonParseException | IOException | IllegalArgumentException e) {
            Veil.LOGGER.error("Couldn't parse shader {} from {}", new Object[]{definitionId, this.sourceSet.getShaderDefinitionLister().idToFile(definitionId), e});
        }
    }

    private void compile(ShaderProgramImpl program, @Nullable ProgramDefinition definition, ShaderCompiler compiler) {
        ResourceLocation id = program.getName();
        try {
            program.compile(this.dynamicBufferManager.getActiveBuffers(), this.sourceSet, definition, compiler);
        }
        catch (ShaderException e) {
            Veil.LOGGER.error("Failed to create shader {}: {}", (Object)id, (Object)e.getMessage());
            String error = e.getGlError();
            if (error != null) {
                Veil.LOGGER.warn(error);
            }
        }
        catch (Exception e) {
            Veil.LOGGER.error("Failed to create shader: {}", (Object)id, (Object)e);
        }
    }

    public CompletableFuture<ShaderProgram> createDynamicProgram(ResourceLocation id, Int2ObjectMap<String> shaderSources) {
        DynamicShaderProgramImpl compileProgram;
        ShaderProgramImpl program = this.shaders.get(id);
        if (!(program instanceof DynamicShaderProgramImpl)) {
            if (program != null) {
                Veil.LOGGER.warn("Dynamic shader {} will overwrite the shader file until it is deleted!", (Object)id);
            }
            compileProgram = new DynamicShaderProgramImpl(id, () -> {
                if (program != null) {
                    this.shaders.put(id, program);
                } else {
                    this.shaders.remove(id);
                }
            });
            compileProgram.setOldShader(program);
            this.shaders.put(id, compileProgram);
        } else {
            DynamicShaderProgramImpl dynamicShaderProgram = (DynamicShaderProgramImpl)program;
            compileProgram = dynamicShaderProgram;
        }
        compileProgram.setShaderSources(shaderSources);
        int activeBuffers = VeilRenderSystem.renderer().getDynamicBufferManger().getActiveBuffers();
        return CompletableFuture.runAsync(() -> {
            ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
            ShaderProcessorList list = new ShaderProcessorList((ResourceProvider)resourceManager);
            this.addProcessors(list, (ResourceProvider)resourceManager);
            compileProgram.processShaderSources(list, this.definitions, activeBuffers);
        }, Util.backgroundExecutor()).thenApplyAsync(unused -> {
            try (ShaderCompiler compiler = ShaderCompiler.direct(null);){
                this.compile(compileProgram, null, compiler);
            }
            return compileProgram;
        }, VeilRenderSystem.renderThreadExecutor());
    }

    public void setGlobal(Consumer<ShaderProgram> setter) {
        this.shaders.values().forEach(setter);
    }

    @Nullable
    public ShaderProgram getShader(ResourceLocation id) {
        return this.shaders.get(id);
    }

    public Map<ResourceLocation, ShaderProgram> getShaders() {
        return this.shadersView;
    }

    public ShaderSourceSet getSourceSet() {
        return this.sourceSet;
    }

    private CompletableFuture<ReloadState> prepare(ResourceManager resourceManager, Collection<DynamicShaderProgramImpl> dynamicShaders, Collection<ResourceLocation> shaders, int activeBuffers, Executor executor) {
        ConcurrentHashMap definitions = new ConcurrentHashMap();
        ConcurrentHashMap shaderSources = new ConcurrentHashMap();
        Long2ObjectMap processorList = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectArrayMap());
        ConcurrentLinkedDeque<ResourceLocation> shaderQueue = new ConcurrentLinkedDeque<ResourceLocation>(shaders);
        ThreadTaskScheduler scheduler = new ThreadTaskScheduler("VeilShaderCompiler", Math.max(1, Runtime.getRuntime().availableProcessors() / 4), () -> {
            ResourceLocation key = (ResourceLocation)shaderQueue.poll();
            if (key == null) {
                return null;
            }
            return () -> {
                ShaderProcessorList shaderProcessor = (ShaderProcessorList)processorList.computeIfAbsent(Thread.currentThread().threadId(), id -> {
                    ShaderProcessorList list = new ShaderProcessorList((ResourceProvider)resourceManager);
                    this.addProcessors(list, (ResourceProvider)resourceManager);
                    return list;
                });
                shaderProcessor.getShaderImporter().reset();
                this.readShader(shaderProcessor, (ResourceProvider)resourceManager, definitions, shaderSources, key, activeBuffers);
            };
        });
        return CompletableFuture.allOf(scheduler.getCompletedFuture(), CompletableFuture.runAsync(() -> {
            ShaderProcessorList list = new ShaderProcessorList((ResourceProvider)resourceManager);
            this.addProcessors(list, (ResourceProvider)resourceManager);
            ShaderImporterImpl shaderImporter = list.getShaderImporter();
            for (DynamicShaderProgramImpl shader : dynamicShaders) {
                shaderImporter.reset();
                shader.processShaderSources(list, this.definitions, activeBuffers);
            }
        }, executor)).thenApply(unused -> new ReloadState(definitions, shaderSources));
    }

    private void apply(ReloadState reloadState) {
        Iterator<ShaderProgramImpl> iterator = this.shaders.values().iterator();
        while (iterator.hasNext()) {
            ShaderProgramImpl program = iterator.next();
            if (program instanceof DynamicShaderProgramImpl) {
                DynamicShaderProgramImpl dynamicShaderProgram = (DynamicShaderProgramImpl)program;
                ShaderProgramImpl old = dynamicShaderProgram.getOldShader();
                if (old == null) continue;
                old.free();
                continue;
            }
            program.free();
            iterator.remove();
        }
        try (ShaderCompiler compiler = reloadState.createCompiler();){
            for (Map.Entry<ResourceLocation, ProgramDefinition> entry : reloadState.definitions().entrySet()) {
                ProgramDefinition definition = entry.getValue();
                if (definition.compute() != null && !VeilRenderSystem.computeSupported()) {
                    Veil.LOGGER.info("Skipping compute shader '{}' (compute is unsupported on this platform)", (Object)entry.getKey());
                    continue;
                }
                ResourceLocation id = entry.getKey();
                ShaderProgramImpl program = new ShaderProgramImpl(id);
                this.compile(program, definition, compiler);
                DynamicShaderProgramImpl old = (DynamicShaderProgramImpl)this.shaders.put(id, program);
                if (old == null) continue;
                old.setOldShader(program);
            }
        }
        VeilClient.clientPlatform().onVeilCompileShaders(this, Collections.unmodifiableMap(this.shaders));
        Veil.LOGGER.info("Loaded {} shaders from: {}", (Object)this.shaders.size(), (Object)this.sourceSet.getFolder());
    }

    private void applyRecompile(ReloadState reloadState, Map<ResourceLocation, ShaderProgram> updatedShaders) {
        try (ShaderCompiler compiler = reloadState.createCompiler();){
            for (Map.Entry<ResourceLocation, ProgramDefinition> entry : reloadState.definitions().entrySet()) {
                ResourceLocation id = entry.getKey();
                ShaderProgramImpl program = this.shaders.get(id);
                if (program == null) {
                    Veil.LOGGER.warn("Failed to recompile shader: {}", (Object)id);
                    continue;
                }
                this.compile(program, entry.getValue(), compiler);
            }
        }
        VeilClient.clientPlatform().onVeilCompileShaders(this, updatedShaders);
        Veil.LOGGER.info("Recompiled {} shaders from: {}", (Object)updatedShaders.size(), (Object)this.sourceSet.getFolder());
    }

    private void scheduleRecompile(int attempt) {
        Minecraft client = Minecraft.getInstance();
        client.tell(() -> {
            ShaderProgram shader;
            HashSet<ResourceLocation> shaders;
            if (!this.recompileFuture.isDone()) {
                return;
            }
            Set<ResourceLocation> set = this.dirtyShaders;
            synchronized (set) {
                shaders = new HashSet<ResourceLocation>(this.dirtyShaders);
                this.dirtyShaders.clear();
            }
            HashMap<ResourceLocation, ShaderProgram> updatedShaders = new HashMap<ResourceLocation, ShaderProgram>(shaders.size());
            for (ResourceLocation id : shaders) {
                shader = this.getShader(id);
                if (shader == null) continue;
                updatedShaders.put(id, shader);
            }
            HashSet<DynamicShaderProgramImpl> dynamicShaderPrograms = new HashSet<DynamicShaderProgramImpl>();
            Iterator iterator = shaders.iterator();
            while (iterator.hasNext()) {
                shader = (ResourceLocation)iterator.next();
                ShaderProgramImpl program = this.shaders.get(shader);
                if (!(program instanceof DynamicShaderProgramImpl)) continue;
                DynamicShaderProgramImpl dynamicShaderProgram = (DynamicShaderProgramImpl)program;
                iterator.remove();
                dynamicShaderPrograms.add(dynamicShaderProgram);
            }
            int activeBuffers = this.dynamicBufferManager.getActiveBuffers();
            this.recompileFuture = ((CompletableFuture)this.prepare(client.getResourceManager(), dynamicShaderPrograms, shaders, activeBuffers, Util.backgroundExecutor()).thenAcceptAsync(state -> this.applyRecompile((ReloadState)state, Collections.unmodifiableMap(updatedShaders)), (Executor)client)).handle((value, e) -> {
                if (e != null) {
                    Veil.LOGGER.error("Error recompiling shaders", e);
                }
                Set<ResourceLocation> set = this.dirtyShaders;
                synchronized (set) {
                    if (this.dirtyShaders.isEmpty()) {
                        return value;
                    }
                }
                if (attempt >= 3) {
                    Veil.LOGGER.error("Failed to recompile shaders after {} attempts", (Object)attempt);
                    return value;
                }
                this.scheduleRecompile(attempt + 1);
                return value;
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async.Schedule
    public void scheduleRecompile(ResourceLocation shader) {
        Set<ResourceLocation> set = this.dirtyShaders;
        synchronized (set) {
            this.dirtyShaders.add(shader);
        }
        if (!this.recompileFuture.isDone()) {
            return;
        }
        this.scheduleRecompile(0);
    }

    @ApiStatus.Internal
    public void setActiveBuffers(int activeBuffers) {
        block6: {
            ShaderProgram active = null;
            try {
                HashSet<DynamicShaderProgramImpl> dynamicShaders = new HashSet<DynamicShaderProgramImpl>();
                HashSet<ResourceLocation> shaders = new HashSet<ResourceLocation>(this.shaders.size());
                HashMap<ResourceLocation, ShaderProgram> updatedShaders = new HashMap<ResourceLocation, ShaderProgram>();
                Iterator<ShaderProgramImpl> iterator = this.shaders.values().iterator();
                while (iterator.hasNext()) {
                    ShaderProgramImpl impl;
                    ShaderProgram program;
                    active = program = (ShaderProgram)iterator.next();
                    if (!(program instanceof ShaderProgramImpl) || !(impl = (ShaderProgramImpl)program).setActiveBuffers(activeBuffers)) continue;
                    if (program instanceof DynamicShaderProgramImpl) {
                        DynamicShaderProgramImpl dynamicShaderProgram = (DynamicShaderProgramImpl)program;
                        dynamicShaders.add(dynamicShaderProgram);
                    } else {
                        shaders.add(program.getName());
                    }
                    updatedShaders.put(program.getName(), program);
                }
                if (!shaders.isEmpty()) {
                    this.updateBuffersFuture = ((CompletableFuture)this.updateBuffersFuture.thenCompose(unused -> this.prepare(Minecraft.getInstance().getResourceManager(), dynamicShaders, shaders, activeBuffers, Util.backgroundExecutor()))).thenAcceptAsync(reloadState -> {
                        try (ShaderCompiler compiler = reloadState.createCompiler();){
                            for (Map.Entry<ResourceLocation, ProgramDefinition> entry : reloadState.definitions().entrySet()) {
                                ResourceLocation id = entry.getKey();
                                ShaderProgram program = this.getShader(id);
                                if (!(program instanceof ShaderProgramImpl)) {
                                    Veil.LOGGER.warn("Failed to set shader active buffers: {}", (Object)id);
                                    continue;
                                }
                                ShaderProgramImpl impl = (ShaderProgramImpl)program;
                                try {
                                    impl.recompile(activeBuffers, this.sourceSet, compiler);
                                }
                                catch (ShaderException e) {
                                    Veil.LOGGER.error("Failed to update shader active buffers: {}. {}", (Object)id, (Object)e.getMessage());
                                    String error = e.getGlError();
                                    if (error == null) continue;
                                    Veil.LOGGER.warn(error);
                                }
                                catch (Exception e) {
                                    Veil.LOGGER.error("Failed to update shader active buffers: {}", (Object)id, (Object)e);
                                }
                            }
                        }
                        VeilClient.clientPlatform().onVeilCompileShaders(this, Collections.unmodifiableMap(updatedShaders));
                        Veil.LOGGER.info("Compiled {} shaders from: {}", (Object)updatedShaders.size(), (Object)this.sourceSet.getFolder());
                    }, (Executor)Minecraft.getInstance());
                }
            }
            catch (ShaderException e) {
                Veil.LOGGER.error("Failed to set shader active buffers {}: {}", (Object)active.getName(), (Object)e.getMessage());
                String error = e.getGlError();
                if (error == null) break block6;
                Veil.LOGGER.warn(error);
            }
        }
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        HashSet<ResourceLocation> dynamicShaders = new HashSet<ResourceLocation>();
        for (ShaderProgramImpl program : this.shaders.values()) {
            if (!(program instanceof DynamicShaderProgramImpl)) continue;
            dynamicShaders.add(program.getName());
        }
        int activeBuffers = this.dynamicBufferManager.getActiveBuffers();
        return CompletableFuture.allOf(this.recompileFuture, this.updateBuffersFuture).thenComposeAsync(unused -> {
            FileToIdConverter lister = this.sourceSet.getShaderDefinitionLister();
            Set<ResourceLocation> shaderIds = lister.listMatchingResources(resourceManager).keySet().stream().map(arg_0 -> ((FileToIdConverter)lister).fileToId(arg_0)).filter(id -> !dynamicShaders.contains(id)).collect(Collectors.toSet());
            return ((CompletableFuture)this.prepare(resourceManager, Collections.emptySet(), shaderIds, activeBuffers, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0))).thenAcceptAsync(this::apply, gameExecutor);
        }, backgroundExecutor);
    }

    public String getName() {
        return this.getClass().getSimpleName() + " " + this.getSourceSet().getFolder();
    }

    public CompletableFuture<Void> getRecompileFuture() {
        return this.recompileFuture;
    }

    public CompletableFuture<Void> getUpdateBuffersFuture() {
        return this.updateBuffersFuture;
    }

    public static String getTypeName(int type) {
        String value = TYPES.get(type);
        return value != null ? value : "0x" + Integer.toHexString(type);
    }

    @Override
    public void close() {
        this.shaders.values().forEach(NativeResource::free);
        this.shaders.clear();
    }

    private record PreProcessorContext(Map<String, Object> customProgramData, ShaderPreProcessor preProcessor, @Nullable ProgramDefinition definition, ShaderPreDefinitions preDefinitions, ShaderImporter shaderImporter, int activeBuffers, int type, Object2IntMap<String> uniformBindings, Map<String, String> macros, @Nullable ResourceLocation name, boolean sourceFile) implements ShaderPreProcessor.VeilContext
    {
        @Override
        public GlslTree modifyInclude(@Nullable ResourceLocation name, String source) throws IOException, GlslSyntaxException, LexerException {
            GlslTree tree = GlslParser.preprocessParse((String)source, this.macros);
            PreProcessorContext context = new PreProcessorContext(this.customProgramData, this.preProcessor, this.definition, this.preDefinitions, this.shaderImporter, this.activeBuffers, this.type, this.uniformBindings, this.macros, name, false);
            this.preProcessor.modify(context, tree);
            return tree;
        }

        @Override
        public void addUniformBinding(String name, int binding) {
            this.uniformBindings.put((Object)name, binding);
        }

        @Override
        public boolean isSourceFile() {
            return this.sourceFile;
        }
    }

    private record ReloadState(Map<ResourceLocation, ProgramDefinition> definitions, Map<ResourceLocation, VeilShaderSource> shaderSources) {
        public ShaderCompiler createCompiler() {
            return ShaderCompiler.direct(name -> {
                VeilShaderSource source = this.shaderSources.get(name);
                if (source == null) {
                    throw new FileNotFoundException("Unknown shader source: " + String.valueOf(name));
                }
                return source;
            });
        }
    }
}

