/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.necromancer.render;

import foundry.veil.api.client.necromancer.Skeleton;
import foundry.veil.api.client.necromancer.render.NecromancerEntityRenderLayer;
import foundry.veil.api.client.necromancer.render.NecromancerEntityRenderer;
import foundry.veil.api.client.necromancer.render.NecromancerRenderer;
import foundry.veil.api.client.necromancer.render.Skin;
import foundry.veil.api.client.render.MatrixStack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;

public abstract class NecromancerSkinEntityRenderLayer<T extends Entity, M extends Skeleton>
extends NecromancerEntityRenderLayer<T, M> {
    public NecromancerSkinEntityRenderLayer(NecromancerEntityRenderer<T, M> renderer) {
        super(renderer);
    }

    @Nullable
    public abstract RenderType getRenderType(T var1);

    @Nullable
    public abstract Skin getSkin(T var1);

    @Override
    public void render(T parent, M skeleton, NecromancerRenderer renderer, MatrixStack matrixStack, int packedLight, float partialTicks) {
        Skin skin;
        RenderType renderType = this.getRenderType(parent);
        if (renderType != null && (skin = this.getSkin(parent)) != null) {
            this.renderSkin(parent, skeleton, skin, renderType, renderer, matrixStack, packedLight, partialTicks);
        }
    }

    protected void renderSkin(T parent, M skeleton, Skin skin, RenderType renderType, NecromancerRenderer renderer, MatrixStack matrixStack, int packedLight, float partialTicks) {
        renderer.setTransform((Matrix4fc)matrixStack.position());
        renderer.setLight(packedLight);
        renderer.draw(renderType, (Skeleton)skeleton, skin, partialTicks);
        renderer.reset();
    }
}

