/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.pipeline.client;

import com.mojang.blaze3d.vertex.PoseStack;
import foundry.veil.api.client.render.MatrixStack;
import java.util.Deque;
import org.joml.Matrix3f;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={PoseStack.class})
public abstract class PipelinePoseStackMixin
implements MatrixStack {
    @Unique
    private static final Matrix3f veil$IDENTITY_NORMAL = new Matrix3f();
    @Shadow
    @Final
    private Deque<PoseStack.Pose> poseStack;
    @Unique
    private final Quaternionf veil$castQuat = new Quaternionf();

    @Shadow
    public abstract void shadow$scale(float var1, float var2, float var3);

    @Shadow
    public abstract void shadow$mulPose(Quaternionf var1);

    @Shadow
    public abstract void shadow$rotateAround(Quaternionf var1, float var2, float var3, float var4);

    @Shadow
    public abstract void shadow$pushPose();

    @Shadow
    public abstract void shadow$popPose();

    @Shadow
    public abstract PoseStack.Pose last();

    @Override
    @Intrinsic
    public void clear() {
        while (this.poseStack.size() > 1) {
            this.shadow$popPose();
        }
    }

    @Override
    @Intrinsic
    public void translate(float x, float y, float z) {
        this.pose().pose().translate(x, y, z);
    }

    @Override
    @Intrinsic
    public void rotate(Quaterniondc rotation) {
        this.shadow$mulPose(this.veil$castQuat.set(rotation));
    }

    @Override
    public void rotate(Quaternionfc rotation) {
        this.shadow$mulPose(this.veil$castQuat.set(rotation));
    }

    @Override
    @Intrinsic
    public void rotate(float angle, float x, float y, float z) {
        this.shadow$mulPose(this.veil$castQuat.identity().rotateAxis(angle, x, y, z));
    }

    @Override
    @Intrinsic
    public void rotateXYZ(float x, float y, float z) {
        this.shadow$mulPose(this.veil$castQuat.identity().rotateXYZ(x, y, z));
    }

    @Override
    @Intrinsic
    public void rotateZYX(float z, float y, float x) {
        this.shadow$mulPose(this.veil$castQuat.identity().rotateZYX(z, y, x));
    }

    @Override
    @Intrinsic
    public void rotateAround(Quaterniondc rotation, double x, double y, double z) {
        this.shadow$rotateAround(this.veil$castQuat.set(rotation), (float)x, (float)y, (float)z);
    }

    @Override
    @Intrinsic
    public void rotateAround(Quaternionfc rotation, float x, float y, float z) {
        this.shadow$rotateAround(this.veil$castQuat.set(rotation), x, y, z);
    }

    @Override
    @Intrinsic
    public void applyScale(float x, float y, float z) {
        this.shadow$scale(x, y, z);
    }

    @Override
    @Intrinsic
    public boolean isIdentity() {
        PoseStack.Pose pose = this.pose();
        return (pose.pose().properties() & 4) != 0 && pose.normal().equals((Object)veil$IDENTITY_NORMAL);
    }

    @Override
    @Intrinsic
    public boolean isEmpty() {
        return this.poseStack.size() == 1;
    }

    @Override
    @Intrinsic
    public void matrixPush() {
        this.shadow$pushPose();
    }

    @Override
    @Intrinsic
    public void matrixPop() {
        this.shadow$popPose();
    }

    @Override
    @Intrinsic
    public PoseStack.Pose pose() {
        return this.poseStack.getLast();
    }

    @Override
    @Intrinsic
    public PoseStack toPoseStack() {
        return (PoseStack)this;
    }
}

