/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource;

import foundry.veil.api.resource.VeilResourceManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.Nullable;

public record VeilResourceInfo(PackType packType, ResourceLocation location, Path filePath, @Nullable Path modResourcePath, boolean hidden) {
    public Optional<Resource> getResource(VeilResourceManager resourceManager) {
        return resourceManager.resources(this).getResource(this.location);
    }

    public Resource getResourceOrThrow(VeilResourceManager resourceManager) throws FileNotFoundException {
        return this.getResource(resourceManager).orElseThrow(() -> new FileNotFoundException(this.location.toString()));
    }

    public InputStream open(VeilResourceManager resourceManager) throws IOException {
        return this.getResourceOrThrow(resourceManager).open();
    }

    public BufferedReader openAsReader(VeilResourceManager resourceManager) throws IOException {
        return this.getResourceOrThrow(resourceManager).openAsReader();
    }

    public String fileName() {
        String path = this.location().getPath();
        String[] split = path.split("/");
        return split[split.length - 1];
    }

    public boolean isStatic() {
        Path filePath = this.modResourcePath != null ? this.modResourcePath : this.filePath;
        return filePath == null || filePath.getFileSystem() != FileSystems.getDefault();
    }
}

