/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.processor;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.ShaderModificationManager;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import io.github.ocelot.glslprocessor.api.GlslSyntaxException;
import io.github.ocelot.glslprocessor.api.node.GlslTree;
import io.github.ocelot.glslprocessor.lib.anarres.cpp.LexerException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class ShaderModifyProcessor
implements ShaderPreProcessor {
    private final ShaderModificationManager shaderModificationManager = VeilRenderSystem.renderer().getShaderModificationManager();
    private final Set<ResourceLocation> appliedModifications = new HashSet<ResourceLocation>();

    @Override
    public void prepare() {
        this.appliedModifications.clear();
    }

    @Override
    public void modify(ShaderPreProcessor.Context ctx, GlslTree tree) throws IOException, GlslSyntaxException, LexerException {
        ResourceLocation name = ctx.name();
        if (name == null || !this.appliedModifications.add(name)) {
            return;
        }
        int flags = ctx.isSourceFile() ? 3 : 0;
        for (ResourceLocation include : ctx.shaderImporter().addedImports()) {
            this.shaderModificationManager.applyModifiers(include, tree, flags);
        }
        this.shaderModificationManager.applyModifiers(name, tree, flags);
    }
}

