/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.pipeline.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.Direction;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShaderInstance.class})
public abstract class PipelineShaderInstanceMixin {
    @Unique
    private static final Direction[] veil$DIRECTIONS = Direction.values();

    @Shadow
    @Nullable
    public abstract Uniform getUniform(String var1);

    @Inject(method={"setDefaultUniforms"}, at={@At(value="TAIL")})
    public void setDefaultUniforms(VertexFormat.Mode mode, Matrix4f projectionMatrix, Matrix4f frustrumMatrix, Window window, CallbackInfo ci) {
        ClientLevel level;
        Uniform iModelViewMat;
        Uniform renderTime = this.getUniform("VeilRenderTime");
        if (renderTime != null) {
            renderTime.set((float)(System.currentTimeMillis() % 3600000L) / 1000.0f);
        }
        if ((iModelViewMat = this.getUniform("NormalMat")) != null) {
            iModelViewMat.set(projectionMatrix.normal(new Matrix3f()));
        }
        if ((level = Minecraft.getInstance().level) != null) {
            for (Direction value : veil$DIRECTIONS) {
                Uniform uniform = this.getUniform("VeilBlockFaceBrightness[" + value.get3DDataValue() + "]");
                if (uniform == null) continue;
                uniform.set(level.getShade(value, true));
            }
        }
    }
}

