/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.performance.client;

import com.llamalad7.mixinextras.sugar.Local;
import foundry.veil.api.client.render.VeilRenderSystem;
import net.minecraft.client.renderer.texture.AbstractTexture;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractTexture.class})
public abstract class PerformanceAbstractTextureMixin {
    @Unique
    private boolean veil$initialized;

    @Shadow
    public abstract int getId();

    @Inject(method={"setFilter"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/AbstractTexture;bind()V")}, cancellable=true)
    public void setFilterDSA(boolean blur, boolean mipmap, CallbackInfo ci, @Local(ordinal=0) int minFilter, @Local(ordinal=1) int magFilter) {
        if (!this.veil$initialized || !VeilRenderSystem.directStateAccessSupported()) {
            return;
        }
        ci.cancel();
        int id = this.getId();
        ARBDirectStateAccess.glTextureParameteri((int)id, (int)10241, (int)minFilter);
        ARBDirectStateAccess.glTextureParameteri((int)id, (int)10240, (int)magFilter);
    }

    @Inject(method={"bind"}, at={@At(value="TAIL")})
    public void bind(CallbackInfo ci) {
        this.veil$initialized = true;
    }
}

