/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.resource;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import foundry.veil.api.resource.VeilResource;
import foundry.veil.impl.resource.tree.VeilResourceFolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.system.NativeResource;

@ApiStatus.Internal
public class VeilPackResources
implements NativeResource {
    private final String name;
    private final VeilResourceFolder root;
    private int texture;

    public VeilPackResources(String name) {
        this.name = name;
        this.root = new VeilResourceFolder(name);
    }

    public void add(@Nullable PackType packType, ResourceLocation loc, VeilResource<?> resource) {
        if (packType != null) {
            this.root.addResource(packType.getDirectory() + "/" + loc.getNamespace() + "/" + loc.getPath(), resource);
        } else {
            this.root.addResource(loc.getPath(), resource);
        }
    }

    @Nullable
    public VeilResource<?> getVeilResource(String namespace, String path) {
        VeilResourceFolder folder = this.root.getFolder(namespace);
        if (folder == null) {
            return null;
        }
        String[] parts = path.split("/");
        for (int i = 0; i < parts.length - 1; ++i) {
            if ((folder = folder.getFolder(parts[i])) != null) continue;
            return null;
        }
        return folder.getResource(parts[parts.length - 1]);
    }

    public void loadIcon(NativeImage image, boolean blur) {
        if (this.texture == 0) {
            this.texture = GL11C.glGenTextures();
        }
        TextureUtil.prepareImage((int)this.texture, (int)image.getWidth(), (int)image.getHeight());
        GL11C.glTexParameteri((int)3553, (int)10241, (int)(blur ? 9729 : 9728));
        GL11C.glTexParameteri((int)3553, (int)10240, (int)(blur ? 9729 : 9728));
        image.upload(0, 0, 0, false);
    }

    public String getName() {
        return this.name;
    }

    public VeilResourceFolder getRoot() {
        return this.root;
    }

    public int getTexture() {
        return this.texture;
    }

    public void free() {
        if (this.texture != 0) {
            GL11C.glDeleteTextures((int)this.texture);
            this.texture = 0;
        }
    }
}

