/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.dynamicbuffer;

import com.google.common.base.Stopwatch;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.ext.ShaderInstanceExtension;
import foundry.veil.impl.ThreadTaskScheduler;
import foundry.veil.impl.client.render.shader.processor.VanillaShaderProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.FileUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class VanillaShaderCompiler {
    private static final Set<String> LAST_FRAME_SHADERS = ConcurrentHashMap.newKeySet();
    private ThreadTaskScheduler scheduler;

    private void compileShader(ShaderInstance shader, int activeBuffers) {
        ShaderInstanceExtension extension = (ShaderInstanceExtension)shader;
        Collection<ResourceLocation> shaderSources = extension.veil$getShaderSources();
        VertexFormat vertexFormat = shader.getVertexFormat();
        HashMap<String, Object> customProgramData = new HashMap<String, Object>();
        final ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        VanillaShaderProcessor.setup((ResourceProvider)resourceManager);
        for (final ResourceLocation path : shaderSources) {
            try {
                BufferedReader reader = resourceManager.openAsReader(path);
                try {
                    String source = IOUtils.toString((Reader)reader);
                    GlslPreprocessor preprocessor = new GlslPreprocessor(this){
                        private final Set<String> importedPaths = new HashSet<String>();

                        public String applyImport(boolean useFullPath, @NotNull String directory) {
                            String string;
                            block12: {
                                if (useFullPath) {
                                    directory = FileUtil.normalizeResourcePath((String)(path.getPath() + directory));
                                } else if ((directory = FileUtil.normalizeResourcePath((String)("shaders/include/" + directory))).indexOf(58) != -1) {
                                    ResourceLocation contained = ResourceLocation.parse((String)directory);
                                    String finalDirectory = directory;
                                    directory = contained.withPath(path -> path.replace(finalDirectory, (CharSequence)path)).toString();
                                }
                                if (!this.importedPaths.add(directory)) {
                                    return null;
                                }
                                ResourceLocation resourcelocation = ResourceLocation.parse((String)directory);
                                BufferedReader reader = resourceManager.openAsReader(resourcelocation);
                                try {
                                    string = IOUtils.toString((Reader)reader);
                                    if (reader == null) break block12;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (reader != null) {
                                            try {
                                                ((Reader)reader).close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (IOException e) {
                                        Veil.LOGGER.error("Could not open GLSL import {}: {}", (Object)directory, (Object)e.getMessage());
                                        return "#error " + e.getMessage();
                                    }
                                }
                                ((Reader)reader).close();
                            }
                            return string;
                        }
                    };
                    source = String.join((CharSequence)"", preprocessor.process(source));
                    boolean vertex = path.getPath().endsWith(".vsh");
                    String processed = VanillaShaderProcessor.modify(customProgramData, shader.getName(), path, vertexFormat, activeBuffers, vertex ? 35633 : 35632, source);
                    Minecraft.getInstance().execute(() -> extension.veil$recompile(vertex, processed, activeBuffers));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Throwable t) {
                Veil.LOGGER.error("Couldn't load vanilla shader from {}", (Object)path, (Object)t);
            }
        }
        VanillaShaderProcessor.free();
    }

    public CompletableFuture<?> reload(Collection<ShaderInstance> shaders) {
        ThreadTaskScheduler scheduler;
        if (this.scheduler != null) {
            this.scheduler.cancel();
        }
        ConcurrentHashMap<String, ShaderInstance> shaderMap = new ConcurrentHashMap<String, ShaderInstance>(shaders.size());
        for (ShaderInstance shader : shaders) {
            shaderMap.put(shader.getName(), shader);
        }
        int activeBuffers = VeilRenderSystem.renderer().getDynamicBufferManger().getActiveBuffers();
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.scheduler = scheduler = new ThreadTaskScheduler("VeilVanillaShaderCompile", Math.max(1, Runtime.getRuntime().availableProcessors() / 6), () -> {
            for (String lastFrameShader : LAST_FRAME_SHADERS) {
                ShaderInstance shader = (ShaderInstance)shaderMap.remove(lastFrameShader);
                if (shader == null) continue;
                return () -> this.compileShader(shader, activeBuffers);
            }
            Iterator iterator = shaderMap.values().iterator();
            if (iterator.hasNext()) {
                ShaderInstance shader = (ShaderInstance)iterator.next();
                iterator.remove();
                return () -> this.compileShader(shader, activeBuffers);
            }
            return null;
        });
        CompletableFuture<?> future = scheduler.getCompletedFuture();
        future.thenRunAsync(() -> {
            if (!scheduler.isCancelled()) {
                Veil.LOGGER.info("Compiled {} vanilla shaders in {}", (Object)shaders.size(), (Object)stopwatch.stop());
            }
        }, (Executor)Minecraft.getInstance());
        return future.isDone() ? CompletableFuture.completedFuture(null) : future;
    }

    public boolean isCompilingShaders() {
        return this.scheduler != null && !this.scheduler.getCompletedFuture().isDone();
    }

    @ApiStatus.Internal
    public static void markRendered(String shaderInstace) {
        if (VeilRenderSystem.renderer().getVanillaShaderCompiler().isCompilingShaders()) {
            LAST_FRAME_SHADERS.add(shaderInstace);
        }
    }

    @ApiStatus.Internal
    public static void clear() {
        LAST_FRAME_SHADERS.clear();
    }
}

