/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.forge.platform;

import foundry.veil.forge.ext.DeferredRegisterExtensions;
import foundry.veil.platform.registry.RegistrationProvider;
import foundry.veil.platform.registry.RegistryObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NeoForgeRegistrationFactory
implements RegistrationProvider.Factory {
    @Override
    public <T> RegistrationProvider<T> create(ResourceKey<? extends Registry<T>> resourceKey, String modId) {
        ModContainer container = (ModContainer)ModList.get().getModContainerById(modId).orElseThrow(() -> new NullPointerException("Cannot find mod container for id " + modId));
        if (!(container instanceof FMLModContainer)) {
            throw new ClassCastException("The container of the mod " + modId + " is not a FML one!");
        }
        FMLModContainer forgeContainer = (FMLModContainer)container;
        DeferredRegister register = DeferredRegister.create(resourceKey, (String)modId);
        if (!BuiltInRegistries.REGISTRY.containsKey(resourceKey.location())) {
            register.makeRegistry(builder -> builder.sync(false));
        }
        register.register(Objects.requireNonNull(forgeContainer.getEventBus()));
        return new Provider(modId, register);
    }

    private static class Provider<T>
    implements RegistrationProvider<T> {
        private final String modId;
        private final DeferredRegister<T> registry;
        private final Set<RegistryObject<T>> entries = new HashSet<RegistryObject<T>>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries);

        private Provider(String modId, DeferredRegister<T> registry) {
            this.modId = modId;
            this.registry = registry;
        }

        @Override
        public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> supplier) {
            DeferredHolder obj = this.registry.register(name, supplier);
            NeoForgeRegistryObject ro = new NeoForgeRegistryObject(obj);
            this.entries.add(ro);
            return ro;
        }

        @Override
        public <I extends T> RegistryObject<I> register(ResourceLocation id, Supplier<? extends I> supplier) {
            DeferredHolder obj = ((DeferredRegisterExtensions)this.registry).register(id, supplier);
            NeoForgeRegistryObject ro = new NeoForgeRegistryObject(obj);
            this.entries.add(ro);
            return ro;
        }

        @Override
        public Collection<RegistryObject<T>> getEntries() {
            return this.entriesView;
        }

        @Override
        public Registry<T> asVanillaRegistry() {
            return Objects.requireNonNull((Registry)this.registry.getRegistry().get(), "Vanilla registry was not created");
        }

        @Override
        public String getModId() {
            return this.modId;
        }
    }

    private record NeoForgeRegistryObject<T, I extends T>(DeferredHolder<I, I> holder) implements RegistryObject<I>
    {
        @Override
        public ResourceKey<I> getResourceKey() {
            return this.holder.getKey();
        }

        @Override
        public boolean isPresent() {
            return this.holder.isBound();
        }

        @Override
        public I get() {
            return (I)this.holder.get();
        }

        @Override
        public Holder<I> asHolder() {
            return this.holder;
        }
    }
}

