/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.forge.network;

import foundry.veil.api.network.VeilPacketManager;
import foundry.veil.api.network.handler.ClientPacketContext;
import foundry.veil.api.network.handler.PacketContext;
import foundry.veil.api.network.handler.ServerPacketContext;
import foundry.veil.forge.network.NeoForgeClientPacketContext;
import foundry.veil.forge.network.NeoForgeServerPacketContext;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NeoForgeVeilPacketManager
implements VeilPacketManager {
    private final String version;
    private final Set<RegisteredPacket<ClientPacketContext>> clientPackets;
    private final Set<RegisteredPacket<ServerPacketContext>> serverPackets;

    public NeoForgeVeilPacketManager(String modId, String version) {
        ModContainer container = (ModContainer)ModList.get().getModContainerById(modId).orElseThrow(() -> new NullPointerException("Cannot find mod container for id " + modId));
        if (!(container instanceof FMLModContainer)) {
            throw new ClassCastException("The container of the mod " + modId + " is not a FML one!");
        }
        FMLModContainer forgeContainer = (FMLModContainer)container;
        this.version = version;
        this.clientPackets = new ObjectArraySet();
        this.serverPackets = new ObjectArraySet();
        Objects.requireNonNull(forgeContainer.getEventBus()).addListener(this::registerHandler);
    }

    private void registerHandler(RegisterPayloadHandlersEvent event) {
        VeilPacketManager.PacketHandler handler;
        PayloadRegistrar registrar = event.registrar(this.version);
        for (RegisteredPacket<ClientPacketContext> registeredPacket : this.clientPackets) {
            handler = registeredPacket.handler;
            registrar.playToClient(registeredPacket.id, registeredPacket.codec, (payload, context) -> handler.handlePacket(payload, new NeoForgeClientPacketContext(context)));
        }
        for (RegisteredPacket<PacketContext> registeredPacket : this.serverPackets) {
            handler = registeredPacket.handler;
            registrar.playToServer(registeredPacket.id, registeredPacket.codec, (payload, context) -> handler.handlePacket(payload, new NeoForgeServerPacketContext(context)));
        }
    }

    @Override
    public <T extends CustomPacketPayload> void registerClientbound(CustomPacketPayload.Type<T> id, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, VeilPacketManager.PacketHandler<ClientPacketContext, T> handler) {
        this.clientPackets.add(new RegisteredPacket<ClientPacketContext>(id, codec, handler));
    }

    @Override
    public <T extends CustomPacketPayload> void registerServerbound(CustomPacketPayload.Type<T> id, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, VeilPacketManager.PacketHandler<ServerPacketContext, T> handler) {
        this.serverPackets.add(new RegisteredPacket<ServerPacketContext>(id, codec, handler));
    }

    private record RegisteredPacket<T extends PacketContext>(CustomPacketPayload.Type<? extends CustomPacketPayload> id, StreamCodec<? super RegistryFriendlyByteBuf, ?> codec, VeilPacketManager.PacketHandler<T, ?> handler) {
    }
}

