/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.forge.mixin.resources;

import com.mojang.datafixers.util.Pair;
import cpw.mods.niofs.union.UnionFileSystem;
import foundry.veil.Veil;
import foundry.veil.ext.PackResourcesExtension;
import foundry.veil.forge.impl.ForgePackHooks;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={PathPackResources.class})
public abstract class PathPackResourcesMixin
implements PackResources,
PackResourcesExtension {
    @Shadow
    @Final
    private Path root;
    @Unique
    private String[] veil$icon;
    @Unique
    private boolean veil$iconBlur;

    @Shadow
    @Nullable
    public abstract IoSupplier<InputStream> getRootResource(String ... var1);

    @Override
    public void veil$listResources(final PackResourcesExtension.PackResourceConsumer consumer) {
        String packId = this.packId();
        final FileSystem fileSystem = this.root.getFileSystem();
        final String separator = fileSystem.getSeparator();
        for (final PackType type : PackType.values()) {
            final Path assetPath = this.root.resolve(type.getDirectory());
            if (!Files.exists(assetPath, new LinkOption[0])) continue;
            try {
                Files.walkFileTree(assetPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        String path;
                        String[] parts = assetPath.relativize(file).toString().replace(separator, "/").split("/", 2);
                        String namespace = parts.length == 1 ? "root" : parts[0];
                        ResourceLocation name = ResourceLocation.tryBuild((String)namespace, (String)(path = parts.length == 1 ? parts[0] : parts[1]));
                        if (name != null) {
                            UnionFileSystem unionFs;
                            Path packPath = assetPath;
                            Path filePath = file;
                            Path modResourcePath = null;
                            if (fileSystem instanceof UnionFileSystem && Files.isDirectory((unionFs = (UnionFileSystem)fileSystem).getPrimaryPath(), new LinkOption[0])) {
                                Path primaryPath = unionFs.getPrimaryPath();
                                Path buildDir = primaryPath.getParent().getParent().getParent();
                                Path buildPath = buildDir.resolve("resources").resolve(primaryPath.getFileName());
                                packPath = buildPath.getFileSystem().getPath(packPath.toString(), new String[0]);
                                filePath = buildPath.resolve(file.toString());
                                modResourcePath = PackResourcesExtension.findDevPath(buildPath, filePath);
                            }
                            consumer.accept(type, name, packPath, filePath, modResourcePath);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                Veil.LOGGER.warn("Failed to list resources in {} failed!", (Object)packId, (Object)e);
            }
        }
    }

    @Override
    public boolean veil$isStatic() {
        return this.root.getFileSystem() != FileSystems.getDefault();
    }

    @Override
    public List<Path> veil$getRawResourceRoots() {
        return Collections.singletonList(this.root);
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> veil$getIcon() {
        if (this.veil$icon == null) {
            Pair<String, Boolean> pair = ForgePackHooks.getIcon(this.root);
            this.veil$icon = pair != null ? ((String)pair.getFirst()).split("[/\\\\]") : new String[]{};
            this.veil$iconBlur = pair != null && (Boolean)pair.getSecond() != false;
        }
        return this.veil$icon.length == 0 ? this.getRootResource("pack.png") : this.getRootResource(this.veil$icon);
    }

    @Override
    public boolean veil$blurIcon() {
        return this.veil$iconBlur;
    }
}

