/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.emitters.shape;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import foundry.veil.api.quasar.emitters.shape.EmitterShape;
import net.minecraft.util.RandomSource;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Disc
implements EmitterShape {
    @Override
    public Vector3d getPoint(RandomSource randomSource, Vector3fc dimensions, Vector3fc rotation, Vector3dc position, boolean fromSurface) {
        double x = randomSource.nextGaussian();
        double y = 1.0E-7;
        double z = randomSource.nextGaussian();
        Vector3d normal = new Vector3d(x, y, z).normalize();
        Vector3fc dim = dimensions;
        if (!fromSurface) {
            normal.mul(randomSource.nextDouble()).normalize();
            dim = dimensions.mul(randomSource.nextFloat(), randomSource.nextFloat(), randomSource.nextFloat(), new Vector3f());
        }
        Vector3d pos = normal.mul(dim);
        pos = pos.rotateX((double)((float)Math.toRadians(rotation.x()))).rotateY((double)((float)Math.toRadians(rotation.y()))).rotateZ((double)((float)Math.toRadians(rotation.z())));
        return pos.add(position);
    }

    @Override
    public void renderShape(PoseStack stack, VertexConsumer consumer, Vector3fc dimensions, Vector3fc rotation) {
        float radius = dimensions.x();
        float angle = 0.0f;
        float angleStep = 11.25f;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (int i = 0; i < 32; ++i) {
            float x1 = (float)((double)x + Math.cos(Math.toRadians(angle)) * (double)radius);
            float z1 = (float)((double)z + Math.sin(Math.toRadians(angle)) * (double)radius);
            float x2 = (float)((double)x + Math.cos(Math.toRadians(angle + angleStep)) * (double)radius);
            float z2 = (float)((double)z + Math.sin(Math.toRadians(angle + angleStep)) * (double)radius);
            consumer.addVertex(stack.last().pose(), x1, y, z1).setColor(0.15f, 0.15f, 1.0f, 1.0f).setNormal(0.0f, 1.0f, 0.0f);
            angle += angleStep;
        }
    }
}

