/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.texture;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.client.color.Color;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.util.EnumCodec;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.nio.IntBuffer;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL14C;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.system.MemoryStack;

public record TextureFilter(boolean blur, boolean mipmap, float anisotropy, @Nullable CompareFunction compareFunction, Wrap wrapX, Wrap wrapY, Wrap wrapZ, int borderColor, EdgeType borderType, boolean seamless) {
    private final float anisotropy;
    public static final Codec<TextureFilter> REPEAT_DEFAULT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("blur", (Object)false).forGetter(TextureFilter::blur), (App)Codec.BOOL.optionalFieldOf("mipmap", (Object)false).forGetter(TextureFilter::mipmap), (App)Codec.FLOAT.optionalFieldOf("anisotropy", (Object)Float.valueOf(1.0f)).forGetter(TextureFilter::anisotropy), (App)CompareFunction.CODEC.optionalFieldOf("compareFunction").forGetter(options -> Optional.ofNullable(options.compareFunction())), (App)Wrap.CODEC.optionalFieldOf("wrapX", (Object)Wrap.REPEAT).forGetter(TextureFilter::wrapX), (App)Wrap.CODEC.optionalFieldOf("wrapY", (Object)Wrap.REPEAT).forGetter(TextureFilter::wrapY), (App)Wrap.CODEC.optionalFieldOf("wrapZ", (Object)Wrap.REPEAT).forGetter(TextureFilter::wrapZ), (App)Color.ARGB_INT_CODEC.optionalFieldOf("borderColor", (Object)-16777216).forGetter(TextureFilter::borderColor), (App)EdgeType.CODEC.optionalFieldOf("borderType", (Object)EdgeType.FLOAT).forGetter(TextureFilter::borderType), (App)Codec.BOOL.optionalFieldOf("seamless", (Object)false).forGetter(TextureFilter::seamless)).apply((Applicative)instance, (blur, mipmap, anisotropy, compareFunction, wrapX, wrapY, wrapZ, edgeColor, edgeType, seamless) -> new TextureFilter((boolean)blur, (boolean)mipmap, anisotropy.floatValue(), compareFunction.orElse(null), (Wrap)((Object)((Object)wrapX)), (Wrap)((Object)((Object)wrapY)), (Wrap)((Object)((Object)wrapZ)), (int)edgeColor, (EdgeType)((Object)((Object)edgeType)), (boolean)seamless)));
    public static final Codec<TextureFilter> CLAMP_DEFAULT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("blur", (Object)false).forGetter(TextureFilter::blur), (App)Codec.BOOL.optionalFieldOf("mipmap", (Object)false).forGetter(TextureFilter::mipmap), (App)Codec.FLOAT.optionalFieldOf("anisotropy", (Object)Float.valueOf(1.0f)).forGetter(TextureFilter::anisotropy), (App)CompareFunction.CODEC.optionalFieldOf("compareFunction").forGetter(options -> Optional.ofNullable(options.compareFunction())), (App)Wrap.CODEC.optionalFieldOf("wrapX", (Object)Wrap.CLAMP_TO_EDGE).forGetter(TextureFilter::wrapX), (App)Wrap.CODEC.optionalFieldOf("wrapY", (Object)Wrap.CLAMP_TO_EDGE).forGetter(TextureFilter::wrapY), (App)Wrap.CODEC.optionalFieldOf("wrapZ", (Object)Wrap.CLAMP_TO_EDGE).forGetter(TextureFilter::wrapZ), (App)Color.ARGB_INT_CODEC.optionalFieldOf("borderColor", (Object)-16777216).forGetter(TextureFilter::borderColor), (App)EdgeType.CODEC.optionalFieldOf("borderType", (Object)EdgeType.FLOAT).forGetter(TextureFilter::borderType), (App)Codec.BOOL.optionalFieldOf("seamless", (Object)false).forGetter(TextureFilter::seamless)).apply((Applicative)instance, (blur, mipmap, anisotropy, compareFunction, wrapX, wrapY, wrapZ, edgeColor, edgeType, seamless) -> new TextureFilter((boolean)blur, (boolean)mipmap, anisotropy.floatValue(), compareFunction.orElse(null), (Wrap)((Object)((Object)wrapX)), (Wrap)((Object)((Object)wrapY)), (Wrap)((Object)((Object)wrapZ)), (int)edgeColor, (EdgeType)((Object)((Object)edgeType)), (boolean)seamless)));
    public static final TextureFilter REPEAT = new TextureFilter(false, false, 1.0f, null, Wrap.REPEAT, Wrap.REPEAT, Wrap.REPEAT, -16777216, EdgeType.FLOAT, false);
    public static final TextureFilter CLAMP = new TextureFilter(false, false, 1.0f, null, Wrap.CLAMP_TO_EDGE, Wrap.CLAMP_TO_EDGE, Wrap.CLAMP_TO_EDGE, -16777216, EdgeType.FLOAT, false);

    public float anisotropy() {
        return Math.min(this.anisotropy, VeilRenderSystem.maxTextureAnisotropy());
    }

    public int minFilter() {
        if (this.blur) {
            return this.mipmap ? 9987 : 9729;
        }
        return this.mipmap ? 9986 : 9728;
    }

    public int magFilter() {
        return this.blur ? 9729 : 9728;
    }

    /*
     * Unable to fully structure code
     */
    public void applyToTextureTarget(int target) {
        GL14C.glTexParameteri((int)target, (int)10241, (int)this.minFilter());
        GL14C.glTexParameteri((int)target, (int)10240, (int)this.magFilter());
        if (VeilRenderSystem.textureAnisotropySupported()) {
            GL14C.glTexParameterf((int)target, (int)34046, (float)this.anisotropy());
        }
        if (this.compareFunction != null) {
            GL14C.glTexParameteri((int)target, (int)34892, (int)34894);
            GL14C.glTexParameteri((int)target, (int)34893, (int)this.compareFunction.id);
        } else {
            GL14C.glTexParameteri((int)target, (int)34892, (int)0);
        }
        GL14C.glTexParameteri((int)target, (int)10242, (int)this.wrapX.id);
        GL14C.glTexParameteri((int)target, (int)10243, (int)this.wrapY.id);
        GL14C.glTexParameteri((int)target, (int)32882, (int)this.wrapZ.id);
        stack = MemoryStack.stackPush();
        try {
            data = stack.ints(this.borderColor >> 16 & 255, this.borderColor >> 8 & 255, this.borderColor & 255, this.borderColor >> 24 & 255);
            switch (this.borderType.ordinal()) {
                case 0: {
                    GL14C.glTexParameteriv((int)target, (int)4100, (IntBuffer)data);
                    ** break;
lbl20:
                    // 1 sources

                    break;
                }
                case 1: {
                    GL33C.glTexParameterIiv((int)target, (int)4100, (IntBuffer)data);
                    ** break;
lbl24:
                    // 1 sources

                    break;
                }
                case 2: {
                    GL33C.glTexParameterIuiv((int)target, (int)4100, (IntBuffer)data);
                    break;
                }
                ** default:
lbl29:
                // 1 sources

                break;
            }
        }
        finally {
            if (stack != null) {
                stack.close();
            }
        }
        if (VeilRenderSystem.textureCubeMapSeamlessSupported()) {
            GL14C.glTexParameteri((int)target, (int)34895, (int)(this.seamless != false ? 1 : 0));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void applyToTexture(int texture) {
        ARBDirectStateAccess.glTextureParameteri((int)texture, (int)10241, (int)this.minFilter());
        ARBDirectStateAccess.glTextureParameteri((int)texture, (int)10240, (int)this.magFilter());
        if (VeilRenderSystem.textureAnisotropySupported()) {
            ARBDirectStateAccess.glTextureParameterf((int)texture, (int)34046, (float)this.anisotropy());
        }
        if (this.compareFunction != null) {
            ARBDirectStateAccess.glTextureParameteri((int)texture, (int)34892, (int)34894);
            ARBDirectStateAccess.glTextureParameteri((int)texture, (int)34893, (int)this.compareFunction.id);
        } else {
            ARBDirectStateAccess.glTextureParameteri((int)texture, (int)34892, (int)0);
        }
        ARBDirectStateAccess.glTextureParameteri((int)texture, (int)10242, (int)this.wrapX.id);
        ARBDirectStateAccess.glTextureParameteri((int)texture, (int)10243, (int)this.wrapY.id);
        ARBDirectStateAccess.glTextureParameteri((int)texture, (int)32882, (int)this.wrapZ.id);
        stack = MemoryStack.stackPush();
        try {
            data = stack.ints(this.borderColor >> 16 & 255, this.borderColor >> 8 & 255, this.borderColor & 255, this.borderColor >> 24 & 255);
            switch (this.borderType.ordinal()) {
                case 0: {
                    ARBDirectStateAccess.glTextureParameteriv((int)texture, (int)4100, (IntBuffer)data);
                    ** break;
lbl20:
                    // 1 sources

                    break;
                }
                case 1: {
                    ARBDirectStateAccess.glTextureParameterIiv((int)texture, (int)4100, (IntBuffer)data);
                    ** break;
lbl24:
                    // 1 sources

                    break;
                }
                case 2: {
                    ARBDirectStateAccess.glTextureParameterIuiv((int)texture, (int)4100, (IntBuffer)data);
                    break;
                }
                ** default:
lbl29:
                // 1 sources

                break;
            }
        }
        finally {
            if (stack != null) {
                stack.close();
            }
        }
        if (VeilRenderSystem.textureCubeMapSeamlessSupported()) {
            ARBDirectStateAccess.glTextureParameteri((int)texture, (int)34895, (int)(this.seamless != false ? 1 : 0));
        }
    }

    public static enum CompareFunction {
        NEVER(512),
        ALWAYS(519),
        LESS(513),
        LEQUAL(515),
        EQUAL(514),
        NOT_EQUAL(517),
        GEQUAL(518),
        GREATER(516);

        public static final Codec<CompareFunction> CODEC;
        private final int id;

        private CompareFunction(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        static {
            CODEC = EnumCodec.builder("Compare Function").values(CompareFunction.class).build();
        }
    }

    public static enum Wrap {
        CLAMP_TO_EDGE(33071),
        CLAMP_TO_BORDER(33069),
        MIRRORED_REPEAT(33648),
        REPEAT(10497),
        MIRROR_CLAMP_TO_EDGE(34627);

        public static final Codec<Wrap> CODEC;
        public static final Int2ObjectMap<Wrap> BY_GL_ID;
        private final int id;

        private Wrap(int id) {
            this.id = id;
        }

        public int getId() {
            return this == MIRROR_CLAMP_TO_EDGE && !VeilRenderSystem.textureMirrorClampToEdgeSupported() ? 33071 : this.id;
        }

        static {
            CODEC = EnumCodec.builder("Texture Wrap").values(Wrap.class).build();
            Int2ObjectArrayMap map = new Int2ObjectArrayMap();
            for (Wrap filter : Wrap.values()) {
                map.put(filter.id, (Object)filter);
            }
            BY_GL_ID = Int2ObjectMaps.unmodifiable((Int2ObjectMap)map);
        }
    }

    public static enum EdgeType {
        FLOAT,
        INT,
        UINT;

        public static final Codec<EdgeType> CODEC;

        static {
            CODEC = EnumCodec.builder("Edge Data Type").values(EdgeType.class).build();
        }
    }
}

