/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.texture;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.shader.texture.FramebufferSource;
import foundry.veil.api.client.render.shader.texture.LocationSource;
import foundry.veil.api.client.render.texture.TextureFilter;
import foundry.veil.api.util.EnumCodec;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferManger;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public sealed interface ShaderTextureSource
permits LocationSource, FramebufferSource {
    public static final Codec<ShaderTextureSource> CODEC = Codec.either((Codec)ResourceLocation.CODEC, (Codec)Type.CODEC.dispatch(ShaderTextureSource::type, Type::codec)).xmap(either -> (ShaderTextureSource)either.map(name -> new LocationSource((ResourceLocation)name, null), right -> right), source -> {
        Either either;
        if (source instanceof LocationSource) {
            LocationSource loc = (LocationSource)source;
            either = Either.left((Object)loc.location());
        } else {
            either = Either.right((Object)source);
        }
        return either;
    });
    public static final Context GLOBAL_CONTEXT = name -> VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(name);

    public int getId(Context var1);

    @Nullable
    public TextureFilter filter();

    public Type type();

    public static enum Type {
        LOCATION(LocationSource.CODEC),
        FRAMEBUFFER(FramebufferSource.CODEC);

        private final MapCodec<? extends ShaderTextureSource> codec;
        public static final Codec<Type> CODEC;

        private Type(MapCodec<? extends ShaderTextureSource> codec) {
            this.codec = codec;
        }

        public MapCodec<? extends ShaderTextureSource> codec() {
            return this.codec;
        }

        static {
            CODEC = EnumCodec.builder("texture type").values(Type.class).build();
        }
    }

    @FunctionalInterface
    public static interface Context {
        @Nullable
        public AdvancedFbo getFramebuffer(ResourceLocation var1);

        default public int getTexture(ResourceLocation name) {
            if ("veil".equals(name.getNamespace()) && name.getPath().startsWith("dynamic_buffer")) {
                DynamicBufferManger bufferManger = VeilRenderSystem.renderer().getDynamicBufferManger();
                if (name.equals((Object)VeilRenderer.ALBEDO_BUFFER_TEXTURE)) {
                    return bufferManger.getBufferTexture(DynamicBufferType.ALBEDO);
                }
                if (name.equals((Object)VeilRenderer.NORMAL_BUFFER_TEXTURE)) {
                    return bufferManger.getBufferTexture(DynamicBufferType.NORMAL);
                }
                if (name.equals((Object)VeilRenderer.LIGHT_UV_BUFFER_TEXTURE)) {
                    return bufferManger.getBufferTexture(DynamicBufferType.LIGHT_UV);
                }
                if (name.equals((Object)VeilRenderer.LIGHT_COLOR_BUFFER_TEXTURE)) {
                    return bufferManger.getBufferTexture(DynamicBufferType.LIGHT_COLOR);
                }
                if (name.equals((Object)VeilRenderer.DEBUG_BUFFER_TEXTURE)) {
                    return bufferManger.getBufferTexture(DynamicBufferType.DEBUG);
                }
            }
            return Minecraft.getInstance().getTextureManager().getTexture(name).getId();
        }
    }
}

