/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.framebuffer;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.ext.VeilDebug;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.AdvancedFboAttachment;
import foundry.veil.api.client.render.texture.TextureFilter;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL30C;

public class AdvancedFboTextureAttachment
extends AbstractTexture
implements AdvancedFboAttachment {
    private final int attachmentType;
    private final int format;
    private final int internalFormat;
    private final int width;
    private final int height;
    private final int mipmapLevels;
    private final TextureFilter filter;
    private final String name;

    public AdvancedFboTextureAttachment(int attachmentType, int internalFormat, int format, int width, int height, int mipmapLevels, TextureFilter filter, @Nullable String name) {
        this.attachmentType = attachmentType;
        this.format = format;
        this.internalFormat = internalFormat;
        this.width = width;
        this.height = height;
        this.mipmapLevels = mipmapLevels;
        this.filter = filter;
        this.name = name;
    }

    public void setFilter(boolean blur, boolean mipmap) {
        int magFilter;
        int minFilter;
        RenderSystem.assertOnRenderThreadOrInit();
        this.blur = blur;
        this.mipmap = mipmap;
        if (blur) {
            minFilter = mipmap ? 9987 : 9729;
            magFilter = 9729;
        } else {
            minFilter = mipmap ? 9986 : 9728;
            magFilter = 9728;
        }
        if (VeilRenderSystem.directStateAccessSupported()) {
            int texture = this.getId();
            ARBDirectStateAccess.glTextureParameteri((int)texture, (int)10241, (int)minFilter);
            ARBDirectStateAccess.glTextureParameteri((int)texture, (int)10240, (int)magFilter);
        } else {
            this.bind();
            GL30C.glTexParameteri((int)3553, (int)10241, (int)minFilter);
            GL30C.glTexParameteri((int)3553, (int)10240, (int)magFilter);
        }
    }

    @Override
    public void attach(AdvancedFbo framebuffer, int attachment) {
        Validate.isTrue((this.attachmentType < 36096 || attachment == 0 ? 1 : 0) != 0, (String)"Only one depth buffer attachment is supported.", (Object[])new Object[0]);
        int id = this.getId();
        if (VeilRenderSystem.directStateAccessSupported()) {
            ARBDirectStateAccess.glNamedFramebufferTexture((int)framebuffer.getId(), (int)(this.attachmentType + attachment), (int)id, (int)0);
        } else {
            GL30C.glFramebufferTexture2D((int)36160, (int)(this.attachmentType + attachment), (int)3553, (int)id, (int)0);
        }
        String debugLabel = framebuffer.getDebugLabel();
        if (debugLabel != null) {
            if (this.attachmentType == 36096) {
                VeilDebug.get().objectLabel(5890, id, "Advanced Fbo " + debugLabel + " Depth Texture");
            } else {
                VeilDebug.get().objectLabel(5890, id, "Advanced Fbo " + debugLabel + " Texture " + String.valueOf(this.name != null ? this.name : Integer.valueOf(attachment)));
            }
        }
    }

    @Override
    public void create() {
        this.bind();
        this.setFilter(this.filter.blur(), this.filter.mipmap());
        GL30C.glTexParameteri((int)3553, (int)33085, (int)(this.mipmapLevels - 1));
        GL30C.glTexParameteri((int)3553, (int)33082, (int)0);
        GL30C.glTexParameteri((int)3553, (int)33083, (int)(this.mipmapLevels - 1));
        GL30C.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        this.filter.applyToTextureTarget(3553);
        for (int i = 0; i < this.mipmapLevels; ++i) {
            GL30C.glTexImage2D((int)3553, (int)i, (int)this.internalFormat, (int)(this.width >> i), (int)(this.height >> i), (int)0, (int)this.format, (int)5121, (ByteBuffer)null);
        }
    }

    public int getId() {
        RenderSystem.assertOnRenderThreadOrInit();
        if (this.id == -1) {
            this.id = VeilRenderSystem.createTextures(3553);
        }
        return this.id;
    }

    @Override
    public AdvancedFboTextureAttachment clone() {
        return new AdvancedFboTextureAttachment(this.attachmentType, this.internalFormat, this.format, this.width, this.height, this.mipmapLevels, this.filter, this.name);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdvancedFboTextureAttachment that = (AdvancedFboTextureAttachment)o;
        return this.attachmentType == that.attachmentType && this.internalFormat == that.internalFormat && this.width == that.width && this.height == that.height && this.mipmapLevels == that.mipmapLevels && this.filter.equals(that.filter) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        int result = this.attachmentType;
        result = 31 * result + this.internalFormat;
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.mipmapLevels;
        result = 31 * result + this.filter.hashCode();
        result = 31 * result + Objects.hashCode(this.name);
        return result;
    }

    @Override
    public void bindAttachment() {
        this.bind();
    }

    @Override
    public void unbindAttachment() {
        VeilRenderSystem.renderThreadExecutor().execute(() -> RenderSystem.bindTexture((int)0));
    }

    @Override
    public int getAttachmentType() {
        return this.attachmentType;
    }

    @Override
    public int getFormat() {
        return this.internalFormat;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public int getLevels() {
        return this.mipmapLevels;
    }

    public TextureFilter getFilter() {
        return this.filter;
    }

    @Override
    public boolean canSample() {
        return true;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    public void free() {
        this.releaseId();
    }

    public void load(ResourceManager manager) {
    }
}

