/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import foundry.veil.api.client.render.CameraMatrices;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.compat.SodiumCompat;
import foundry.veil.ext.RenderTargetExtension;
import foundry.veil.impl.client.render.perspective.IrisPipelineAccess;
import foundry.veil.impl.client.render.perspective.LevelPerspectiveCamera;
import foundry.veil.mixin.perspective.accessor.GameRendererAccessor;
import foundry.veil.mixin.perspective.accessor.LevelRendererAccessor;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3dc;
import org.joml.Vector3f;

public final class VeilLevelPerspectiveRenderer {
    private static final LevelPerspectiveCamera CAMERA = new LevelPerspectiveCamera();
    private static final Matrix4f TRANSFORM = new Matrix4f();
    private static final AtomicInteger ID = new AtomicInteger();
    private static final CameraMatrices BACKUP_CAMERA_MATRICES = new CameraMatrices();
    private static final Matrix4f BACKUP_PROJECTION = new Matrix4f();
    private static final Vector3f BACKUP_LIGHT0_POSITION = new Vector3f();
    private static final Vector3f BACKUP_LIGHT1_POSITION = new Vector3f();
    private static boolean renderingPerspective = false;

    private VeilLevelPerspectiveRenderer() {
    }

    public static AdvancedFbo render(AdvancedFbo framebuffer, Matrix4fc modelView, Matrix4fc projection, Vector3dc cameraPosition, Quaternionfc cameraOrientation, float renderDistance, DeltaTracker deltaTracker, boolean drawLights) {
        return VeilLevelPerspectiveRenderer.render(framebuffer, Minecraft.getInstance().cameraEntity, modelView, projection, cameraPosition, cameraOrientation, renderDistance, deltaTracker, drawLights);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdvancedFbo render(AdvancedFbo framebuffer, @Nullable Entity cameraEntity, Matrix4fc modelView, Matrix4fc projection, Vector3dc cameraPosition, Quaternionfc cameraOrientation, float renderDistance, DeltaTracker deltaTracker, boolean drawLights) {
        Object backupTaskLists;
        Object backupRenderLists;
        if (renderingPerspective) {
            return framebuffer;
        }
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        bufferSource.endBatch();
        Minecraft minecraft = Minecraft.getInstance();
        GameRenderer gameRenderer = minecraft.gameRenderer;
        LevelRenderer levelRenderer = minecraft.levelRenderer;
        LevelRendererAccessor levelRendererAccessor = (LevelRendererAccessor)levelRenderer;
        Window window = minecraft.getWindow();
        GameRendererAccessor accessor = (GameRendererAccessor)gameRenderer;
        RenderTargetExtension renderTargetExtension = (RenderTargetExtension)minecraft.getMainRenderTarget();
        PoseStack poseStack = new PoseStack();
        CAMERA.setup(cameraPosition, cameraEntity, minecraft.level, cameraOrientation, renderDistance);
        poseStack.mulPose(TRANSFORM.set(modelView));
        poseStack.mulPose(CAMERA.rotation());
        float backupRenderDistance = gameRenderer.getRenderDistance();
        accessor.setRenderDistance(renderDistance * 16.0f);
        float backupFogStart = RenderSystem.getShaderFogStart();
        float backupFogEnd = RenderSystem.getShaderFogEnd();
        FogShape backupFogShape = RenderSystem.getShaderFogShape();
        int backupWidth = window.getWidth();
        int backupHeight = window.getHeight();
        window.setWidth(framebuffer.getWidth());
        window.setHeight(framebuffer.getHeight());
        Object backupPipeline = IrisPipelineAccess.getPipeline(levelRenderer);
        if (SodiumCompat.isLoaded()) {
            backupRenderLists = SodiumCompat.INSTANCE.getSortedRenderLists();
            backupTaskLists = SodiumCompat.INSTANCE.getTaskLists();
            ID.getAndIncrement();
        } else {
            backupRenderLists = null;
            backupTaskLists = null;
        }
        BACKUP_PROJECTION.set((Matrix4fc)RenderSystem.getProjectionMatrix());
        gameRenderer.resetProjectionMatrix(TRANSFORM.set(projection));
        BACKUP_LIGHT0_POSITION.set(VeilRenderSystem.getLight0Direction());
        BACKUP_LIGHT1_POSITION.set(VeilRenderSystem.getLight1Direction());
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        matrix4fstack.pushMatrix();
        matrix4fstack.identity();
        RenderSystem.applyModelViewMatrix();
        HitResult backupHitResult = minecraft.hitResult;
        Entity backupCrosshairPickEntity = minecraft.crosshairPickEntity;
        renderingPerspective = true;
        AdvancedFbo drawFbo = VeilRenderSystem.renderer().getDynamicBufferManger().getDynamicFbo(framebuffer);
        drawFbo.bind(true);
        renderTargetExtension.veil$setWrapper(drawFbo);
        Frustum backupFrustum = levelRendererAccessor.getCullingFrustum();
        CameraMatrices matrices = VeilRenderSystem.renderer().getCameraMatrices();
        matrices.backup(BACKUP_CAMERA_MATRICES);
        try {
            levelRenderer.prepareCullFrustum(new Vec3(cameraPosition.x(), cameraPosition.y(), cameraPosition.z()), poseStack.last().pose(), TRANSFORM);
            levelRenderer.renderLevel(deltaTracker, false, (Camera)CAMERA, gameRenderer, gameRenderer.lightTexture(), poseStack.last().pose(), TRANSFORM);
            bufferSource.endBatch();
            levelRenderer.doEntityOutline();
            if (drawLights) {
                ProfilerFiller profiler = Minecraft.getInstance().getProfiler();
                if (VeilRenderSystem.drawLights(profiler, VeilRenderSystem.getCullingFrustum())) {
                    VeilRenderSystem.compositeLights(profiler);
                } else {
                    AdvancedFbo.unbind();
                }
            }
        }
        finally {
            matrices.restore(BACKUP_CAMERA_MATRICES);
            levelRendererAccessor.setCullingFrustum(backupFrustum);
            renderTargetExtension.veil$setWrapper(null);
            AdvancedFbo.unbind();
            renderingPerspective = false;
            minecraft.crosshairPickEntity = backupCrosshairPickEntity;
            minecraft.hitResult = backupHitResult;
            matrix4fstack.popMatrix();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShaderLights((Vector3f)BACKUP_LIGHT0_POSITION, (Vector3f)BACKUP_LIGHT1_POSITION);
            gameRenderer.resetProjectionMatrix(BACKUP_PROJECTION);
            IrisPipelineAccess.setPipeline(levelRenderer, backupPipeline);
            if (SodiumCompat.isLoaded()) {
                SodiumCompat.INSTANCE.setSortedRenderLists(backupRenderLists);
                SodiumCompat.INSTANCE.setTaskList(backupTaskLists);
            }
            RenderSystem.setShaderFogStart((float)backupFogStart);
            RenderSystem.setShaderFogEnd((float)backupFogEnd);
            RenderSystem.setShaderFogShape((FogShape)backupFogShape);
            window.setWidth(backupWidth);
            window.setHeight(backupHeight);
            accessor.setRenderDistance(backupRenderDistance);
            Camera mainCamera = gameRenderer.getMainCamera();
            minecraft.getBlockEntityRenderDispatcher().prepare((Level)minecraft.level, mainCamera, minecraft.hitResult);
            minecraft.getEntityRenderDispatcher().prepare((Level)minecraft.level, mainCamera, minecraft.crosshairPickEntity);
        }
        return drawFbo;
    }

    public static boolean isRenderingPerspective() {
        return renderingPerspective;
    }

    @ApiStatus.Internal
    public static int getID() {
        return ID.get();
    }
}

