/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.necromancer.render;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.necromancer.Skeleton;
import foundry.veil.api.client.render.MatrixStack;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.block.DynamicShaderBlock;
import foundry.veil.api.client.render.vertex.VertexArray;
import foundry.veil.api.client.render.vertex.VertexArrayBuilder;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;

public class Skin
implements NativeResource {
    private final VertexArray vertexArray;
    private final Object2IntMap<String> boneIds;
    private final Vector4f color;
    private int instances;
    private final Matrix3f normalMatrix;
    private Matrix4x3f[] matrixStack;
    private Quaternionf[] orientationStack;

    public Skin(VertexArray vertexArray, Object2IntMap<String> boneIds) {
        this.vertexArray = vertexArray;
        this.boneIds = boneIds;
        this.color = new Vector4f();
        this.normalMatrix = new Matrix3f();
        this.matrixStack = null;
        this.orientationStack = null;
    }

    @ApiStatus.Internal
    public void render(RenderType renderType, List<Matrix4x3f> transforms, List<Skeleton> skeletons, int instancedBuffer, ByteBufferBuilder boneBuilder, int boneBuffer, DynamicShaderBlock<?> boneBlock, FloatList partialTicks) {
        if (skeletons.isEmpty()) {
            return;
        }
        if (this.instances != skeletons.size()) {
            VertexArrayBuilder format = this.vertexArray.editFormat();
            format.defineVertexBuffer(1, instancedBuffer, 0, 8, 1);
            if (this.instances == 0) {
                format.setVertexIAttribute(4, 1, 1, VertexArrayBuilder.DataType.UNSIGNED_BYTE, 0);
                format.setVertexIAttribute(5, 1, 1, VertexArrayBuilder.DataType.UNSIGNED_BYTE, 1);
                format.setVertexAttribute(6, 1, 4, VertexArrayBuilder.DataType.UNSIGNED_BYTE, true, 2);
            }
            this.instances = skeletons.size();
        }
        Skeleton first = skeletons.getFirst();
        int maxDepth = first.getMaxDepth();
        if (this.matrixStack == null || this.matrixStack.length < maxDepth) {
            this.matrixStack = new Matrix4x3f[maxDepth];
            this.orientationStack = new Quaternionf[maxDepth];
            for (int i = 0; i < maxDepth; ++i) {
                this.matrixStack[i] = new Matrix4x3f();
                this.orientationStack[i] = new Quaternionf();
            }
        }
        int skeletonDataSize = 112 * this.getSkeletonDataSize();
        int size = skeletonDataSize * skeletons.size();
        ByteBuffer buffer = MemoryUtil.memByteBuffer((long)boneBuilder.reserve(size), (int)size);
        for (int i = 0; i < skeletons.size(); ++i) {
            Skeleton skeleton = skeletons.get(i);
            for (int j = 0; j < maxDepth; ++j) {
                this.matrixStack[j].identity();
            }
            buffer.position(i * skeletonDataSize);
            skeleton.storeInstancedData(buffer, skeleton.roots, this.boneIds, 0, this.color, this.normalMatrix, transforms.get(i), this.matrixStack, this.orientationStack, partialTicks.getFloat(i));
        }
        buffer.rewind();
        ByteBufferBuilder.Result result = boneBuilder.build();
        if (result != null) {
            result.close();
        }
        if (VeilRenderSystem.directStateAccessSupported()) {
            ARBDirectStateAccess.glNamedBufferSubData((int)boneBuffer, (long)0L, (ByteBuffer)buffer);
        } else {
            GL15C.glBindBuffer((int)35345, (int)boneBuffer);
            GL15C.glBufferSubData((int)35345, (long)0L, (ByteBuffer)buffer);
        }
        this.vertexArray.bind();
        renderType.setupRenderState();
        VeilRenderSystem.bind("NecromancerBones", boneBlock);
        ShaderInstance shader = RenderSystem.getShader();
        if (shader != null) {
            shader.setDefaultUniforms(VertexFormat.Mode.TRIANGLES, RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), Minecraft.getInstance().getWindow());
            shader.apply();
            Uniform uniform = shader.getUniform("NecromancerBoneCount");
            if (uniform != null) {
                GL30C.glUniform1ui((int)uniform.getLocation(), (int)this.boneIds.size());
            }
        }
        this.vertexArray.drawInstanced(skeletons.size());
        if (shader != null) {
            shader.clear();
        }
        VeilRenderSystem.unbind(boneBlock);
        renderType.clearRenderState();
    }

    public VertexArray getVertexArray() {
        return this.vertexArray;
    }

    public int getSkeletonDataSize() {
        return this.boneIds.size();
    }

    public static VertexArray createVertexArray() {
        RenderSystem.assertOnRenderThreadOrInit();
        VertexArray vertexArray = VertexArray.create();
        int vbo = vertexArray.getOrCreateBuffer(0);
        VertexArrayBuilder format = vertexArray.editFormat();
        format.defineVertexBuffer(0, vbo, 0, 24, 0);
        format.setVertexAttribute(0, 0, 3, VertexArrayBuilder.DataType.FLOAT, false, 0);
        format.setVertexAttribute(1, 0, 2, VertexArrayBuilder.DataType.FLOAT, false, 12);
        format.setVertexAttribute(2, 0, 3, VertexArrayBuilder.DataType.BYTE, true, 20);
        format.setVertexIAttribute(3, 0, 1, VertexArrayBuilder.DataType.UNSIGNED_BYTE, 23);
        VertexArray.unbind();
        return vertexArray;
    }

    public void free() {
        this.vertexArray.free();
    }

    public static Builder builder(int textureWidth, int textureHeight) {
        return new Builder(textureWidth, textureHeight);
    }

    public static class Builder {
        private static final Vector3f POS = new Vector3f();
        private static final Vector3f NORMAL = new Vector3f();
        private final VertexArray vertexArray = Skin.createVertexArray();
        private final ByteBufferBuilder vertices = new ByteBufferBuilder(147456);
        private final IntList indices = new IntArrayList();
        private final List<String> boneNames = new ArrayList<String>();
        private final float textureWidth;
        private final float textureHeight;
        private final Matrix4f position;
        private final Matrix3f normal;
        private int nextIndex;

        public Builder(float textureWidth, float textureHeight) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.position = new Matrix4f();
            this.normal = new Matrix3f();
            this.nextIndex = 0;
        }

        private static byte normalIntValue(float value) {
            return (byte)((int)(Mth.clamp((float)value, (float)-1.0f, (float)1.0f) * 127.0f) & 0xFF);
        }

        public Builder startBone(String boneId) {
            if (this.boneNames.contains(boneId)) {
                throw new IllegalStateException("Bone '" + boneId + "' has already defined mesh data");
            }
            if (this.boneNames.size() >= 256) {
                throw new IllegalStateException("Too many bones defined. Max is 256");
            }
            this.boneNames.add(boneId);
            return this;
        }

        public Builder setTransform(MatrixStack stack) {
            return this.setTransform((Matrix4fc)stack.position());
        }

        public Builder setTransform(PoseStack stack) {
            return this.setTransform(stack.last());
        }

        public Builder setTransform(PoseStack.Pose pose) {
            return this.setTransform((Matrix4fc)pose.pose());
        }

        public Builder setTransform(Matrix4fc position) {
            this.position.set(position);
            this.position.normal(this.normal);
            return this;
        }

        public Builder addVertex(float x, float y, float z, float u, float v, float normalX, float normalY, float normalZ) {
            if (this.boneNames.isEmpty()) {
                throw new IllegalStateException("No bone specified. Call #startBone(String) to start building a mesh.");
            }
            this.position.transformPosition(x, y, z, POS);
            this.normal.transform(normalX, normalY, normalZ, NORMAL);
            long pointer = this.vertices.reserve(24);
            MemoryUtil.memPutFloat((long)pointer, (float)Builder.POS.x);
            MemoryUtil.memPutFloat((long)(pointer + 4L), (float)Builder.POS.y);
            MemoryUtil.memPutFloat((long)(pointer + 8L), (float)Builder.POS.z);
            MemoryUtil.memPutFloat((long)(pointer + 12L), (float)u);
            MemoryUtil.memPutFloat((long)(pointer + 16L), (float)v);
            MemoryUtil.memPutByte((long)(pointer + 20L), (byte)Builder.normalIntValue(Builder.NORMAL.x));
            MemoryUtil.memPutByte((long)(pointer + 21L), (byte)Builder.normalIntValue(Builder.NORMAL.y));
            MemoryUtil.memPutByte((long)(pointer + 22L), (byte)Builder.normalIntValue(Builder.NORMAL.z));
            MemoryUtil.memPutByte((long)(pointer + 23L), (byte)((byte)(this.boneNames.size() - 1)));
            return this;
        }

        public Builder addIndex(int index) {
            this.indices.add(index);
            if (index > this.nextIndex) {
                this.nextIndex = index + 1;
            }
            return this;
        }

        public Builder addQuadIndices(int index) {
            this.addIndex(index);
            this.addIndex(index + 1);
            this.addIndex(index + 2);
            this.addIndex(index + 2);
            this.addIndex(index + 3);
            this.addIndex(index);
            return this;
        }

        public Builder addMirroredQuadIndices(int index) {
            this.addIndex(index);
            this.addIndex(index + 3);
            this.addIndex(index + 2);
            this.addIndex(index + 2);
            this.addIndex(index + 1);
            this.addIndex(index);
            return this;
        }

        public Builder addCube(float xSize, float ySize, float zSize, float xOffset, float yOffset, float zOffset, float xInflate, float yInflate, float zInflate, float uOffset, float vOffset, boolean mirrored) {
            float minX = xOffset;
            float minY = yOffset;
            float minZ = zOffset;
            float maxX = xOffset + xSize;
            float maxY = yOffset + ySize;
            float maxZ = zOffset + zSize;
            minX -= xInflate;
            minY -= yInflate;
            minZ -= zInflate;
            maxX += xInflate;
            maxY += yInflate;
            maxZ += zInflate;
            if (mirrored) {
                float swap = maxX;
                maxX = minX;
                minX = swap;
            }
            float eastUStart = uOffset;
            float northUStart = uOffset + (float)Mth.floor((float)zSize);
            float westUStart = uOffset + (float)Mth.floor((float)zSize) + (float)Mth.floor((float)xSize);
            float southUStart = uOffset + (float)Mth.floor((float)zSize) + (float)Mth.floor((float)xSize) + (float)Mth.floor((float)xSize);
            float southUEnd = uOffset + (float)Mth.floor((float)zSize) + (float)Mth.floor((float)xSize) + (float)Mth.floor((float)zSize) + (float)Mth.floor((float)xSize);
            float topVStart = vOffset;
            float sideVStart = vOffset + (float)Mth.floor((float)zSize);
            float sideVEnd = vOffset + (float)Mth.floor((float)zSize) + (float)Mth.floor((float)ySize);
            this.addVertex(minX, maxY, minZ, northUStart / this.textureWidth, sideVStart / this.textureHeight, 0.0f, 1.0f, 0.0f);
            this.addVertex(minX, maxY, maxZ, northUStart / this.textureWidth, topVStart / this.textureHeight, 0.0f, 1.0f, 0.0f);
            this.addVertex(maxX, maxY, maxZ, westUStart / this.textureWidth, topVStart / this.textureHeight, 0.0f, 1.0f, 0.0f);
            this.addVertex(maxX, maxY, minZ, westUStart / this.textureWidth, sideVStart / this.textureHeight, 0.0f, 1.0f, 0.0f);
            this.addVertex(maxX, minY, maxZ, westUStart / this.textureWidth, topVStart / this.textureHeight, 0.0f, -1.0f, 0.0f);
            this.addVertex(minX, minY, maxZ, southUStart / this.textureWidth, topVStart / this.textureHeight, 0.0f, -1.0f, 0.0f);
            this.addVertex(minX, minY, minZ, southUStart / this.textureWidth, sideVStart / this.textureHeight, 0.0f, -1.0f, 0.0f);
            this.addVertex(maxX, minY, minZ, westUStart / this.textureWidth, sideVStart / this.textureHeight, 0.0f, -1.0f, 0.0f);
            this.addVertex(maxX, minY, maxZ, eastUStart / this.textureWidth, sideVEnd / this.textureHeight, 1.0f, 0.0f, 0.0f);
            this.addVertex(maxX, minY, minZ, northUStart / this.textureWidth, sideVEnd / this.textureHeight, 1.0f, 0.0f, 0.0f);
            this.addVertex(maxX, maxY, minZ, northUStart / this.textureWidth, sideVStart / this.textureHeight, 1.0f, 0.0f, 0.0f);
            this.addVertex(maxX, maxY, maxZ, eastUStart / this.textureWidth, sideVStart / this.textureHeight, 1.0f, 0.0f, 0.0f);
            this.addVertex(minX, minY, minZ, westUStart / this.textureWidth, sideVEnd / this.textureHeight, -1.0f, 0.0f, 0.0f);
            this.addVertex(minX, minY, maxZ, southUStart / this.textureWidth, sideVEnd / this.textureHeight, -1.0f, 0.0f, 0.0f);
            this.addVertex(minX, maxY, maxZ, southUStart / this.textureWidth, sideVStart / this.textureHeight, -1.0f, 0.0f, 0.0f);
            this.addVertex(minX, maxY, minZ, westUStart / this.textureWidth, sideVStart / this.textureHeight, -1.0f, 0.0f, 0.0f);
            this.addVertex(maxX, minY, minZ, northUStart / this.textureWidth, sideVEnd / this.textureHeight, 0.0f, 0.0f, -1.0f);
            this.addVertex(minX, minY, minZ, westUStart / this.textureWidth, sideVEnd / this.textureHeight, 0.0f, 0.0f, -1.0f);
            this.addVertex(minX, maxY, minZ, westUStart / this.textureWidth, sideVStart / this.textureHeight, 0.0f, 0.0f, -1.0f);
            this.addVertex(maxX, maxY, minZ, northUStart / this.textureWidth, sideVStart / this.textureHeight, 0.0f, 0.0f, -1.0f);
            this.addVertex(minX, minY, maxZ, southUStart / this.textureWidth, sideVEnd / this.textureHeight, 0.0f, 0.0f, 1.0f);
            this.addVertex(maxX, minY, maxZ, southUEnd / this.textureWidth, sideVEnd / this.textureHeight, 0.0f, 0.0f, 1.0f);
            this.addVertex(maxX, maxY, maxZ, southUEnd / this.textureWidth, sideVStart / this.textureHeight, 0.0f, 0.0f, 1.0f);
            this.addVertex(minX, maxY, maxZ, southUStart / this.textureWidth, sideVStart / this.textureHeight, 0.0f, 0.0f, 1.0f);
            for (int i = 0; i < 6; ++i) {
                if (mirrored) {
                    this.addMirroredQuadIndices(this.nextIndex);
                    continue;
                }
                this.addQuadIndices(this.nextIndex);
            }
            return this;
        }

        public Builder addTri(float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3, float normalX, float normalY, float normalZ) {
            this.vertices.reserve(72);
            this.addVertex(x1, y1, z1, u1, v1, normalX, normalY, normalZ);
            this.addVertex(x2, y2, z2, u2, v2, normalX, normalY, normalZ);
            this.addVertex(x3, y3, z3, u3, v3, normalX, normalY, normalZ);
            this.addIndex(this.nextIndex);
            this.addIndex(this.nextIndex);
            this.addIndex(this.nextIndex);
            return this;
        }

        public Builder addFace(float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3, float x4, float y4, float z4, float u4, float v4, float normalX, float normalY, float normalZ) {
            this.vertices.reserve(96);
            this.addVertex(x1, y1, z1, u1, v1, normalX, normalY, normalZ);
            this.addVertex(x2, y2, z2, u2, v2, normalX, normalY, normalZ);
            this.addVertex(x3, y3, z3, u3, v3, normalX, normalY, normalZ);
            this.addVertex(x4, y4, z4, u4, v4, normalX, normalY, normalZ);
            this.addQuadIndices(this.nextIndex);
            return this;
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        private void storeIndices(VertexArray.IndexType indexType, ByteBuffer buffer) {
            block5: for (int i = 0; i < this.indices.size(); ++i) {
                int index = this.indices.getInt(i);
                switch (indexType) {
                    case BYTE: {
                        buffer.put(i, (byte)index);
                        continue block5;
                    }
                    case SHORT: {
                        buffer.putShort(i * 2, (short)index);
                        continue block5;
                    }
                    case INT: {
                        buffer.putInt(i * 4, index);
                    }
                }
            }
        }

        /*
         * Exception decompiling
         */
        public Skin build() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

