/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.color;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import foundry.veil.api.client.color.Colorc;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;

public class Color
implements Colorc {
    public static final Codec<Integer> RGB_INT_CODEC = new ColorCodec(false);
    public static final Codec<Integer> ARGB_INT_CODEC = new ColorCodec(true);
    public static final Codec<Color> RGB_CODEC = RGB_INT_CODEC.xmap(Color::new, Colorc::argb);
    public static final Codec<Color> ARGB_CODEC = ARGB_INT_CODEC.xmap(Color::new, Colorc::argb);
    public static final Colorc WHITE = new Color(-1);
    public static final Colorc BLACK = new Color(-16777216);
    public static final Colorc RED = new Color(-65536);
    public static final Colorc GREEN = new Color(-16711936);
    public static final Colorc BLUE = new Color(-16776961);
    public static final Colorc TRANSPARENT = new Color(0);
    public static final Colorc VANILLA_TOOLTIP_BACKGROUND = new Color(-267386864);
    public static final Colorc VANILLA_TOOLTIP_BORDER_TOP = new Color(0x505000FF);
    public static final Colorc VANILLA_TOOLTIP_BORDER_BOTTOM = new Color(1344798847);
    private float red;
    private float green;
    private float blue;
    private float alpha;

    public Color() {
        this.red = 0.0f;
        this.green = 0.0f;
        this.blue = 0.0f;
        this.alpha = 1.0f;
    }

    public Color(int rgb) {
        this(rgb, false);
    }

    public Color(int color, boolean alpha) {
        if (alpha) {
            this.setARGB(color);
        } else {
            this.setARGB(0xFF000000 | color);
        }
    }

    public Color(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public Color(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public Color(Colorc copy) {
        this.red = copy.red();
        this.green = copy.green();
        this.blue = copy.blue();
        this.alpha = copy.alpha();
    }

    public Color red(float red) {
        this.red = red;
        return this;
    }

    public Color green(float green) {
        this.green = green;
        return this;
    }

    public Color blue(float blue) {
        this.blue = blue;
        return this;
    }

    public Color alpha(float alpha) {
        this.alpha = alpha;
        return this;
    }

    public Color redInt(int red) {
        return this.red((float)red / 255.0f);
    }

    public Color greenInt(int green) {
        return this.green((float)green / 255.0f);
    }

    public Color blueInt(int blue) {
        return this.blue((float)blue / 255.0f);
    }

    public Color alphaInt(int alpha) {
        return this.alpha((float)alpha / 255.0f);
    }

    public Color set(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        return this;
    }

    public Color set(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        return this;
    }

    public Color setInt(int red, int green, int blue) {
        return this.set((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
    }

    public Color setInt(int red, int green, int blue, int alpha) {
        return this.set((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
    }

    public Color setRGB(int rgb) {
        return this.setInt(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public Color setARGB(int argb) {
        return this.setInt(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, argb >> 24 & 0xFF);
    }

    @Override
    public float red() {
        return this.red;
    }

    @Override
    public float green() {
        return this.green;
    }

    @Override
    public float blue() {
        return this.blue;
    }

    @Override
    public float alpha() {
        return this.alpha;
    }

    public Color lerp(Colorc other, float delta) {
        return this.set(this.red() + (this.red() - other.red()) * delta, this.green() + (this.green() - other.green()) * delta, this.blue() + (this.blue() - other.blue()) * delta, this.alpha() + (this.alpha() - other.alpha()) * delta);
    }

    public Color mix(Colorc color, float amount) {
        return this.set(this.red() * (1.0f - amount) + color.red() * amount, this.green() * (1.0f - amount) + color.green() * amount, this.blue() * (1.0f - amount) + color.blue() * amount, this.alpha() * (1.0f - amount) + color.alpha() * amount);
    }

    public Color lighten(float amount) {
        return this.mix(WHITE, amount, this);
    }

    public Color darken(float amount) {
        return this.mix(BLACK, amount, this);
    }

    public Color invert() {
        return this.invert(this);
    }

    public Color grayscale() {
        return this.grayscale(this);
    }

    public Color sepia() {
        return this.sepia(this);
    }

    public Color setHue(float hue) {
        return this.setHSV(hue, this.saturation(), this.luminance(), this);
    }

    public Color setSaturation(float saturation) {
        return this.setHSV(this.hue(), saturation, this.luminance(), this);
    }

    public Color setLuminance(float luminance) {
        return this.setHSV(this.hue(), this.saturation(), luminance, this);
    }

    public Color setHSV(float hue, float saturation, float luminance) {
        return this.setHSV(hue, saturation, luminance, this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Colorc)) {
            return false;
        }
        Colorc color = (Colorc)o;
        return Float.compare(this.red, color.red()) == 0 && Float.compare(this.green, color.green()) == 0 && Float.compare(this.blue, color.blue()) == 0 && Float.compare(this.alpha, color.alpha()) == 0;
    }

    public int hashCode() {
        int result = Float.hashCode(this.red);
        result = 31 * result + Float.hashCode(this.green);
        result = 31 * result + Float.hashCode(this.blue);
        result = 31 * result + Float.hashCode(this.alpha);
        return result;
    }

    private record ColorCodec(boolean alpha) implements Codec<Integer>
    {
        private <T> DataResult<Integer> decodeElement(DynamicOps<T> ops, T input) {
            Optional numberValue = ops.getNumberValue(input).result();
            if (numberValue.isPresent()) {
                int color = ((Number)numberValue.get()).intValue();
                return DataResult.success((Object)(this.alpha ? color : 0xFFFFFF & color));
            }
            Optional stringValue = ops.getStringValue(input).result();
            if (stringValue.isPresent()) {
                String colorString = (String)stringValue.get();
                if (colorString.startsWith("#")) {
                    try {
                        int color = Integer.parseUnsignedInt(colorString.substring(1), 16);
                        return DataResult.success((Object)(this.alpha ? color : 0xFFFFFF & color));
                    }
                    catch (NumberFormatException e) {
                        return DataResult.error(() -> "Invalid color hex: " + colorString + ". " + e.getMessage());
                    }
                }
                if (colorString.startsWith("0x") || colorString.startsWith("0X")) {
                    try {
                        int color = Integer.parseUnsignedInt(colorString.substring(2), 16);
                        return DataResult.success((Object)(this.alpha ? color : 0xFFFFFF & color));
                    }
                    catch (NumberFormatException e) {
                        return DataResult.error(() -> "Invalid color hex: " + colorString + ". " + e.getMessage());
                    }
                }
                try {
                    int color = Integer.parseUnsignedInt(colorString);
                    return DataResult.success((Object)(this.alpha ? color : 0xFFFFFF & color));
                }
                catch (NumberFormatException e) {
                    return DataResult.error(() -> "Invalid color int: " + colorString + ". " + e.getMessage());
                }
            }
            return DataResult.error(() -> "Not a color int, hex, or string");
        }

        public <T> DataResult<Pair<Integer, T>> decode(DynamicOps<T> ops, T input) {
            DataResult<Integer> numberElement = this.decodeElement(ops, input);
            if (numberElement.isSuccess()) {
                return numberElement.map(col -> Pair.of((Object)col, (Object)input));
            }
            Optional listValue = ops.getList(input).result();
            if (listValue.isPresent()) {
                ArrayList values = new ArrayList(4);
                ((Consumer)listValue.get()).accept(values::add);
                if (values.size() < 3 || values.size() > 4) {
                    return DataResult.error(() -> "Expected RGB and optionally A components");
                }
                int result = 0;
                for (int i = 0; i < 3; ++i) {
                    DataResult<Integer> colorElement = this.decodeElement(ops, values.get(i));
                    if (!colorElement.isSuccess()) {
                        int index = i;
                        return colorElement.map(col -> Pair.of((Object)col, (Object)input)).mapError(s -> s + " at index " + index);
                    }
                    result |= ((Integer)colorElement.getOrThrow() & 0xFF) << 16 - i * 8;
                }
                if (this.alpha) {
                    if (values.size() == 4) {
                        DataResult<Integer> colorElement = this.decodeElement(ops, values.get(3));
                        if (!colorElement.isSuccess()) {
                            return colorElement.map(col -> Pair.of((Object)col, (Object)input)).mapError(s -> s + " at index 3");
                        }
                        result |= ((Integer)colorElement.getOrThrow() & 0xFF) << 24;
                    } else {
                        result |= 0xFF000000;
                    }
                }
                return DataResult.success((Object)Pair.of((Object)result, input));
            }
            return DataResult.error(() -> "Not a color int, hex, string, or list of values");
        }

        public <T> DataResult<T> encode(Integer input, DynamicOps<T> ops, T prefix) {
            return DataResult.success((Object)ops.createInt(this.alpha ? input : 0xFFFFFF & input));
        }
    }
}

