/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.shader.client;

import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import foundry.veil.Veil;
import foundry.veil.api.client.render.shader.program.ShaderUniformCache;
import foundry.veil.impl.client.render.shader.processor.VanillaShaderProcessor;
import foundry.veil.impl.client.render.shader.program.ShaderProgramImpl;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShaderInstance.class}, priority=800)
public abstract class ShaderInstanceMixin
implements Shader {
    @Shadow
    @Final
    private int programId;
    @Shadow
    @Final
    private List<Integer> uniformLocations;
    @Shadow
    @Final
    public Map<String, Uniform> uniformMap;
    @Shadow
    @Final
    private String name;
    @Shadow
    @Final
    private List<String> samplerNames;
    @Unique
    private final Map<String, Uniform> veil$uniforms = new Object2ObjectArrayMap();

    @Inject(method={"getOrCreate"}, at={@At(value="HEAD")}, cancellable=true)
    private static void veil$cancelDummyProgram(ResourceProvider provider, Program.Type type, String name, CallbackInfoReturnable<Program> cir) {
        if (ShaderProgramImpl.Wrapper.constructingProgram != null) {
            cir.setReturnValue((Object)new ShaderProgramImpl.ShaderWrapper(type, ShaderProgramImpl.Wrapper.constructingProgram));
        }
    }

    @Inject(method={"getOrCreate"}, at={@At(value="HEAD")})
    private static void veil$setupFallbackProcessor(ResourceProvider provider, Program.Type type, String name, CallbackInfoReturnable<Program> cir) {
        if (Veil.platform().hasErrors()) {
            return;
        }
        VanillaShaderProcessor.setup(provider);
    }

    @Inject(method={"getOrCreate"}, at={@At(value="RETURN")})
    private static void veil$clearFallbackProcessor(CallbackInfoReturnable<Program> cir) {
        if (Veil.platform().hasErrors()) {
            return;
        }
        VanillaShaderProcessor.free();
    }

    @Inject(method={"close"}, at={@At(value="HEAD")})
    public void close(CallbackInfo ci) {
        for (Uniform uniform : this.veil$uniforms.values()) {
            uniform.close();
        }
    }

    @Inject(method={"apply"}, at={@At(value="TAIL")})
    public void apply(CallbackInfo ci) {
        for (Uniform uniform : this.veil$uniforms.values()) {
            uniform.upload();
        }
    }

    @Inject(method={"updateLocations"}, at={@At(value="TAIL")})
    public void updateLocations(CallbackInfo ci) {
        if (this instanceof ShaderProgramImpl.Wrapper) {
            return;
        }
        for (Uniform uniform2 : this.veil$uniforms.values()) {
            uniform2.setLocation(-1);
        }
        int uniformCount = GL20C.glGetProgrami((int)this.programId, (int)35718);
        int maxUniformLength = GL20C.glGetProgrami((int)this.programId, (int)35719);
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer size = stack.mallocInt(1);
            IntBuffer type = stack.mallocInt(1);
            block19: for (int i = 0; i < uniformCount; ++i) {
                int minecraftCount;
                int minecraftType;
                Object name = GL20C.glGetActiveUniform((int)this.programId, (int)i, (int)maxUniformLength, (IntBuffer)size, (IntBuffer)type);
                if (this.uniformMap.containsKey(name) || this.samplerNames.contains(name)) continue;
                int dataType = type.get(0);
                String typeName = ShaderUniformCache.getName(dataType);
                int length = size.get(0);
                if (ShaderUniformCache.isSampler(dataType)) {
                    for (int j = 0; j < length; ++j) {
                        if (length > 1) {
                            name = ((String)name).substring(0, ((String)name).length() - 3) + "[" + j + "]";
                        }
                        Veil.LOGGER.debug("Shader {} detected sampler: {}", (Object)this.name, (Object)(typeName + " " + (String)name));
                        this.samplerNames.add((String)name);
                    }
                    continue;
                }
                switch (dataType) {
                    case 5124: {
                        minecraftType = 0;
                        minecraftCount = 1;
                        break;
                    }
                    case 35667: {
                        minecraftType = 1;
                        minecraftCount = 2;
                        break;
                    }
                    case 35668: {
                        minecraftType = 2;
                        minecraftCount = 3;
                        break;
                    }
                    case 35669: {
                        minecraftType = 3;
                        minecraftCount = 4;
                        break;
                    }
                    case 5126: {
                        minecraftType = 4;
                        minecraftCount = 1;
                        break;
                    }
                    case 35664: {
                        minecraftType = 5;
                        minecraftCount = 2;
                        break;
                    }
                    case 35665: {
                        minecraftType = 6;
                        minecraftCount = 3;
                        break;
                    }
                    case 35666: {
                        minecraftType = 7;
                        minecraftCount = 4;
                        break;
                    }
                    case 35674: {
                        minecraftType = 8;
                        minecraftCount = 4;
                        break;
                    }
                    case 35675: {
                        minecraftType = 9;
                        minecraftCount = 9;
                        break;
                    }
                    case 35676: {
                        minecraftType = 10;
                        minecraftCount = 16;
                        break;
                    }
                    default: {
                        Veil.LOGGER.error("Unsupported Uniform Type: {}", (Object)typeName);
                        continue block19;
                    }
                }
                for (int j = 0; j < length; ++j) {
                    FloatBuffer floatBuffer;
                    Uniform uniform3;
                    Uniform old;
                    int location = Uniform.glGetUniformLocation((int)this.programId, (CharSequence)name);
                    if (location == -1) {
                        if (length == 1) {
                            Veil.LOGGER.warn("Shader {} could not find uniform named {} in the specified shader program.", (Object)this.name, name);
                        }
                        if ((old = this.veil$uniforms.remove(name)) == null) continue;
                        old.close();
                        continue;
                    }
                    if (length > 1) {
                        name = ((String)name).substring(0, ((String)name).indexOf(91)) + "[" + j + "]";
                    }
                    Veil.LOGGER.debug("Shader {} detected uniform: {}", (Object)this.name, (Object)(typeName + " " + (String)name));
                    old = this.veil$uniforms.get(name);
                    if (old != null) {
                        if (old.getType() != minecraftType) {
                            old.close();
                            uniform3 = new Uniform((String)name, minecraftType, minecraftCount, (Shader)this);
                            this.veil$uniforms.put((String)name, uniform3);
                        } else {
                            uniform3 = old;
                        }
                    } else {
                        uniform3 = new Uniform((String)name, minecraftType, minecraftCount, (Shader)this);
                        this.veil$uniforms.put((String)name, uniform3);
                    }
                    IntBuffer intBuffer = uniform3.getIntBuffer();
                    if (intBuffer != null) {
                        MemoryUtil.memSet((IntBuffer)intBuffer, (int)0);
                    }
                    if ((floatBuffer = uniform3.getFloatBuffer()) != null) {
                        MemoryUtil.memSet((FloatBuffer)floatBuffer, (int)Float.floatToIntBits(0.0f));
                    }
                    this.uniformLocations.add(location);
                    uniform3.setLocation(location);
                    this.uniformMap.put((String)name, uniform3);
                }
            }
        }
        this.veil$uniforms.values().removeIf(uniform -> uniform.getLocation() == -1);
    }
}

