/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.light.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexBuffer;
import foundry.veil.Veil;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.IndirectLight;
import foundry.veil.api.client.render.light.InstancedLight;
import foundry.veil.api.client.render.light.Light;
import foundry.veil.api.client.render.light.PositionedLight;
import foundry.veil.api.client.render.light.renderer.LightRenderer;
import foundry.veil.api.client.render.light.renderer.LightTypeRenderer;
import foundry.veil.api.client.render.shader.block.DynamicShaderBlock;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.render.vertex.VertexArray;
import foundry.veil.api.client.render.vertex.VertexArrayBuilder;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import org.joml.Vector3dc;
import org.joml.Vector4fc;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL42C;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.system.MemoryStack;

public abstract class IndirectLightRenderer<T extends Light>
implements LightTypeRenderer<T> {
    private static final ResourceLocation CULL_SHADER = Veil.veilPath("light/indirect_sphere");
    private static final int MIN_LIGHTS = 20;
    protected final int lightSize;
    protected final int highResSize;
    protected final int lowResSize;
    protected final int positionOffset;
    protected final int rangeOffset;
    protected int maxLights;
    private final VertexArray vertexArray;
    private final int instancedVbo;
    private final int indirectVbo;
    private final int sizeVbo;
    private final DynamicShaderBlock<?> instancedBlock;
    private final DynamicShaderBlock<?> indirectBlock;
    private int visibleLights;

    public IndirectLightRenderer(int lightSize, int lowResSize, int positionOffset, int rangeOffset) {
        if (!VeilRenderSystem.multiDrawIndirectSupported()) {
            throw new IllegalStateException("Indirect light renderer is not supported");
        }
        this.lightSize = lightSize;
        this.maxLights = 20;
        this.vertexArray = VertexArray.create();
        this.instancedVbo = this.vertexArray.getOrCreateBuffer(2);
        this.indirectVbo = this.vertexArray.getOrCreateBuffer(3);
        Veil.LOGGER.info("Using CPU Frustum Culling for {} renderer", (Object)this.getClass().getSimpleName());
        this.sizeVbo = 0;
        this.instancedBlock = null;
        this.indirectBlock = null;
        MeshData mesh = this.createMesh();
        this.vertexArray.upload(mesh, VertexArray.DrawUsage.STATIC);
        this.highResSize = this.vertexArray.getIndexCount() - lowResSize;
        this.lowResSize = lowResSize;
        this.positionOffset = positionOffset;
        this.rangeOffset = rangeOffset;
        this.initBuffers();
        VertexArrayBuilder builder = this.vertexArray.editFormat();
        builder.defineVertexBuffer(2, this.instancedVbo, 0, this.lightSize, 1);
        this.setupBufferState(builder);
        VertexBuffer.unbind();
    }

    protected abstract MeshData createMesh();

    protected abstract void setupBufferState(VertexArrayBuilder var1);

    protected abstract void setupRenderState(LightRenderer var1, List<T> var2);

    protected abstract void clearRenderState(LightRenderer var1, List<T> var2);

    private void initBuffers() {
        if (VeilRenderSystem.directStateAccessSupported()) {
            GL45C.glNamedBufferData((int)this.instancedVbo, (long)((long)this.maxLights * (long)this.lightSize), (int)35048);
            GL45C.glNamedBufferData((int)this.indirectVbo, (long)((long)this.maxLights * 4L * 5L), (int)35048);
        } else {
            RenderSystem.glBindBuffer((int)34962, (int)this.instancedVbo);
            RenderSystem.glBindBuffer((int)36671, (int)this.indirectVbo);
            GL42C.glBufferData((int)34962, (long)((long)this.maxLights * (long)this.lightSize), (int)35048);
            GL42C.glBufferData((int)36671, (long)((long)this.maxLights * 4L * 5L), (int)35048);
        }
        if (this.sizeVbo != 0) {
            this.instancedBlock.setSize(this.maxLights * this.lightSize);
            this.indirectBlock.setSize(this.maxLights * 4 * 5);
        }
    }

    private boolean shouldDrawHighResolution(T light, CullFrustum frustum) {
        float radius = ((IndirectLight)light).getRadius();
        return frustum.getPosition().distanceSquared(((PositionedLight)light).getPosition()) <= (double)(radius * radius);
    }

    private boolean isVisible(T light, CullFrustum frustum) {
        Vector3dc position = ((PositionedLight)light).getPosition();
        float radius = ((IndirectLight)light).getRadius();
        return frustum.testSphere(position, radius * 1.414f);
    }

    private void updateAllLights(List<T> lights) {
        ByteBuffer dataBuffer = GL42C.glMapBuffer((int)34962, (int)35001, (long)((long)lights.size() * (long)this.lightSize), null);
        if (dataBuffer == null) {
            return;
        }
        for (int i = 0; i < lights.size(); ++i) {
            Light light = (Light)lights.get(i);
            light.clean();
            dataBuffer.position(i * this.lightSize);
            ((InstancedLight)((Object)light)).store(dataBuffer);
        }
        GL42C.glUnmapBuffer((int)34962);
    }

    private int updateVisibility(List<T> lights, CullFrustum frustum) {
        if (this.sizeVbo != 0) {
            VeilRenderSystem.setShader(CULL_SHADER);
            ShaderProgram shader = VeilRenderSystem.getShader();
            if (shader != null && shader.isCompute()) {
                try {
                    int n;
                    block22: {
                        MemoryStack stack = MemoryStack.stackPush();
                        try {
                            VeilRenderSystem.bind("VeilLightInstanced", this.instancedBlock);
                            VeilRenderSystem.bind("VeilLightIndirect", this.indirectBlock);
                            GL30C.glBindBufferRange((int)37568, (int)0, (int)this.sizeVbo, (long)0L, (long)4L);
                            GL42C.glBufferSubData((int)37568, (long)0L, (IntBuffer)stack.callocInt(1));
                            int maxX = VeilRenderSystem.maxComputeWorkGroupCountX();
                            int maxY = VeilRenderSystem.maxComputeWorkGroupCountY();
                            shader.setInt("HighResSize", this.highResSize);
                            shader.setInt("LowResSize", this.lowResSize);
                            shader.setInt("LightSize", this.lightSize / 4);
                            shader.setInt("PositionOffset", this.positionOffset);
                            shader.setInt("RangeOffset", this.rangeOffset);
                            Vector4fc[] planes = frustum.getPlanes();
                            float[] values = new float[4 * planes.length];
                            for (int i = 0; i < planes.length; ++i) {
                                Vector4fc plane = planes[i];
                                values[i * 4] = plane.x();
                                values[i * 4 + 1] = plane.y();
                                values[i * 4 + 2] = plane.z();
                                values[i * 4 + 3] = plane.w();
                            }
                            shader.setFloats("FrustumPlanes", values);
                            shader.setInt("Width", maxX);
                            shader.bind();
                            GL43C.glDispatchCompute((int)Math.min(lights.size(), maxX), (int)Math.min(1 + lights.size() / maxX, maxY), (int)1);
                            GL42C.glMemoryBarrier((int)4608);
                            ShaderProgram.unbind();
                            ByteBuffer counter = GL42C.glMapBufferRange((int)37568, (long)0L, (long)4L, (int)1);
                            int n2 = n = counter != null ? counter.getInt(0) : 0;
                            if (stack == null) break block22;
                        }
                        catch (Throwable maxX) {
                            if (stack != null) {
                                try {
                                    stack.close();
                                }
                                catch (Throwable maxY) {
                                    maxX.addSuppressed(maxY);
                                }
                            }
                            throw maxX;
                        }
                        stack.close();
                    }
                    return n;
                }
                finally {
                    VeilRenderSystem.unbind(this.instancedBlock);
                    VeilRenderSystem.unbind(this.indirectBlock);
                    GL42C.glUnmapBuffer((int)37568);
                    GL30C.glBindBufferRange((int)37568, (int)0, (int)0, (long)0L, (long)4L);
                }
            }
        }
        int count = 0;
        RenderSystem.glBindBuffer((int)36671, (int)this.indirectVbo);
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer buffer = stack.malloc(this.lowResSize > 0 ? 20 : 4);
            int index = 0;
            for (Light light : lights) {
                if (this.isVisible(light, frustum)) {
                    if (this.lowResSize > 0) {
                        boolean highRes = this.shouldDrawHighResolution(light, frustum);
                        buffer.putInt(0, highRes ? this.highResSize : this.lowResSize);
                        buffer.putInt(4, 1);
                        buffer.putInt(8, !highRes ? this.highResSize : 0);
                        buffer.putInt(12, 0);
                        buffer.putInt(16, index);
                        GL42C.glBufferSubData((int)36671, (long)((long)(count * 4) * 5L), (ByteBuffer)buffer);
                    } else {
                        buffer.putInt(0, index);
                        GL42C.glBufferSubData((int)36671, (long)((long)(count * 4) * 5L + 16L), (ByteBuffer)buffer);
                    }
                    ++count;
                }
                ++index;
            }
        }
        return count;
    }

    @Override
    public void prepareLights(LightRenderer lightRenderer, List<T> lights, Set<T> removedLights, CullFrustum frustum) {
        ProfilerFiller profiler = Minecraft.getInstance().getProfiler();
        RenderSystem.glBindBuffer((int)34962, (int)this.instancedVbo);
        profiler.push("resize");
        boolean rebuild = false;
        if (lights.size() > this.maxLights) {
            rebuild = true;
            this.maxLights = (int)Math.max(Math.max(Math.ceil((double)this.maxLights / 2.0), 20.0), (double)lights.size() * 1.5);
            this.initBuffers();
        }
        profiler.popPush("update");
        RenderSystem.glBindBuffer((int)34962, (int)this.instancedVbo);
        if (rebuild || !removedLights.isEmpty()) {
            this.updateAllLights(lights);
        } else {
            try (MemoryStack stack = MemoryStack.stackPush();){
                ByteBuffer buffer = stack.malloc(this.lightSize);
                for (int i = 0; i < lights.size(); ++i) {
                    Light light = (Light)lights.get(i);
                    if (!light.isDirty()) continue;
                    light.clean();
                    ((InstancedLight)((Object)light)).store(buffer);
                    buffer.rewind();
                    GL42C.glBufferSubData((int)34962, (long)((long)i * (long)this.lightSize), (ByteBuffer)buffer);
                }
            }
        }
        profiler.popPush("visibility");
        this.visibleLights = !lights.isEmpty() ? this.updateVisibility(lights, frustum) : 0;
        profiler.pop();
    }

    @Override
    public void renderLights(LightRenderer lightRenderer, List<T> lights) {
        this.setupRenderState(lightRenderer, lights);
        if (lightRenderer.applyShader()) {
            this.clearRenderState(lightRenderer, lights);
            return;
        }
        this.vertexArray.bind();
        RenderSystem.glBindBuffer((int)36671, (int)this.indirectVbo);
        this.vertexArray.drawIndirect(0L, this.visibleLights, 0);
        RenderSystem.glBindBuffer((int)36671, (int)0);
        VertexBuffer.unbind();
        ShaderProgram.unbind();
        this.clearRenderState(lightRenderer, lights);
    }

    @Override
    public int getVisibleLights() {
        return this.visibleLights;
    }

    public void free() {
        this.vertexArray.free();
        if (this.sizeVbo != 0) {
            this.instancedBlock.free();
            this.indirectBlock.free();
        }
    }
}

