/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.registry.VeilShaderBufferRegistry;
import foundry.veil.api.client.render.VeilLevelPerspectiveRenderer;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilShaderBufferLayout;
import foundry.veil.api.client.render.shader.block.ShaderBlock;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CameraMatrices {
    private final Matrix4f projectionMatrix = new Matrix4f();
    private final Matrix4f inverseProjectionMatrix = new Matrix4f();
    private final Matrix4f viewMatrix = new Matrix4f();
    private final Matrix4f inverseViewMatrix = new Matrix4f();
    private final Matrix3f inverseViewRotMatrix = new Matrix3f();
    private final Vector3f cameraPosition = new Vector3f();
    private final Vector3f cameraBobOffset = new Vector3f();
    private float nearPlane = 0.0f;
    private float farPlane = 0.0f;

    public static VeilShaderBufferLayout<CameraMatrices> createLayout() {
        return VeilShaderBufferLayout.builder().mat4("ProjMat", CameraMatrices::getProjectionMatrix).mat4("IProjMat", CameraMatrices::getInverseProjectionMatrix).mat4("ViewMat", CameraMatrices::getViewMatrix).mat4("IViewMat", CameraMatrices::getInverseViewMatrix).mat3("IViewRotMat", CameraMatrices::getInverseViewRotMatrix).vec3("CameraPosition", CameraMatrices::getCameraPosition).f32("NearPlane", CameraMatrices::getNearPlane).vec3("CameraBobOffset", CameraMatrices::getCameraBobOffset).f32("FarPlane", CameraMatrices::getFarPlane).build();
    }

    public void update(Matrix4fc projection, Matrix4fc modelView, double x, double y, double z) {
        ShaderBlock<CameraMatrices> block = VeilRenderSystem.getBlock(VeilShaderBufferRegistry.CAMERA.get());
        if (block == null) {
            return;
        }
        this.projectionMatrix.set(projection);
        this.projectionMatrix.invertPerspective(this.inverseProjectionMatrix);
        if (VeilLevelPerspectiveRenderer.isRenderingPerspective()) {
            this.cameraBobOffset.set(0.0f);
        } else {
            modelView.invert(this.viewMatrix).transformPosition(VeilRenderSystem.getCameraBobOffset(), this.cameraBobOffset);
        }
        this.viewMatrix.set(modelView).mulLocal((Matrix4fc)this.inverseProjectionMatrix.mul((Matrix4fc)RenderSystem.getProjectionMatrix(), new Matrix4f()));
        this.viewMatrix.invert(this.inverseViewMatrix);
        this.inverseViewMatrix.normal(this.inverseViewRotMatrix);
        this.nearPlane = this.inverseProjectionMatrix.transformPosition(0.0f, 0.0f, -1.0f, this.cameraPosition).z();
        this.farPlane = this.inverseProjectionMatrix.transformPosition(0.0f, 0.0f, 1.0f, this.cameraPosition).z();
        this.cameraPosition.set(x, y, z);
        block.set(this);
        VeilRenderSystem.bind(VeilShaderBufferRegistry.CAMERA.get());
    }

    public void updateRenderSystem() {
        ShaderBlock<CameraMatrices> block = VeilRenderSystem.getBlock(VeilShaderBufferRegistry.CAMERA.get());
        if (block == null) {
            return;
        }
        this.projectionMatrix.set((Matrix4fc)RenderSystem.getProjectionMatrix());
        this.projectionMatrix.invertAffine(this.inverseProjectionMatrix);
        this.viewMatrix.identity();
        this.inverseViewMatrix.identity();
        this.inverseViewRotMatrix.identity();
        this.nearPlane = this.inverseProjectionMatrix.transformPosition(0.0f, 0.0f, -1.0f, this.cameraPosition).z();
        this.farPlane = this.inverseProjectionMatrix.transformPosition(0.0f, 0.0f, 1.0f, this.cameraPosition).z();
        this.cameraPosition.set(0.0f);
        this.cameraBobOffset.set(0.0f);
        block.set(this);
        VeilRenderSystem.bind(VeilShaderBufferRegistry.CAMERA.get());
    }

    public void backup(CameraMatrices store) {
        store.projectionMatrix.set((Matrix4fc)this.projectionMatrix);
        store.inverseProjectionMatrix.set((Matrix4fc)this.inverseProjectionMatrix);
        store.viewMatrix.set((Matrix4fc)this.viewMatrix);
        store.inverseViewMatrix.set((Matrix4fc)this.inverseViewMatrix);
        store.inverseViewRotMatrix.set((Matrix3fc)this.inverseViewRotMatrix);
        store.cameraPosition.set((Vector3fc)this.cameraPosition);
        store.cameraBobOffset.set((Vector3fc)this.cameraBobOffset);
        store.nearPlane = this.nearPlane;
        store.farPlane = this.farPlane;
    }

    public void restore(CameraMatrices load) {
        ShaderBlock<CameraMatrices> block = VeilRenderSystem.getBlock(VeilShaderBufferRegistry.CAMERA.get());
        if (block == null) {
            return;
        }
        this.projectionMatrix.set((Matrix4fc)load.projectionMatrix);
        this.inverseProjectionMatrix.set((Matrix4fc)load.inverseProjectionMatrix);
        this.viewMatrix.set((Matrix4fc)load.viewMatrix);
        this.inverseViewMatrix.set((Matrix4fc)load.inverseViewMatrix);
        this.inverseViewRotMatrix.set((Matrix3fc)load.inverseViewRotMatrix);
        this.cameraPosition.set((Vector3fc)load.cameraPosition);
        this.cameraBobOffset.set((Vector3fc)load.cameraBobOffset);
        this.nearPlane = load.nearPlane;
        this.farPlane = load.farPlane;
        block.set(this);
        VeilRenderSystem.bind(VeilShaderBufferRegistry.CAMERA.get());
    }

    public Matrix4f getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public Matrix4f getInverseProjectionMatrix() {
        return this.inverseProjectionMatrix;
    }

    public Matrix4f getViewMatrix() {
        return this.viewMatrix;
    }

    public Matrix4f getInverseViewMatrix() {
        return this.inverseViewMatrix;
    }

    public Matrix3f getInverseViewRotMatrix() {
        return this.inverseViewRotMatrix;
    }

    public Vector3f getCameraPosition() {
        return this.cameraPosition;
    }

    public Vector3f getCameraBobOffset() {
        return this.cameraBobOffset;
    }

    public float getNearPlane() {
        return this.nearPlane;
    }

    public float getFarPlane() {
        return this.farPlane;
    }

    public void setNearPlane(float nearPlane) {
        this.nearPlane = nearPlane;
    }

    public void setFarPlane(float farPlane) {
        this.farPlane = farPlane;
    }
}

