/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.pipeline;

import foundry.veil.Veil;
import foundry.veil.api.client.registry.VeilShaderBufferRegistry;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilShaderBufferLayout;
import foundry.veil.api.client.render.shader.block.ShaderBlock;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.impl.client.render.LayoutSerializer;
import foundry.veil.impl.client.render.shader.block.LayoutShaderBlockImpl;
import foundry.veil.impl.client.render.shader.program.ShaderProgramImpl;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

@ApiStatus.Internal
public class VeilShaderBufferCache
implements NativeResource {
    private LayoutShaderBlockImpl<?>[] values;
    private VeilShaderBufferLayout<?>[] layouts;

    public void onShaderCompile(Map<ResourceLocation, ShaderProgram> updatedPrograms) {
        if (this.layouts == null) {
            this.layouts = (VeilShaderBufferLayout[])VeilShaderBufferRegistry.REGISTRY.stream().toArray(VeilShaderBufferLayout[]::new);
            this.values = new LayoutShaderBlockImpl[this.layouts.length];
        }
        for (ShaderProgram shader : updatedPrograms.values()) {
            if (!(shader instanceof ShaderProgramImpl)) continue;
            ShaderProgramImpl impl = (ShaderProgramImpl)shader;
            impl.clearShaderBlocks();
        }
        for (int i = 0; i < this.values.length; ++i) {
            Set<ResourceLocation> shaders;
            VeilShaderBufferLayout<?> layout;
            Set<ResourceLocation> shaders2;
            LayoutShaderBlockImpl<?> block = this.values[i];
            if (block != null && (shaders2 = block.getReferencedShaders()).removeAll(updatedPrograms.keySet()) && shaders2.isEmpty()) {
                block.free();
                this.values[i] = null;
            }
            boolean packed = (layout = this.layouts[i]).memoryLayout() == ShaderBlock.MemoryLayout.PACKED;
            String name = layout.name();
            for (ShaderProgram shader : updatedPrograms.values()) {
                int index;
                if ((index = (switch (layout.binding()) {
                    default -> throw new MatchException(null, null);
                    case ShaderBlock.BufferBinding.UNIFORM -> shader.getUniformBlock(name);
                    case ShaderBlock.BufferBinding.SHADER_STORAGE -> shader.getStorageBlock(name);
                })) == -1) continue;
                if (this.values[i] == null) {
                    block = LayoutSerializer.create(layout, shader, name, index);
                    block.getReferencedShaders().add(shader.getName());
                    this.values[i] = block;
                    if (!packed || !(shader instanceof ShaderProgramImpl)) break;
                    ShaderProgramImpl impl = (ShaderProgramImpl)shader;
                    impl.addShaderBlock(name, block);
                    break;
                }
                this.values[i].getReferencedShaders().add(shader.getName());
                break;
            }
            if (!packed || (block = this.values[i]) == null || (shaders = block.getReferencedShaders()).size() == 1) continue;
            String error = shaders.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
            Veil.LOGGER.error("Shader Block {} uses the 'packed' memory layout and only supports a single shader using the block. Either use a different format or only use the block in one shader. Affected shaders: {}", (Object)name, (Object)error);
        }
    }

    public void bind() {
        if (this.values == null) {
            return;
        }
        for (int i = 0; i < this.values.length; ++i) {
            LayoutShaderBlockImpl<?> block = this.values[i];
            if (block == null || this.layouts[i].memoryLayout() == ShaderBlock.MemoryLayout.PACKED) continue;
            VeilRenderSystem.bind(this.layouts[i].name(), block);
        }
    }

    public void unbindPacked() {
        if (this.values == null) {
            return;
        }
        for (int i = 0; i < this.values.length; ++i) {
            LayoutShaderBlockImpl<?> block = this.values[i];
            if (block == null || this.layouts[i].memoryLayout() != ShaderBlock.MemoryLayout.PACKED) continue;
            VeilRenderSystem.unbind(block);
        }
    }

    @Nullable
    public <T> ShaderBlock<T> getBlock(VeilShaderBufferLayout<T> layout) throws IllegalArgumentException {
        if (this.values == null) {
            return null;
        }
        int id = VeilShaderBufferRegistry.REGISTRY.getId(layout);
        if (id < 0 || id >= this.values.length) {
            throw new IllegalArgumentException("Attempted to use unregistered buffer layout: " + layout.name());
        }
        return this.values[id];
    }

    public void bind(VeilShaderBufferLayout<?> layout) throws IllegalArgumentException {
        if (this.values == null) {
            return;
        }
        int id = VeilShaderBufferRegistry.REGISTRY.getId(layout);
        if (id < 0 || id >= this.values.length) {
            throw new IllegalArgumentException("Attempted to use unregistered buffer layout: " + layout.name());
        }
        LayoutShaderBlockImpl<?> block = this.values[id];
        if (block != null) {
            VeilRenderSystem.bind(this.layouts[id].name(), block);
        }
    }

    public void unbind(VeilShaderBufferLayout<?> layout) throws IllegalArgumentException {
        if (this.values == null) {
            return;
        }
        int id = VeilShaderBufferRegistry.REGISTRY.getId(layout);
        if (id < 0 || id >= this.values.length) {
            throw new IllegalArgumentException("Attempted to use unregistered buffer layout: " + layout.name());
        }
        LayoutShaderBlockImpl<?> block = this.values[id];
        if (block != null) {
            VeilRenderSystem.unbind(block);
        }
    }

    public void free() {
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                LayoutShaderBlockImpl<?> block = this.values[i];
                if (block != null) {
                    block.free();
                }
                this.values[i] = null;
            }
        }
    }
}

