/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import foundry.veil.Veil;
import foundry.veil.VeilClient;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.quasar.data.QuasarParticles;
import foundry.veil.api.quasar.particle.ParticleEmitter;
import foundry.veil.api.quasar.particle.ParticleSystemManager;
import foundry.veil.impl.ClientEnumArgument;
import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import org.jetbrains.annotations.ApiStatus;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="veil", value={Dist.CLIENT})
@ApiStatus.Internal
public class VeilForgeClientEvents {
    @SubscribeEvent
    public static void clientDisconnected(ClientPlayerNetworkEvent.LoggingOut event) {
        VeilRenderSystem.renderer().getLightRenderer().free();
    }

    @SubscribeEvent
    public static void keyPressed(InputEvent.Key event) {
        if (event.getAction() == 1 && VeilClient.EDITOR_KEY.matches(event.getKey(), event.getScanCode())) {
            VeilImGuiImpl.get().toggle();
        }
    }

    @SubscribeEvent
    public static void registerClientCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralArgumentBuilder quasarBuilder = Commands.literal((String)"quasar");
        quasarBuilder.then(Commands.argument((String)"emitter", (ArgumentType)ResourceLocationArgument.id()).suggests(QuasarParticles.emitterSuggestionProvider()).then(Commands.argument((String)"position", (ArgumentType)Vec3Argument.vec3()).executes(ctx -> {
            ResourceLocation id = ResourceLocationArgument.getId((CommandContext)ctx, (String)"emitter");
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ParticleSystemManager particleManager = VeilRenderSystem.renderer().getParticleManager();
            ParticleEmitter instance = particleManager.createEmitter(id);
            if (instance == null) {
                source.sendFailure((Component)Component.literal((String)("Unknown emitter: " + String.valueOf(id))));
                return 0;
            }
            WorldCoordinates coordinates = (WorldCoordinates)ctx.getArgument("position", WorldCoordinates.class);
            Vec3 pos = coordinates.getPosition(source);
            instance.setPosition(pos.x, pos.y, pos.z);
            particleManager.addParticleSystem(instance);
            source.sendSuccess(() -> Component.literal((String)("Spawned " + String.valueOf(id))), true);
            return 1;
        })));
        dispatcher.register(quasarBuilder);
        if (Veil.platform().isDevelopmentEnvironment()) {
            ResourceLocation bufferId = Veil.veilPath("forced");
            LiteralArgumentBuilder debugBuilder = Commands.literal((String)"veil");
            debugBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"buffers").then(((LiteralArgumentBuilder)Commands.literal((String)"enable").then(Commands.argument((String)"buffer", ClientEnumArgument.enumArgument(DynamicBufferType.class)).executes(ctx -> {
                DynamicBufferType value = (DynamicBufferType)((Object)((Object)ctx.getArgument("buffer", DynamicBufferType.class)));
                VeilRenderSystem.renderer().enableBuffers(bufferId, value);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.veil.buffers.enable", (Object[])new Object[]{value.name().toLowerCase(Locale.ROOT)}), true);
                return 1;
            }))).then(Commands.literal((String)"all").executes(ctx -> {
                DynamicBufferType[] values = DynamicBufferType.values();
                VeilRenderSystem.renderer().enableBuffers(bufferId, values);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.veil.buffers.enable.all"), true);
                return values.length;
            })))).then(((LiteralArgumentBuilder)Commands.literal((String)"disable").then(Commands.argument((String)"buffer", ClientEnumArgument.enumArgument(DynamicBufferType.class)).executes(ctx -> {
                DynamicBufferType value = (DynamicBufferType)((Object)((Object)ctx.getArgument("buffer", DynamicBufferType.class)));
                VeilRenderSystem.renderer().disableBuffers(bufferId, value);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.veil.buffers.disable", (Object[])new Object[]{value.name().toLowerCase(Locale.ROOT)}), true);
                return 1;
            }))).then(Commands.literal((String)"all").executes(ctx -> {
                DynamicBufferType[] values = DynamicBufferType.values();
                VeilRenderSystem.renderer().disableBuffers(bufferId, values);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.veil.buffers.disable.all"), true);
                return values.length;
            }))));
            dispatcher.register(debugBuilder);
        }
    }

    @SubscribeEvent
    public static void mousePressed(InputEvent.MouseButton.Pre event) {
        if (event.getAction() == 1 && VeilClient.EDITOR_KEY.matchesMouse(event.getButton())) {
            VeilImGuiImpl.get().toggle();
        }
    }
}

