/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.ext;

import foundry.veil.Veil;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.KHRDebug;

public enum VeilDebug {
    DISABLED{

        @Override
        public void debugMessageInsert(int type, int id, int severity, CharSequence message) {
        }

        @Override
        public void objectLabel(int identifier, int name, CharSequence label) {
        }
    }
    ,
    ENABLED{

        @Override
        public void debugMessageInsert(int type, int id, int severity, CharSequence message) {
            KHRDebug.glDebugMessageInsert((int)33354, (int)type, (int)id, (int)severity, (CharSequence)message);
        }

        @Override
        public void objectLabel(int identifier, int name, @Nullable CharSequence label) {
            if (label != null) {
                KHRDebug.glObjectLabel((int)identifier, (int)name, (CharSequence)label);
            } else {
                KHRDebug.nglObjectLabel((int)identifier, (int)name, (int)0, (long)0L);
            }
        }
    };

    private static VeilDebug debug;

    public abstract void debugMessageInsert(int var1, int var2, int var3, CharSequence var4);

    public abstract void objectLabel(int var1, int var2, @Nullable CharSequence var3);

    public static VeilDebug get() {
        if (debug == null) {
            GLCapabilities caps = GL.getCapabilities();
            if (caps.OpenGL43 || caps.GL_KHR_debug) {
                debug = ENABLED;
                Veil.LOGGER.info("GL Debug supported");
            } else {
                debug = DISABLED;
                Veil.LOGGER.info("GL Debug unsupported");
            }
        }
        return debug;
    }
}

