/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.framebuffer;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.ext.VeilDebug;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.AdvancedFboAttachment;
import foundry.veil.impl.client.render.framebuffer.AdvancedFboImpl;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.system.MemoryStack;

@ApiStatus.Internal
public class LegacyAdvancedFboImpl
extends AdvancedFboImpl {
    public LegacyAdvancedFboImpl(int width, int height, AdvancedFboAttachment[] colorAttachments, @Nullable AdvancedFboAttachment depthAttachment, @Nullable String debugLabel) {
        super(width, height, colorAttachments, depthAttachment, debugLabel);
    }

    @Override
    public void create() {
        int status;
        for (AdvancedFboAttachment attachment : this.colorAttachments) {
            attachment.create();
        }
        if (this.depthAttachment != null) {
            this.depthAttachment.create();
        }
        RenderSystem.bindTexture((int)0);
        int oldFbo = GL30C.glGetInteger((int)36006);
        this.id = GL30C.glGenFramebuffers();
        this.bind(false);
        VeilDebug debug = VeilDebug.get();
        debug.objectLabel(36160, this.id, "Advanced Fbo " + this.debugLabel);
        for (int i = 0; i < this.colorAttachments.length; ++i) {
            this.colorAttachments[i].attach(this, i);
        }
        if (this.depthAttachment != null) {
            this.depthAttachment.attach(this, 0);
        }
        if ((status = GL30C.glCheckFramebufferStatus((int)36160)) != 36053) {
            Object error = ERRORS.containsKey(status) ? (String)ERRORS.get(status) : "0x" + Integer.toHexString(status).toUpperCase(Locale.ROOT);
            throw new IllegalStateException("Advanced FBO status did not return GL_FRAMEBUFFER_COMPLETE. " + (String)error);
        }
        this.currentDrawBuffers = this.drawBuffers;
        GlStateManager._glBindFramebuffer((int)36160, (int)oldFbo);
    }

    @Override
    public void clear(float red, float green, float blue, float alpha, int clearMask, int ... buffers) {
        if (clearMask == 0) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            int oldFbo = GL30C.glGetInteger((int)36006);
            if (oldFbo != this.id) {
                this.bind(false);
            }
            boolean color = (clearMask & 0x4000) != 0;
            FloatBuffer oldColor = null;
            if (color) {
                this.drawBuffers(buffers);
                oldColor = stack.mallocFloat(4);
                GL30C.glGetFloatv((int)3106, (FloatBuffer)oldColor);
                GL30C.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
            }
            GlStateManager._clear((int)clearMask, (boolean)Minecraft.ON_OSX);
            if (color) {
                GL30C.glClearColor((float)oldColor.get(0), (float)oldColor.get(1), (float)oldColor.get(2), (float)oldColor.get(3));
                this.resetDrawBuffers();
            }
            if (oldFbo != this.id) {
                GlStateManager._glBindFramebuffer((int)36160, (int)oldFbo);
            }
        }
        if (Minecraft.ON_OSX) {
            GL30C.glGetError();
        }
    }

    private void setDrawBuffers(int[] buffers) {
        int oldFbo = GL30C.glGetInteger((int)36006);
        if (oldFbo != this.id) {
            this.bind(false);
        }
        GL20C.glDrawBuffers((int[])buffers);
        if (oldFbo != this.id) {
            GlStateManager._glBindFramebuffer((int)36160, (int)oldFbo);
        }
    }

    @Override
    public void resetDrawBuffers() {
        if (Arrays.mismatch(this.currentDrawBuffers, this.drawBuffers) >= 0) {
            this.currentDrawBuffers = this.drawBuffers;
            this.setDrawBuffers(this.drawBuffers);
        }
    }

    @Override
    public void drawBuffers(int ... buffers) {
        if (Arrays.mismatch(this.currentDrawBuffers, buffers) >= 0) {
            if (this.currentDrawBuffers.length != buffers.length) {
                this.currentDrawBuffers = Arrays.copyOf(buffers, buffers.length);
            } else {
                System.arraycopy(buffers, 0, this.currentDrawBuffers, 0, buffers.length);
            }
            this.setDrawBuffers(buffers);
        }
    }

    @Override
    public void resolveToFbo(int id, int width, int height, int mask, int filtering) {
        int oldRead = GL30C.glGetInteger((int)36010);
        int oldDraw = GL30C.glGetInteger((int)36006);
        this.bindRead();
        GlStateManager._glBindFramebuffer((int)36009, (int)id);
        GL30C.glBlitFramebuffer((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)0, (int)width, (int)height, (int)mask, (int)filtering);
        GlStateManager._glBindFramebuffer((int)36008, (int)oldRead);
        GlStateManager._glBindFramebuffer((int)36009, (int)oldDraw);
    }

    @Override
    public void resolveToAdvancedFbo(AdvancedFbo target, int mask, int filtering) {
        int oldRead = GL30C.glGetInteger((int)36010);
        int oldDraw = GL30C.glGetInteger((int)36006);
        this.bindRead();
        target.bindDraw(false);
        GL30C.glBlitFramebuffer((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)0, (int)target.getWidth(), (int)target.getHeight(), (int)mask, (int)filtering);
        GlStateManager._glBindFramebuffer((int)36008, (int)oldRead);
        GlStateManager._glBindFramebuffer((int)36009, (int)oldDraw);
    }

    @Override
    public void resolveToRenderTarget(RenderTarget target, int mask, int filtering) {
        int oldRead = GL30C.glGetInteger((int)36010);
        int oldDraw = GL30C.glGetInteger((int)36006);
        this.bindRead();
        GlStateManager._glBindFramebuffer((int)36009, (int)target.frameBufferId);
        GL30C.glBlitFramebuffer((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)0, (int)target.width, (int)target.height, (int)mask, (int)filtering);
        GlStateManager._glBindFramebuffer((int)36008, (int)oldRead);
        GlStateManager._glBindFramebuffer((int)36009, (int)oldDraw);
    }

    @Override
    public void setColorAttachmentTexture(int attachment, int textureId, int layer) {
        int old = GL30C.glGetInteger((int)36006);
        if (old != this.id) {
            this.bind(false);
        }
        super.setColorAttachmentTexture(attachment, textureId, layer);
        if (old != this.id) {
            GlStateManager._glBindFramebuffer((int)36160, (int)old);
        }
    }

    @Override
    public void setDepthAttachmentTexture(int textureId, int layer) {
        int old = GL30C.glGetInteger((int)36006);
        if (old != this.id) {
            this.bind(false);
        }
        super.setDepthAttachmentTexture(textureId, layer);
        if (old != this.id) {
            GlStateManager._glBindFramebuffer((int)36160, (int)old);
        }
    }
}

