/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.performance.client;

import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.ext.PerformanceRenderTargetExtension;
import java.nio.FloatBuffer;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.ARBClearTexture;
import org.lwjgl.opengl.ARBCopyImage;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.NVDrawTexture;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Restriction(conflict={@Condition(value="affinity")})
@Mixin(value={RenderTarget.class})
public abstract class PerformanceRenderTargetMixin
implements PerformanceRenderTargetExtension {
    @Unique
    private static final ResourceLocation veil$BLIT_SHADER = Veil.veilPath("blit_screen");
    @Shadow
    public int width;
    @Shadow
    public int height;
    @Shadow
    @Final
    private float[] clearChannels;
    @Shadow
    @Final
    public boolean useDepth;
    @Shadow
    public int frameBufferId;

    @Shadow
    public abstract int getColorTextureId();

    @Shadow
    public abstract int getDepthTextureId();

    @Shadow
    public abstract void bindWrite(boolean var1);

    @Shadow
    public abstract void unbindWrite();

    @Inject(method={"copyDepthFrom"}, at={@At(value="HEAD")}, cancellable=true)
    public void copyDepthFrom(RenderTarget otherTarget, CallbackInfo ci) {
        if (!(this.getClass() instanceof MainTarget)) {
            return;
        }
        if (!this.useDepth || !otherTarget.useDepth) {
            ci.cancel();
            return;
        }
        if (VeilRenderSystem.copyImageSupported() && this.width == otherTarget.width && this.height == otherTarget.height) {
            ci.cancel();
            ARBCopyImage.glCopyImageSubData((int)otherTarget.getDepthTextureId(), (int)3553, (int)0, (int)0, (int)0, (int)0, (int)this.getDepthTextureId(), (int)3553, (int)0, (int)0, (int)0, (int)0, (int)this.width, (int)this.height, (int)1);
        } else if (VeilRenderSystem.directStateAccessSupported()) {
            ci.cancel();
            ARBDirectStateAccess.glBlitNamedFramebuffer((int)otherTarget.frameBufferId, (int)this.frameBufferId, (int)0, (int)0, (int)otherTarget.width, (int)otherTarget.height, (int)0, (int)0, (int)this.width, (int)this.height, (int)256, (int)9728);
        }
    }

    @Inject(method={"clear"}, at={@At(value="HEAD")}, cancellable=true)
    public void clear(boolean clearError, CallbackInfo ci) {
        if (!(this.getClass() instanceof MainTarget)) {
            return;
        }
        boolean clearTex = VeilRenderSystem.clearTextureSupported();
        if (!clearTex && !VeilRenderSystem.directStateAccessSupported()) {
            return;
        }
        ci.cancel();
        try (MemoryStack stack = MemoryStack.stackPush();){
            if (clearTex) {
                ARBClearTexture.glClearTexImage((int)this.getColorTextureId(), (int)0, (int)6408, (int)5126, (float[])this.clearChannels);
            } else {
                ARBDirectStateAccess.glClearNamedFramebufferfv((int)this.frameBufferId, (int)6144, (int)0, (float[])this.clearChannels);
            }
            if (this.useDepth) {
                if (clearTex) {
                    ARBClearTexture.glClearTexImage((int)this.getDepthTextureId(), (int)0, (int)6402, (int)5126, (FloatBuffer)stack.floats(1.0f));
                } else {
                    ARBDirectStateAccess.glClearNamedFramebufferfv((int)this.frameBufferId, (int)6145, (int)0, (FloatBuffer)stack.floats(1.0f));
                }
            }
        }
        if (clearError) {
            GL11C.glGetError();
        }
    }

    @Inject(method={"_blitToScreen"}, at={@At(value="HEAD")}, cancellable=true)
    private void _blitToScreen(int width, int height, boolean disableBlend, CallbackInfo ci) {
        GlStateManager._disableDepthTest();
        if (VeilRenderSystem.nvDrawTextureSupported()) {
            ci.cancel();
            RenderSystem.assertOnRenderThread();
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GlStateManager._depthMask((boolean)false);
            if (disableBlend) {
                GlStateManager._disableBlend();
            }
            NVDrawTexture.glDrawTextureNV((int)this.getColorTextureId(), (int)0, (float)0.0f, (float)0.0f, (float)width, (float)height, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager._depthMask((boolean)true);
            return;
        }
        if (disableBlend && VeilRenderSystem.directStateAccessSupported()) {
            ci.cancel();
            RenderSystem.assertOnRenderThread();
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            ARBDirectStateAccess.glBlitNamedFramebuffer((int)this.frameBufferId, (int)0, (int)0, (int)0, (int)this.width, (int)this.height, (int)0, (int)0, (int)width, (int)height, (int)16384, (int)9728);
        } else {
            ShaderProgram shader = VeilRenderSystem.setShader(veil$BLIT_SHADER);
            if (shader == null) {
                return;
            }
            ci.cancel();
            RenderSystem.assertOnRenderThread();
            GlStateManager._viewport((int)0, (int)0, (int)width, (int)height);
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GlStateManager._depthMask((boolean)false);
            if (disableBlend) {
                GlStateManager._disableBlend();
            }
            VeilRenderSystem.bindTextures(0, this.getColorTextureId());
            shader.bind();
            VeilRenderSystem.drawScreenQuad();
            ShaderProgram.unbind();
        }
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._depthMask((boolean)true);
    }

    @Override
    public void veil$clearColorBuffer(boolean clearError) {
        RenderSystem.assertOnRenderThreadOrInit();
        int colorTextureId = this.getColorTextureId();
        if (VeilRenderSystem.clearTextureSupported() && GL11C.glIsTexture((int)colorTextureId)) {
            ARBClearTexture.glClearTexImage((int)colorTextureId, (int)0, (int)6408, (int)5126, (float[])this.clearChannels);
        } else if (VeilRenderSystem.directStateAccessSupported()) {
            ARBDirectStateAccess.glClearNamedFramebufferfv((int)this.frameBufferId, (int)6144, (int)0, (float[])this.clearChannels);
        } else {
            this.bindWrite(true);
            GlStateManager._clearColor((float)this.clearChannels[0], (float)this.clearChannels[1], (float)this.clearChannels[2], (float)this.clearChannels[3]);
            GlStateManager._clear((int)16384, (boolean)clearError);
            this.unbindWrite();
        }
        if (clearError) {
            GL11C.glGetError();
        }
    }
}

