/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.forge;

import foundry.veil.Veil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.fallenbreath.conditionalmixin.api.mixin.RestrictiveMixinConfigPlugin;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class VeilMixinPlugin
extends RestrictiveMixinConfigPlugin {
    private static final Set<String> COMPAT = Set.of("foundry.veil.forge.mixin.client.stage", "foundry.veil.forge.mixin.client.perspective", "foundry.veil.forge.mixin.client.debug");
    private static final Set<String> SODIUM_WITHOUT_IRIS_COMPAT = Set.of();
    private final Map<String, Boolean> loadedMods = new HashMap<String, Boolean>();

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        for (String compat : COMPAT) {
            if (!mixinClassName.startsWith(compat)) continue;
            return Veil.SODIUM ? !mixinClassName.startsWith(compat + ".vanilla") : !mixinClassName.startsWith(compat + ".sodium");
        }
        if (mixinClassName.startsWith("foundry.veil.forge.mixin.compat")) {
            if (Veil.IRIS && SODIUM_WITHOUT_IRIS_COMPAT.contains(mixinClassName)) {
                return false;
            }
            String[] parts = mixinClassName.split("\\.");
            return this.loadedMods.computeIfAbsent(parts[5], Veil.platform()::isModLoaded) != false && super.shouldApplyMixin(targetClassName, mixinClassName);
        }
        return super.shouldApplyMixin(targetClassName, mixinClassName);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        super.preApply(targetClassName, targetClass, mixinClassName, mixinInfo);
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        super.postApply(targetClassName, targetClass, mixinClassName, mixinInfo);
    }

    public void preApply(String targetClassName, org.spongepowered.asm.lib.tree.ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, org.spongepowered.asm.lib.tree.ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

