/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.compiler;

import com.mojang.blaze3d.platform.GlStateManager;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.ext.VeilDebug;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.compiler.CompiledShader;
import foundry.veil.api.client.render.shader.compiler.ShaderCompiler;
import foundry.veil.api.client.render.shader.compiler.ShaderException;
import foundry.veil.api.client.render.shader.compiler.VeilShaderSource;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20C;

@ApiStatus.Internal
public class DirectShaderCompiler
implements ShaderCompiler {
    private final ShaderCompiler.ShaderProvider provider;

    public DirectShaderCompiler(@Nullable ShaderCompiler.ShaderProvider provider) {
        this.provider = provider;
    }

    private void validateType(int type) throws ShaderException {
        if (type == 37305 && !VeilRenderSystem.computeSupported()) {
            throw new ShaderException("Compute is not supported", null);
        }
    }

    @Override
    public CompiledShader compile(int type, ResourceLocation path) throws IOException, ShaderException {
        if (this.provider == null) {
            throw new IOException("Failed to read " + ShaderManager.getTypeName(type) + " from " + String.valueOf(path) + " because no provider was specified");
        }
        return this.compile(type, this.provider.getShader(path));
    }

    @Override
    public CompiledShader compile(int type, VeilShaderSource source) throws ShaderException {
        this.validateType(type);
        String sourceCode = source.sourceCode();
        ResourceLocation sourceId = source.sourceId();
        int shader = GL20C.glCreateShader((int)type);
        if (sourceId != null) {
            VeilDebug.get().objectLabel(33505, shader, ShaderManager.getTypeName(type) + " Shader " + String.valueOf(sourceId));
        }
        GlStateManager.glShaderSource((int)shader, List.of(sourceCode));
        GL20C.glCompileShader((int)shader);
        if (GL20C.glGetShaderi((int)shader, (int)35713) != 1) {
            Object log = GL20C.glGetShaderInfoLog((int)shader);
            if (Veil.VERBOSE_SHADER_ERRORS) {
                log = (String)log + "\n" + sourceCode;
            }
            GL20C.glDeleteShader((int)shader);
            throw new ShaderException("Failed to compile " + ShaderManager.getTypeName(type) + " shader", (String)log);
        }
        return new CompiledShader(sourceId, shader, (Object2IntMap<String>)Object2IntMaps.unmodifiable(source.uniformBindings()), Collections.unmodifiableSet(source.definitionDependencies()), Collections.unmodifiableSet(source.includes()));
    }

    public void free() {
    }
}

