/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.forge.impl;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.concurrent.ConcurrentConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mojang.datafixers.util.Pair;
import cpw.mods.niofs.union.UnionFileSystem;
import foundry.veil.Veil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import net.neoforged.fml.loading.moddiscovery.NightConfigWrapper;
import net.neoforged.neoforgespi.language.IConfigurable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ForgePackHooks {
    private ForgePackHooks() {
    }

    @Nullable
    public static Pair<String, Boolean> getIcon(Path path) {
        if (!(path.getFileSystem() instanceof UnionFileSystem)) {
            return null;
        }
        Path file = path.resolve("META-INF").resolve("neoforge.mods.toml");
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return null;
        }
        try {
            FileConfig fileConfig = FileConfig.builder((Path)file).build();
            fileConfig.load();
            fileConfig.close();
            NightConfigWrapper config = new NightConfigWrapper(ForgePackHooks.copyConfig((ConcurrentConfig)fileConfig));
            List mods = config.getConfigList(new String[]{"mods"});
            if (mods.isEmpty()) {
                return null;
            }
            IConfigurable mod = (IConfigurable)mods.getFirst();
            String logoFile = mod.getConfigElement(new String[]{"logoFile"}).orElse(null);
            boolean logoBlur = mod.getConfigElement(new String[]{"logoBlur"}).orElse(true);
            return logoFile != null ? Pair.of((Object)logoFile, (Object)logoBlur) : null;
        }
        catch (Throwable t) {
            Veil.LOGGER.error("Failed to load mod icon", t);
            return null;
        }
    }

    private static UnmodifiableConfig copyConfig(ConcurrentConfig config) {
        TomlFormat format = TomlFormat.instance();
        return ((CommentedConfig)format.createParser().parse(format.createWriter().writeToString((UnmodifiableConfig)config))).unmodifiable();
    }
}

