/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.editor.SingleWindowInspector;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.AdvancedFboTextureAttachment;
import foundry.veil.api.client.render.framebuffer.FramebufferAttachmentDefinition;
import foundry.veil.api.client.util.TextureDownloader;
import foundry.veil.api.compat.IrisCompat;
import foundry.veil.ext.iris.IrisRenderTargetExtension;
import imgui.ImGui;
import imgui.type.ImBoolean;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11C;

@ApiStatus.Internal
public class FramebufferInspector
extends SingleWindowInspector {
    public static final Component TITLE = Component.translatable((String)"inspector.veil.framebuffer.title");
    private static final Component SAVE = Component.translatable((String)"gui.veil.save");
    private static final Component SHOW_ALT = Component.translatable((String)"inspector.veil.framebuffer.iris.show_alt");
    private static final Component SHOW_ALT_TOOLTIP = Component.translatable((String)"inspector.veil.framebuffer.iris.show_alt.desc");
    private final Set<ResourceLocation> framebuffers = new TreeSet<ResourceLocation>();
    private final ImBoolean showAlt = new ImBoolean();
    private AdvancedFbo downloadFramebuffer;
    private IrisRenderTargetExtension downloadRenderTarget;

    @Override
    public Component getDisplayName() {
        return TITLE;
    }

    @Override
    public Component getGroup() {
        return RENDERER_GROUP;
    }

    @Override
    protected void renderComponents() {
        VeilRenderer renderer = VeilRenderSystem.renderer();
        if (ImGui.beginTabBar((String)"##framebuffers")) {
            this.framebuffers.addAll(renderer.getFramebufferManager().getFramebuffers().keySet());
            for (ResourceLocation id : this.framebuffers) {
                this.drawBuffers(id, fbo -> {
                    this.downloadFramebuffer = fbo;
                });
            }
            if (IrisCompat.INSTANCE != null) {
                Map<String, IrisRenderTargetExtension> renderTargets = IrisCompat.INSTANCE.getRenderTargets();
                this.framebuffers.clear();
                for (String name : renderTargets.keySet()) {
                    this.framebuffers.add(ResourceLocation.fromNamespaceAndPath((String)"iris", (String)name));
                }
                for (ResourceLocation id : this.framebuffers) {
                    this.drawRenderTarget(id, renderTargets.get(id.getPath()), renderTarget -> {
                        this.downloadRenderTarget = renderTarget;
                    });
                }
            }
            this.framebuffers.clear();
            ImGui.endTabBar();
        }
    }

    @Override
    public void renderLast() {
        Path outputFolder;
        Minecraft client;
        super.renderLast();
        if (this.downloadFramebuffer != null) {
            try {
                client = Minecraft.getInstance();
                outputFolder = Paths.get(client.gameDirectory.toURI()).resolve("debug-out").resolve("veil-framebuffer");
                if (!Files.exists(outputFolder, new LinkOption[0])) {
                    Files.createDirectories(outputFolder, new FileAttribute[0]);
                } else {
                    Files.walkFileTree(outputFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                LinkedList result = new LinkedList();
                for (int i = 0; i < this.downloadFramebuffer.getColorAttachments(); ++i) {
                    if (!this.downloadFramebuffer.isColorTextureAttachment(i)) continue;
                    AdvancedFboTextureAttachment attachment = this.downloadFramebuffer.getColorTextureAttachment(i);
                    Object name = attachment.getName() != null ? attachment.getName() : "Attachment " + i;
                    result.add(TextureDownloader.save((String)name, outputFolder, attachment.getId(), true));
                }
                if (this.downloadFramebuffer.isDepthTextureAttachment()) {
                    AdvancedFboTextureAttachment attachment = this.downloadFramebuffer.getDepthTextureAttachment();
                    String name = attachment.getName() != null ? attachment.getName() : "Depth Attachment";
                    result.add(TextureDownloader.save(name, outputFolder, attachment.getId(), true));
                }
                CompletableFuture.allOf(result.toArray(new CompletableFuture[0])).thenRunAsync(() -> Util.getPlatform().openFile(outputFolder.toFile()), (Executor)client);
            }
            catch (Exception e) {
                Veil.LOGGER.error("Failed to download framebuffer", (Throwable)e);
            }
            this.downloadFramebuffer = null;
        }
        if (this.downloadRenderTarget != null) {
            try {
                client = Minecraft.getInstance();
                outputFolder = Paths.get(client.gameDirectory.toURI()).resolve("debug-out").resolve("iris-rendertarget");
                if (!Files.exists(outputFolder, new LinkOption[0])) {
                    Files.createDirectories(outputFolder, new FileAttribute[0]);
                } else {
                    Files.walkFileTree(outputFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                String name = this.downloadRenderTarget.veil$getName();
                CompletableFuture.allOf(TextureDownloader.save(name + " Main", outputFolder, this.downloadRenderTarget.veil$getMainTexture(), true), TextureDownloader.save(name + " Alt", outputFolder, this.downloadRenderTarget.veil$getAltTexture(), true)).thenRunAsync(() -> Util.getPlatform().openFile(outputFolder.toFile()), (Executor)client);
            }
            catch (Exception e) {
                Veil.LOGGER.error("Failed to download iris render target", (Throwable)e);
            }
            this.downloadRenderTarget = null;
        }
    }

    private void drawBuffers(ResourceLocation id, @Nullable Consumer<AdvancedFbo> saveCallback) {
        AdvancedFbo buffer = VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(id);
        ImGui.beginDisabled((buffer == null ? 1 : 0) != 0);
        if (ImGui.beginTabItem((String)id.toString())) {
            if (buffer != null) {
                AdvancedFboTextureAttachment attachment;
                int i;
                int columns = (int)Math.ceil(Math.sqrt(buffer.getColorAttachments() + (buffer.isDepthTextureAttachment() ? 1 : 0)));
                float width = ImGui.getContentRegionAvailX() / (float)columns - ImGui.getStyle().getItemSpacingX();
                float height = width * (float)buffer.getHeight() / (float)buffer.getWidth();
                for (i = 0; i < buffer.getColorAttachments(); ++i) {
                    if (!buffer.isColorTextureAttachment(i)) continue;
                    if (i % columns != 0) {
                        ImGui.sameLine();
                    }
                    ImGui.beginGroup();
                    attachment = buffer.getColorTextureAttachment(i);
                    ImGui.text((String)FramebufferInspector.getAttachmentName(i, attachment.getId(), attachment.getName()));
                    ImGui.image((int)attachment.getId(), (float)width, (float)height, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                    ImGui.endGroup();
                }
                if (buffer.isDepthTextureAttachment()) {
                    if (i % columns != 0) {
                        ImGui.sameLine();
                    }
                    ImGui.beginGroup();
                    attachment = buffer.getDepthTextureAttachment();
                    ImGui.text((String)FramebufferInspector.getAttachmentName(-1, attachment.getId(), attachment.getName()));
                    ImGui.image((int)attachment.getId(), (float)width, (float)height, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                    ImGui.endGroup();
                }
                if (saveCallback != null && ImGui.button((String)SAVE.getString(), (float)(ImGui.getContentRegionAvailX() - 4.0f), (float)0.0f)) {
                    saveCallback.accept(buffer);
                }
            }
            ImGui.endTabItem();
        }
        ImGui.endDisabled();
    }

    private void drawRenderTarget(ResourceLocation id, @Nullable IrisRenderTargetExtension renderTarget, @Nullable Consumer<IrisRenderTargetExtension> saveCallback) {
        ImGui.beginDisabled((renderTarget == null ? 1 : 0) != 0);
        if (ImGui.beginTabItem((String)id.toString())) {
            ImGui.checkbox((String)SHOW_ALT.getString(), (ImBoolean)this.showAlt);
            if (ImGui.isItemHovered()) {
                VeilImGuiUtil.setTooltip((FormattedText)SHOW_ALT_TOOLTIP);
            }
            if (renderTarget != null) {
                float width = ImGui.getContentRegionAvailX() - ImGui.getStyle().getItemSpacingX();
                float height = width * (float)renderTarget.veil$getHeight() / (float)renderTarget.veil$getWidth();
                int texture = this.showAlt.get() ? renderTarget.veil$getAltTexture() : renderTarget.veil$getMainTexture();
                ImGui.beginGroup();
                ImGui.text((String)FramebufferInspector.getAttachmentName(0, texture, this.showAlt.get() ? "Alt" : "Main"));
                ImGui.image((int)texture, (float)width, (float)height, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                ImGui.endGroup();
                if (saveCallback != null && ImGui.button((String)SAVE.getString(), (float)(ImGui.getContentRegionAvailX() - 4.0f), (float)0.0f)) {
                    saveCallback.accept(renderTarget);
                }
            }
            ImGui.endTabItem();
        }
        ImGui.endDisabled();
    }

    private static String getAttachmentName(int index, int id, @Nullable String name) {
        RenderSystem.bindTexture((int)id);
        StringBuilder attachmentName = new StringBuilder(name != null ? name : (index == -1 ? I18n.get((String)"inspector.veil.framebuffer.depth_attachment", (Object[])new Object[0]) : I18n.get((String)"inspector.veil.framebuffer.color_attachment", (Object[])new Object[]{index})));
        int internalFormat = GL11C.glGetTexLevelParameteri((int)3553, (int)0, (int)4099);
        for (FramebufferAttachmentDefinition.Format format : FramebufferAttachmentDefinition.Format.values()) {
            if (internalFormat != format.getInternalFormat()) continue;
            attachmentName.append(" (").append(format.name()).append(")");
            return attachmentName.toString();
        }
        attachmentName.append(" (0x%X)".formatted(internalFormat));
        return attachmentName.toString();
    }
}

