/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.dynamicbuffer.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.FramebufferStack;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferShard;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class}, priority=200)
public abstract class DynamicBufferLevelRendererMixin {
    @Unique
    private final DynamicBufferShard veil$weatherBufferShard = new DynamicBufferShard("weather", this::getWeatherTarget);

    @Shadow
    @Nullable
    public abstract RenderTarget getWeatherTarget();

    @Shadow
    @Nullable
    public abstract RenderTarget getParticlesTarget();

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;setupRender(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;ZZ)V", shift=At.Shift.BEFORE)})
    public void setupOpaque(CallbackInfo ci) {
        VeilRenderSystem.renderer().getDynamicBufferManger().setEnabled(true);
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/pipeline/RenderTarget;bindWrite(Z)V")})
    public void bindWrite(RenderTarget instance, boolean setViewport, Operation<Void> original) {
        if (FramebufferStack.isEmpty()) {
            original.call(new Object[]{instance, setViewport});
        } else {
            FramebufferStack.pop(null);
        }
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderStateShard$OutputStateShard;setupRenderState()V")})
    public void setupState(RenderStateShard.OutputStateShard instance, Operation<Void> original) {
        if ("weather_target".equals(VeilRenderType.getName((RenderStateShard)instance))) {
            this.veil$weatherBufferShard.setupRenderState();
        } else if (!"particles_target".equals(VeilRenderType.getName((RenderStateShard)instance))) {
            original.call(new Object[]{instance});
        }
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderStateShard$OutputStateShard;setupRenderState()V")})
    public void clearState(RenderStateShard.OutputStateShard instance, Operation<Void> original) {
        if ("weather_target".equals(VeilRenderType.getName((RenderStateShard)instance))) {
            this.veil$weatherBufferShard.clearRenderState();
        } else if (!"particles_target".equals(VeilRenderType.getName((RenderStateShard)instance))) {
            original.call(new Object[]{instance});
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V", shift=At.Shift.BEFORE)})
    public void setRainBlend(CallbackInfo ci) {
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/OutlineBufferSource;endOutlineBatch()V", ordinal=0)})
    public void endOpaque(CallbackInfo ci) {
        VeilRenderSystem.renderer().getDynamicBufferManger().setEnabled(false);
    }

    @Inject(method={"renderLevel"}, at={@At(value="TAIL")})
    public void blit(CallbackInfo ci) {
        VeilRenderSystem.renderer().getDynamicBufferManger().setEnabled(false);
    }
}

