/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.performance.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ScreenEffectRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.dimension.DimensionType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ScreenEffectRenderer.class})
public class PerformanceScreenEffectRendererMixin {
    @Shadow
    @Final
    private static ResourceLocation UNDERWATER_LOCATION;
    @Unique
    private static final ResourceLocation BLIT_SCREEN_EFFECT_SHADER;

    @Inject(method={"renderTex"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderTex(TextureAtlasSprite texture, PoseStack poseStack, CallbackInfo ci) {
        float yScale;
        float xScale;
        ShaderProgram shader = VeilRenderSystem.setShader(BLIT_SCREEN_EFFECT_SHADER);
        if (shader == null) {
            return;
        }
        ci.cancel();
        Minecraft minecraft = Minecraft.getInstance();
        Window window = minecraft.getWindow();
        if (window.getWidth() > window.getHeight()) {
            xScale = 1.0f;
            yScale = (float)window.getHeight() / (float)window.getWidth();
        } else {
            xScale = (float)window.getWidth() / (float)window.getHeight();
            yScale = 1.0f;
        }
        float u0 = texture.getU0();
        float v0 = texture.getV0();
        float u1 = texture.getU1();
        float v1 = texture.getV1();
        float uWidth = u1 - u0;
        float vHeight = v1 - v0;
        shader.setVector("ColorModulator", 0.1f, 0.1f, 0.1f, 1.0f);
        shader.setVector("TexOffset", u0 + uWidth * (1.0f - xScale), v0 + vHeight * (1.0f - yScale), uWidth * xScale, vHeight * yScale);
        int activeTexture = GlStateManager._getActiveTexture();
        RenderSystem.activeTexture((int)33984);
        minecraft.getTextureManager().bindForSetup(texture.atlasLocation());
        shader.bind();
        VeilRenderSystem.drawScreenQuad();
        ShaderProgram.unbind();
        RenderSystem.activeTexture((int)activeTexture);
    }

    @Inject(method={"renderWater"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderWater(Minecraft minecraft, PoseStack poseStack, CallbackInfo ci) {
        float yScale;
        float xScale;
        ShaderProgram shader = VeilRenderSystem.setShader(BLIT_SCREEN_EFFECT_SHADER);
        if (shader == null) {
            return;
        }
        ci.cancel();
        LocalPlayer player = minecraft.player;
        Window window = minecraft.getWindow();
        if (window.getWidth() > window.getHeight()) {
            xScale = 1.0f;
            yScale = (float)window.getHeight() / (float)window.getWidth();
        } else {
            xScale = (float)window.getWidth() / (float)window.getHeight();
            yScale = 1.0f;
        }
        float brightness = LightTexture.getBrightness((DimensionType)player.level().dimensionType(), (int)player.level().getMaxLocalRawBrightness(player.blockPosition()));
        float u = player.getYRot() / 64.0f;
        float v = -player.getXRot() / 64.0f;
        shader.setVector("ColorModulator", brightness, brightness, brightness, 0.1f);
        shader.setVector("TexOffset", u + 2.0f * (1.0f - xScale), v + 2.0f * (1.0f - yScale), 2.0f * xScale, 2.0f * yScale);
        int activeTexture = GlStateManager._getActiveTexture();
        RenderSystem.activeTexture((int)33984);
        minecraft.getTextureManager().bindForSetup(UNDERWATER_LOCATION);
        RenderSystem.enableBlend();
        shader.bind();
        VeilRenderSystem.drawScreenQuad();
        ShaderProgram.unbind();
        RenderSystem.disableBlend();
        RenderSystem.activeTexture((int)activeTexture);
    }

    static {
        BLIT_SCREEN_EFFECT_SHADER = Veil.veilPath("core/blit_screen_effect");
    }
}

