/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.forge.compat.sodium;

import foundry.veil.api.compat.SodiumCompat;
import foundry.veil.forge.ext.ShaderChunkRendererExtension;
import foundry.veil.forge.mixin.compat.sodium.RenderSectionManagerAccessor;
import foundry.veil.forge.mixin.compat.sodium.SodiumWorldRendererAccessor;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.Map;
import net.caffeinemc.mods.sodium.client.gl.shader.GlProgram;
import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkFogMode;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderOptions;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class VeilForgeSodiumCompat
implements SodiumCompat {
    @NotNull
    private static StringBuilder getShaderName(ChunkShaderOptions options) {
        TerrainRenderPass pass;
        StringBuilder name = new StringBuilder("chunk_shader");
        if (options.fog() == ChunkFogMode.SMOOTH) {
            name.append("_fog_smooth");
        }
        if ((pass = options.pass()).isTranslucent()) {
            name.append("_translucent");
        }
        if (pass.supportsFragmentDiscard()) {
            name.append("_cutout");
        }
        return name;
    }

    @Override
    public Object2IntMap<ResourceLocation> getLoadedShaders() {
        ChunkRenderer chunkRenderer;
        RenderSectionManagerAccessor renderSectionManager;
        SodiumWorldRenderer worldRenderer = SodiumWorldRenderer.instanceNullable();
        if (worldRenderer != null && (renderSectionManager = (RenderSectionManagerAccessor)((SodiumWorldRendererAccessor)worldRenderer).getRenderSectionManager()) != null && (chunkRenderer = renderSectionManager.getChunkRenderer()) instanceof ShaderChunkRendererExtension) {
            ShaderChunkRendererExtension extension = (ShaderChunkRendererExtension)chunkRenderer;
            Object2IntArrayMap shaders = new Object2IntArrayMap(extension.veil$getPrograms().size());
            for (Map.Entry<ChunkShaderOptions, GlProgram<ChunkShaderInterface>> entry : extension.veil$getPrograms().entrySet()) {
                StringBuilder name = VeilForgeSodiumCompat.getShaderName(entry.getKey());
                shaders.put((Object)ResourceLocation.fromNamespaceAndPath((String)"sodium", (String)name.toString()), entry.getValue().handle());
            }
            return shaders;
        }
        return Object2IntMaps.emptyMap();
    }

    @Override
    public void recompile() {
        ChunkRenderer chunkRenderer;
        RenderSectionManagerAccessor renderSectionManager;
        SodiumWorldRenderer worldRenderer = SodiumWorldRenderer.instanceNullable();
        if (worldRenderer != null && (renderSectionManager = (RenderSectionManagerAccessor)((SodiumWorldRendererAccessor)worldRenderer).getRenderSectionManager()) != null && (chunkRenderer = renderSectionManager.getChunkRenderer()) instanceof ShaderChunkRendererExtension) {
            ShaderChunkRendererExtension extension = (ShaderChunkRendererExtension)chunkRenderer;
            extension.veil$recompile();
        }
    }

    @Override
    public void setActiveBuffers(int activeBuffers) {
        ChunkRenderer chunkRenderer;
        RenderSectionManagerAccessor renderSectionManager;
        SodiumWorldRenderer worldRenderer = SodiumWorldRenderer.instanceNullable();
        if (worldRenderer != null && (renderSectionManager = (RenderSectionManagerAccessor)((SodiumWorldRendererAccessor)worldRenderer).getRenderSectionManager()) != null && (chunkRenderer = renderSectionManager.getChunkRenderer()) instanceof ShaderChunkRendererExtension) {
            ShaderChunkRendererExtension extension = (ShaderChunkRendererExtension)chunkRenderer;
            extension.veil$setActiveBuffers(activeBuffers);
        }
    }

    @Override
    public void markChunksDirty() {
        RenderSectionManagerAccessor renderSectionManager;
        SodiumWorldRenderer worldRenderer = SodiumWorldRenderer.instanceNullable();
        if (worldRenderer != null && (renderSectionManager = (RenderSectionManagerAccessor)((SodiumWorldRendererAccessor)worldRenderer).getRenderSectionManager()) != null) {
            Long2ReferenceMap<RenderSection> map = renderSectionManager.getSectionByPosition();
            LongIterator longIterator = map.keySet().iterator();
            while (longIterator.hasNext()) {
                long longPos = (Long)longIterator.next();
                SectionPos sectionPos = SectionPos.of((long)longPos);
                ((SodiumWorldRendererAccessor)worldRenderer).getRenderSectionManager().scheduleRebuild(sectionPos.x(), sectionPos.y(), sectionPos.z(), true);
            }
        }
    }
}

