/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.post.stage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.client.registry.PostPipelineStageRegistry;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferDefinition;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.shader.texture.ShaderTextureSource;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import foundry.veil.impl.client.render.shader.program.ShaderProgramImpl;
import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix2fc;
import org.joml.Matrix3fc;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3fc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.joml.Vector4fc;
import org.joml.Vector4ic;
import org.lwjgl.system.NativeResource;

public final class CompositePostPipeline
implements PostPipeline {
    private static final Codec<Map<ResourceLocation, FramebufferDefinition>> FRAMEBUFFER_CODEC = Codec.unboundedMap((Codec)Codec.STRING.xmap(name -> ResourceLocation.fromNamespaceAndPath((String)"temp", (String)name), ResourceLocation::getPath), FramebufferDefinition.CODEC);
    public static final Codec<CompositePostPipeline> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PostPipeline.CODEC.listOf().fieldOf("stages").forGetter(pipeline -> Arrays.asList(pipeline.getStages())), (App)Codec.unboundedMap((Codec)Codec.STRING, ShaderTextureSource.CODEC).optionalFieldOf("textures", Collections.emptyMap()).forGetter(CompositePostPipeline::getTextureSources), (App)FRAMEBUFFER_CODEC.optionalFieldOf("framebuffers", Collections.emptyMap()).forGetter(CompositePostPipeline::getFramebuffers), (App)VeilRenderLevelStageEvent.Stage.CODEC.optionalFieldOf("renderStage").forGetter(pipeline -> Optional.ofNullable(pipeline.getRenderStage())), (App)DynamicBufferType.PACKED_LIST_CODEC.optionalFieldOf("dynamicBuffers", (Object)0).forGetter(CompositePostPipeline::getDynamicBuffersMask), (App)Codec.INT.optionalFieldOf("priority", (Object)1000).forGetter(CompositePostPipeline::getPriority), (App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(CompositePostPipeline::isReplace)).apply((Applicative)instance, (pipelines, textures, framebuffers, renderStage, dynamicBuffers, priority, replace) -> new CompositePostPipeline((PostPipeline[])pipelines.toArray(PostPipeline[]::new), (Map<String, ShaderTextureSource>)textures, (Map<ResourceLocation, FramebufferDefinition>)framebuffers, renderStage.orElse(null), (int)dynamicBuffers, (int)priority, (boolean)replace)));
    private final PostPipeline[] stages;
    private final Map<String, ShaderTextureSource> textureSources;
    private final Map<String, ShaderProgramImpl.ShaderTexture> textures;
    private final Map<ResourceLocation, FramebufferDefinition> framebufferDefinitions;
    private final VeilRenderLevelStageEvent.Stage renderStage;
    private final Map<ResourceLocation, AdvancedFbo> framebuffers;
    private final DynamicBufferType[] dynamicBuffers;
    private final int dynamicBuffersMask;
    private final int priority;
    private final boolean replace;
    private int screenWidth = -1;
    private int screenHeight = -1;

    private CompositePostPipeline(PostPipeline[] stages, Map<String, ShaderTextureSource> textures, Map<ResourceLocation, FramebufferDefinition> framebufferDefinitions, @Nullable VeilRenderLevelStageEvent.Stage renderStage, int dynamicBuffers, int priority, boolean replace) {
        this.stages = stages;
        this.textureSources = Collections.unmodifiableMap(textures);
        this.textures = new HashMap<String, ShaderProgramImpl.ShaderTexture>(textures.size());
        VeilRenderSystem.renderThreadExecutor().execute(() -> {
            for (Map.Entry entry : textures.entrySet()) {
                this.textures.put((String)entry.getKey(), ShaderProgramImpl.ShaderTexture.create((ShaderTextureSource)entry.getValue()));
            }
        });
        this.framebufferDefinitions = Collections.unmodifiableMap(framebufferDefinitions);
        this.renderStage = renderStage;
        this.framebuffers = new HashMap<ResourceLocation, AdvancedFbo>();
        this.dynamicBuffers = DynamicBufferType.decode(dynamicBuffers);
        this.dynamicBuffersMask = dynamicBuffers;
        this.priority = priority;
        this.replace = replace;
    }

    public CompositePostPipeline(PostPipeline[] stages, Map<String, ShaderTextureSource> textures, Map<ResourceLocation, FramebufferDefinition> framebufferDefinitions, @Nullable VeilRenderLevelStageEvent.Stage renderStage, int dynamicBuffers) {
        this(stages, textures, framebufferDefinitions, renderStage, dynamicBuffers, 1000, false);
    }

    @Override
    public void apply(PostPipeline.Context context) {
        AdvancedFbo main = context.getDrawFramebuffer();
        if (this.screenWidth != main.getWidth() || this.screenHeight != main.getHeight()) {
            this.screenWidth = main.getWidth();
            this.screenHeight = main.getHeight();
            this.framebuffers.values().forEach(NativeResource::free);
            this.framebuffers.clear();
            MolangRuntime molangRuntime = (MolangRuntime)MolangRuntime.runtime().setQuery("screen_width", (float)this.screenWidth).setQuery("screen_height", (float)this.screenHeight).create();
            this.framebufferDefinitions.forEach((name, definition) -> this.framebuffers.put((ResourceLocation)name, definition.createBuilder((MolangEnvironment)runtime).setDebugLabel("Temp " + String.valueOf(name)).build(true)));
        }
        this.framebuffers.forEach(context::setFramebuffer);
        for (DynamicBufferType dynamicBufferType : this.dynamicBuffers) {
            context.setSampler(dynamicBufferType.getSourceName(), VeilRenderSystem.renderer().getDynamicBufferManger().getBufferTexture(dynamicBufferType), 0);
        }
        this.textures.forEach((name, texture) -> context.setSampler((CharSequence)name, texture.textureSource().getId(context), texture.samplerId()));
        for (PostPipeline postPipeline : this.stages) {
            postPipeline.apply(context);
        }
    }

    @Override
    public void free() {
        for (PostPipeline pipeline : this.stages) {
            pipeline.free();
        }
        this.framebuffers.values().forEach(NativeResource::free);
        this.framebuffers.clear();
    }

    @Override
    public PostPipelineStageRegistry.PipelineType<? extends PostPipeline> getType() {
        throw new UnsupportedOperationException("Composite pipelines cannot be encoded");
    }

    @Override
    public boolean hasUniform(CharSequence name) {
        for (PostPipeline pipeline : this.stages) {
            if (!pipeline.hasUniform(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasUniformBlock(CharSequence name) {
        for (PostPipeline pipeline : this.stages) {
            if (!pipeline.hasUniformBlock(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasStorageBlock(CharSequence name) {
        for (PostPipeline pipeline : this.stages) {
            if (!pipeline.hasStorageBlock(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setUniformBlock(CharSequence name, int binding) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setUniformBlock(name, binding);
        }
    }

    @Override
    public void setStorageBlock(CharSequence name, int binding) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setStorageBlock(name, binding);
        }
    }

    @Override
    public void setFloat(CharSequence name, float value) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setFloat(name, value);
        }
    }

    @Override
    public void setVector(CharSequence name, float x, float y) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setVector(name, x, y);
        }
    }

    @Override
    public void setVector(CharSequence name, float x, float y, float z) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setVector(name, x, y, z);
        }
    }

    @Override
    public void setVector(CharSequence name, float x, float y, float z, float w) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setVector(name, x, y, z, w);
        }
    }

    @Override
    public void setInt(CharSequence name, int value) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setInt(name, value);
        }
    }

    @Override
    public void setVectorI(CharSequence name, int x, int y) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setVectorI(name, x, y);
        }
    }

    @Override
    public void setVectorI(CharSequence name, int x, int y, int z) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setVectorI(name, x, y, z);
        }
    }

    @Override
    public void setVectorI(CharSequence name, int x, int y, int z, int w) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setVectorI(name, x, y, z, w);
        }
    }

    @Override
    public void setFloats(CharSequence name, float ... values) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setFloats(name, values);
        }
    }

    @Override
    public void setVectors(CharSequence name, Vector2fc ... values) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setVectors(name, values);
        }
    }

    @Override
    public void setVectors(CharSequence name, Vector3fc ... values) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setVectors(name, values);
        }
    }

    @Override
    public void setVectors(CharSequence name, Vector4fc ... values) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setVectors(name, values);
        }
    }

    @Override
    public void setInts(CharSequence name, int ... values) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setInts(name, values);
        }
    }

    @Override
    public void setVectors(CharSequence name, Vector2ic ... values) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setVectors(name, values);
        }
    }

    @Override
    public void setVectors(CharSequence name, Vector3ic ... values) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setVectors(name, values);
        }
    }

    @Override
    public void setVectors(CharSequence name, Vector4ic ... values) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setVectors(name, values);
        }
    }

    @Override
    public void setMatrix(CharSequence name, Matrix2fc value, boolean transpose) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setMatrix(name, value, transpose);
        }
    }

    @Override
    public void setMatrix(CharSequence name, Matrix3fc value, boolean transpose) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setMatrix(name, value, transpose);
        }
    }

    @Override
    public void setMatrix(CharSequence name, Matrix3x2fc value, boolean transpose) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setMatrix(name, value, transpose);
        }
    }

    @Override
    public void setMatrix(CharSequence name, Matrix4fc value, boolean transpose) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setMatrix(name, value, transpose);
        }
    }

    @Override
    public void setMatrix(CharSequence name, Matrix4x3fc value, boolean transpose) {
        for (PostPipeline pipeline : this.stages) {
            pipeline.setMatrix(name, value, transpose);
        }
    }

    public PostPipeline[] getStages() {
        return this.stages;
    }

    public Map<String, ShaderTextureSource> getTextureSources() {
        return this.textureSources;
    }

    public Map<ResourceLocation, FramebufferDefinition> getFramebuffers() {
        return this.framebufferDefinitions;
    }

    public DynamicBufferType[] getDynamicBuffers() {
        return this.dynamicBuffers;
    }

    @Nullable
    public VeilRenderLevelStageEvent.Stage getRenderStage() {
        return this.renderStage;
    }

    public int getDynamicBuffersMask() {
        return this.dynamicBuffersMask;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isReplace() {
        return this.replace;
    }
}

