/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.necromancer.render;

import com.mojang.blaze3d.vertex.PoseStack;
import foundry.veil.api.client.necromancer.Skeleton;
import foundry.veil.api.client.necromancer.SkeletonParent;
import foundry.veil.api.client.necromancer.animation.Animator;
import foundry.veil.api.client.necromancer.render.NecromancerEntityRenderLayer;
import foundry.veil.api.client.necromancer.render.NecromancerRenderer;
import foundry.veil.api.client.render.MatrixStack;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.impl.client.necromancer.render.NecromancerRenderDispatcher;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public abstract class NecromancerEntityRenderer<P extends Entity, S extends Skeleton>
extends EntityRenderer<P> {
    private final List<NecromancerEntityRenderLayer<P, S>> layers;

    protected NecromancerEntityRenderer(EntityRendererProvider.Context context, float shadowRadius) {
        super(context);
        this.shadowRadius = shadowRadius;
        this.layers = new ObjectArrayList();
    }

    public void addLayer(NecromancerEntityRenderLayer<P, S> layer) {
        this.layers.add(layer);
    }

    public final void setupEntity(P parent) {
        S skeleton = this.createSkeleton(parent);
        ((SkeletonParent)parent).setSkeleton(skeleton);
        ((SkeletonParent)parent).setAnimator(this.createAnimator(parent, skeleton));
    }

    public abstract S createSkeleton(P var1);

    public abstract Animator<P, S> createAnimator(P var1, S var2);

    public void render(P parent, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        NecromancerRenderer renderer = NecromancerRenderDispatcher.getRenderer();
        this.render(parent, renderer, VeilRenderBridge.create(poseStack), packedLight, partialTick);
        super.render(parent, entityYaw, partialTick, poseStack, (MultiBufferSource)renderer, packedLight);
    }

    public void render(P parent, NecromancerRenderer renderer, MatrixStack matrixStack, int packedLight, float partialTicks) {
        Object skeleton = ((SkeletonParent)parent).getSkeleton();
        if (skeleton == null) {
            return;
        }
        matrixStack.matrixPush();
        matrixStack.applyScale(0.0625f);
        for (NecromancerEntityRenderLayer<P, S> layer : this.layers) {
            layer.render(parent, skeleton, renderer, matrixStack, packedLight, partialTicks);
        }
        matrixStack.matrixPop();
    }

    public ResourceLocation getTextureLocation(P entity) {
        throw new UnsupportedOperationException();
    }
}

