/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.glsl.node;

import foundry.veil.impl.glsl.GlslInjectionPoint;
import foundry.veil.impl.glsl.grammar.GlslVersion;
import foundry.veil.impl.glsl.node.GlslCompoundNode;
import foundry.veil.impl.glsl.node.GlslEmptyNode;
import foundry.veil.impl.glsl.node.GlslNode;
import foundry.veil.impl.glsl.node.function.GlslFunctionNode;
import foundry.veil.impl.glsl.node.variable.GlslDeclaration;
import foundry.veil.impl.glsl.node.variable.GlslNewNode;
import foundry.veil.impl.glsl.node.variable.GlslStructNode;
import foundry.veil.impl.glsl.visitor.GlslFunctionVisitor;
import foundry.veil.impl.glsl.visitor.GlslTreeVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class GlslTree {
    private final GlslVersion version;
    private final List<GlslNode> body;
    private final List<String> directives;
    private final Map<String, GlslNode> markers;

    public GlslTree(GlslVersion version, Collection<GlslNode> body, Collection<String> directives, Map<String, GlslNode> markers) {
        this.version = version;
        this.body = new ArrayList<GlslNode>(body);
        this.directives = new ArrayList<String>(directives);
        this.markers = Collections.unmodifiableMap(markers);
    }

    private void visit(GlslTreeVisitor visitor, GlslNode node) {
        if (node instanceof GlslFunctionNode) {
            GlslFunctionNode functionNode = (GlslFunctionNode)node;
            GlslFunctionVisitor functionVisitor = visitor.visitFunction(functionNode);
            if (functionVisitor != null) {
                functionNode.visit(functionVisitor);
            }
            return;
        }
        if (node instanceof GlslNewNode) {
            GlslNewNode newNode = (GlslNewNode)node;
            visitor.visitField(newNode);
            return;
        }
        if (node instanceof GlslStructNode) {
            GlslStructNode struct = (GlslStructNode)node;
            visitor.visitStruct(struct);
            return;
        }
        if (node instanceof GlslDeclaration) {
            GlslDeclaration declaration = (GlslDeclaration)node;
            visitor.visitDeclaration(declaration);
            return;
        }
        throw new AssertionError((Object)"Not Possible");
    }

    public void visit(GlslTreeVisitor visitor) {
        visitor.visitMarkers(this.markers);
        visitor.visitVersion(this.version);
        for (String directive : this.directives) {
            visitor.visitDirective(directive);
        }
        for (GlslNode node : this.body) {
            if (node instanceof GlslEmptyNode) continue;
            if (node instanceof GlslCompoundNode) {
                GlslCompoundNode compoundNode = (GlslCompoundNode)node;
                for (GlslNode child : compoundNode.getChildren()) {
                    this.visit(visitor, child);
                }
                continue;
            }
            this.visit(visitor, node);
        }
        visitor.visitTreeEnd();
    }

    public Optional<GlslFunctionNode> mainFunction() {
        return this.functions().filter(node -> node.getHeader().getName().equals("main")).findFirst();
    }

    public Stream<GlslFunctionNode> functions() {
        return this.body.stream().filter(node -> node instanceof GlslFunctionNode).map(node -> (GlslFunctionNode)node);
    }

    public Optional<GlslNewNode> field(String name) {
        return this.body.stream().filter(node -> {
            GlslNewNode newNode;
            return node instanceof GlslNewNode && name.equals((newNode = (GlslNewNode)node).getName());
        }).findFirst().map(newNode -> (GlslNewNode)newNode);
    }

    public Stream<GlslNewNode> fields() {
        return this.body.stream().filter(node -> node instanceof GlslNewNode).map(node -> (GlslNewNode)node);
    }

    public void add(GlslNode node) {
        this.body.add(node);
    }

    public void addAll(Collection<GlslNode> nodes) {
        this.body.addAll(nodes);
    }

    public void add(GlslInjectionPoint point, GlslNode node) {
        this.body.add(this.getInjectionIndex(point), node);
    }

    public void addAll(GlslInjectionPoint point, Collection<GlslNode> nodes) {
        this.body.addAll(this.getInjectionIndex(point), nodes);
    }

    public int getInjectionIndex(GlslInjectionPoint point) {
        switch (point) {
            case BEFORE_DECLARATIONS: {
                for (int i = 0; i < this.body.size(); ++i) {
                    if (this.body.get(i) instanceof GlslFunctionNode) continue;
                    return i;
                }
                break;
            }
            case AFTER_DECLARATIONS: {
                for (int i = 0; i < this.body.size(); ++i) {
                    if (!(this.body.get(i) instanceof GlslFunctionNode)) continue;
                    return i + 1;
                }
                break;
            }
            case BEFORE_MAIN: {
                for (int i = 0; i < this.body.size(); ++i) {
                    GlslFunctionNode functionNode;
                    GlslNode glslNode = this.body.get(i);
                    if (!(glslNode instanceof GlslFunctionNode) || !(functionNode = (GlslFunctionNode)glslNode).getHeader().getName().equals("main")) continue;
                    return i;
                }
                break;
            }
            case AFTER_MAIN: {
                for (int i = 0; i < this.body.size(); ++i) {
                    GlslFunctionNode functionNode;
                    GlslNode glslNode = this.body.get(i);
                    if (!(glslNode instanceof GlslFunctionNode) || !(functionNode = (GlslFunctionNode)glslNode).getHeader().getName().equals("main")) continue;
                    return i + 1;
                }
                break;
            }
            case BEFORE_FUNCTIONS: {
                for (int i = 0; i < this.body.size(); ++i) {
                    if (this.body.get(i) instanceof GlslFunctionNode) continue;
                    return i;
                }
                break;
            }
            case AFTER_FUNCTIONS: {
                for (int i = 0; i < this.body.size(); ++i) {
                    if (this.body.get(i) instanceof GlslFunctionNode) continue;
                    return i + 1;
                }
                break;
            }
        }
        return 0;
    }

    public GlslVersion getVersion() {
        return this.version;
    }

    public List<GlslNode> getBody() {
        return this.body;
    }

    public List<String> getDirectives() {
        return this.directives;
    }

    public Map<String, GlslNode> getMarkers() {
        return this.markers;
    }

    public String toString() {
        return "GlslTree{version=" + String.valueOf(this.version) + ", body=" + String.valueOf(this.body) + "}";
    }
}

