/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.glsl.grammar;

import foundry.veil.impl.glsl.grammar.GlslType;
import foundry.veil.impl.glsl.grammar.GlslTypeQualifier;
import foundry.veil.impl.glsl.grammar.GlslTypeSpecifier;
import foundry.veil.impl.glsl.node.GlslNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GlslSpecifiedType
implements GlslType {
    private GlslTypeSpecifier specifier;
    private final List<GlslTypeQualifier> qualifiers;

    public GlslSpecifiedType(GlslTypeSpecifier specifier) {
        this.specifier = specifier;
        this.qualifiers = new ArrayList<GlslTypeQualifier>();
    }

    public GlslSpecifiedType(GlslTypeSpecifier specifier, Collection<GlslTypeQualifier> qualifiers) {
        this(specifier);
        this.qualifiers.addAll(qualifiers);
    }

    public GlslSpecifiedType(GlslTypeSpecifier specifier, GlslTypeQualifier ... qualifiers) {
        this(specifier);
        this.qualifiers.addAll(Arrays.asList(qualifiers));
    }

    public GlslTypeSpecifier getSpecifier() {
        return this.specifier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GlslSpecifiedType addLayoutId(String identifier, @Nullable GlslNode expression) {
        GlslTypeQualifier qualifier;
        Iterator<GlslTypeQualifier> iterator = this.qualifiers.iterator();
        do {
            if (iterator.hasNext()) continue;
            this.qualifiers.addFirst(GlslTypeQualifier.layout(Collections.singleton(new GlslTypeQualifier.LayoutId(identifier, expression))));
            return this;
        } while (!((qualifier = iterator.next()) instanceof GlslTypeQualifier.Layout));
        GlslTypeQualifier.Layout layout = (GlslTypeQualifier.Layout)qualifier;
        try {
            List<GlslTypeQualifier.LayoutId> list;
            List<GlslTypeQualifier.LayoutId> layoutIds = list = layout.layoutIds();
            layoutIds.add(new GlslTypeQualifier.LayoutId(identifier, expression));
            return this;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public List<GlslTypeQualifier> getQualifiers() {
        return this.qualifiers;
    }

    public GlslSpecifiedType setSpecifier(GlslTypeSpecifier specifier) {
        this.specifier = specifier;
        return this;
    }

    public GlslSpecifiedType setQualifiers(GlslTypeQualifier ... qualifiers) {
        this.qualifiers.clear();
        this.qualifiers.addAll(Arrays.asList(qualifiers));
        return this;
    }

    public GlslSpecifiedType setQualifiers(Collection<GlslTypeQualifier> qualifiers) {
        this.qualifiers.clear();
        this.qualifiers.addAll(qualifiers);
        return this;
    }

    public String getSourceString() {
        StringBuilder builder = new StringBuilder();
        for (GlslTypeQualifier qualifier : this.qualifiers) {
            builder.append(qualifier.getSourceString()).append(" ");
        }
        builder.append(this.specifier.getSourceString());
        return builder.toString();
    }

    public String getPostSourceString() {
        return this.specifier.getPostSourceString();
    }

    public String toString() {
        return "GlslSpecifiedType[specifier=" + String.valueOf(this.specifier) + ", qualifiers=" + String.valueOf(this.qualifiers);
    }

    @Override
    public GlslSpecifiedType asSpecifiedType() {
        return this;
    }
}

