/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader;

import foundry.veil.api.client.render.shader.CompiledShader;
import foundry.veil.api.client.render.shader.ShaderCompiler;
import foundry.veil.api.client.render.shader.ShaderException;
import foundry.veil.api.client.render.shader.VeilShaderSource;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import foundry.veil.impl.client.render.shader.DirectShaderCompiler;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CachedShaderCompiler
extends DirectShaderCompiler {
    private final Int2ObjectMap<CompiledShader> shaders = new Int2ObjectArrayMap();

    public CachedShaderCompiler(@Nullable ShaderCompiler.ShaderProvider provider) {
        super(provider);
    }

    @Override
    public CompiledShader compile(ShaderCompiler.Context context, int type, ProgramDefinition.SourceType sourceType, class_2960 path) throws IOException, ShaderException {
        int hash = Objects.hash(type, path);
        if (this.shaders.containsKey(hash)) {
            return (CompiledShader)this.shaders.get(hash);
        }
        CompiledShader shader = super.compile(context, type, sourceType, path);
        this.shaders.put(hash, (Object)shader);
        return shader;
    }

    @Override
    public CompiledShader compile(ShaderCompiler.Context context, int type, ProgramDefinition.SourceType sourceType, VeilShaderSource source) throws ShaderException {
        int hash = Objects.hash(type, source.sourceId());
        if (this.shaders.containsKey(hash)) {
            return (CompiledShader)this.shaders.get(hash);
        }
        CompiledShader shader = super.compile(context, type, sourceType, source);
        this.shaders.put(hash, (Object)shader);
        return shader;
    }

    @Override
    public void free() {
        super.free();
        this.shaders.clear();
    }
}

