/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.fabric;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import foundry.veil.Veil;
import foundry.veil.VeilClient;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.quasar.data.QuasarParticles;
import foundry.veil.api.quasar.particle.ParticleEmitter;
import foundry.veil.api.quasar.particle.ParticleSystemManager;
import foundry.veil.fabric.FabricQuasarParticleHandler;
import foundry.veil.fabric.mixin.compat.iris.IrisRenderingPipelineAccessor;
import foundry.veil.fabric.mixin.compat.sodium.RenderSectionManagerAccessor;
import foundry.veil.fabric.mixin.compat.sodium.ShaderChunkRendererAccessor;
import foundry.veil.fabric.mixin.compat.sodium.SodiumWorldRendererAccessor;
import foundry.veil.fabric.util.FabricReloadListener;
import foundry.veil.impl.VeilBuiltinPacks;
import foundry.veil.impl.VeilReloadListeners;
import foundry.veil.impl.client.render.VeilUITooltipRenderer;
import foundry.veil.impl.client.render.shader.VeilVanillaShaders;
import foundry.veil.impl.compat.IrisShaderMap;
import foundry.veil.impl.compat.SodiumShaderMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.Collections;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.CoreShaderRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.minecraft.class_2232;
import net.minecraft.class_2277;
import net.minecraft.class_2280;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3264;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class VeilFabricClient
implements ClientModInitializer {
    public void onInitializeClient() {
        VeilClient.init();
        HudRenderCallback.EVENT.register(VeilUITooltipRenderer::renderOverlay);
        ClientTickEvents.END_CLIENT_TICK.register(client -> VeilClient.tickClient(client.method_60646().method_60638()));
        FabricQuasarParticleHandler.init();
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> VeilRenderSystem.renderer().getLightRenderer().free());
        if (IrisShaderMap.isEnabled()) {
            IrisShaderMap.setLoadedShadersSupplier(() -> {
                WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
                if (pipeline instanceof IrisRenderingPipelineAccessor) {
                    return ((IrisRenderingPipelineAccessor)pipeline).getLoadedShaders();
                }
                return Collections.emptySet();
            });
        }
        if (SodiumShaderMap.isEnabled()) {
            SodiumShaderMap.setLoadedShadersSupplier(() -> {
                ChunkRenderer patt0$temp;
                RenderSectionManagerAccessor renderSectionManager;
                SodiumWorldRenderer worldRenderer = SodiumWorldRenderer.instanceNullable();
                if (worldRenderer != null && (renderSectionManager = (RenderSectionManagerAccessor)((SodiumWorldRendererAccessor)worldRenderer).getRenderSectionManager()) != null && (patt0$temp = renderSectionManager.getChunkRenderer()) instanceof ShaderChunkRendererAccessor) {
                    ShaderChunkRendererAccessor accessor = (ShaderChunkRendererAccessor)patt0$temp;
                    return Object2IntMaps.singleton((Object)class_2960.method_60655((String)"sodium", (String)"chunk_shader"), (int)accessor.getPrograms().values().iterator().next().handle());
                }
                return Object2IntMaps.emptyMap();
            });
        }
        KeyBindingHelper.registerKeyBinding((class_304)VeilClient.EDITOR_KEY);
        ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer("veil").orElseThrow();
        VeilBuiltinPacks.registerPacks((id, defaultEnabled) -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)id, (ModContainer)container, (ResourcePackActivationType)(defaultEnabled ? ResourcePackActivationType.DEFAULT_ENABLED : ResourcePackActivationType.NORMAL)));
        CoreShaderRegistrationCallback.EVENT.register(context -> VeilVanillaShaders.registerShaders((arg_0, arg_1, arg_2) -> ((CoreShaderRegistrationCallback.RegistrationContext)context).register(arg_0, arg_1, arg_2)));
        VeilReloadListeners.registerListeners((type, id, listener) -> ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new FabricReloadListener(Veil.veilPath(id), listener)));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> {
            LiteralArgumentBuilder builder = LiteralArgumentBuilder.literal((String)"quasar");
            builder.then(ClientCommandManager.argument((String)"emitter", (ArgumentType)class_2232.method_9441()).suggests(QuasarParticles.emitterSuggestionProvider()).then(ClientCommandManager.argument((String)"position", (ArgumentType)class_2277.method_9737()).executes(ctx -> {
                class_2960 id = (class_2960)ctx.getArgument("emitter", class_2960.class);
                FabricClientCommandSource source = (FabricClientCommandSource)ctx.getSource();
                ParticleSystemManager particleManager = VeilRenderSystem.renderer().getParticleManager();
                ParticleEmitter instance = particleManager.createEmitter(id);
                if (instance == null) {
                    source.sendError((class_2561)class_2561.method_43470((String)("Unknown emitter: " + String.valueOf(id))));
                    return 0;
                }
                class_2280 coordinates = (class_2280)ctx.getArgument("position", class_2280.class);
                class_243 pos = coordinates.method_9708(source.getEntity().method_5671());
                instance.setPosition(pos.field_1352, pos.field_1351, pos.field_1350);
                particleManager.addParticleSystem(instance);
                source.sendFeedback((class_2561)class_2561.method_43470((String)("Spawned " + String.valueOf(id))));
                return 1;
            })));
            dispatcher.register(builder);
        });
        ClientTickEvents.START_WORLD_TICK.register(client -> VeilRenderSystem.renderer().getParticleManager().tick());
    }
}

