/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.dynamicbuffer;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.ext.ShaderInstanceExtension;
import foundry.veil.impl.ThreadTaskScheduler;
import foundry.veil.impl.client.render.shader.SimpleShaderProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4239;
import net.minecraft.class_5912;
import net.minecraft.class_5913;
import net.minecraft.class_5944;
import org.apache.commons.io.IOUtils;

public class VanillaShaderCompiler {
    private static final Set<String> LAST_FRAME_SHADERS = ConcurrentHashMap.newKeySet();
    private ThreadTaskScheduler scheduler;

    private void compileShader(class_5944 shader) {
        ShaderInstanceExtension extension = (ShaderInstanceExtension)shader;
        Collection<class_2960> shaderSources = extension.veil$getShaderSources();
        class_293 vertexFormat = shader.method_35786();
        final class_3300 resourceManager = class_310.method_1551().method_1478();
        SimpleShaderProcessor.setup((class_5912)resourceManager);
        for (final class_2960 path : shaderSources) {
            try {
                BufferedReader reader = resourceManager.openAsReader(path);
                try {
                    String source = IOUtils.toString((Reader)reader);
                    class_5913 preprocessor = new class_5913(this){
                        private final Set<String> importedPaths = Sets.newHashSet();

                        public String method_34233(boolean useFullPath, String directory) {
                            directory = class_4239.method_34676((String)((useFullPath ? path.method_12832() : "shaders/include/") + directory));
                            if (!this.importedPaths.add(directory)) {
                                return null;
                            }
                            class_2960 resourcelocation = class_2960.method_60654((String)directory);
                            try {
                                String s2;
                                try (BufferedReader reader = resourceManager.openAsReader(resourcelocation);){
                                    s2 = IOUtils.toString((Reader)reader);
                                }
                                return s2;
                            }
                            catch (IOException e) {
                                Veil.LOGGER.error("Could not open GLSL import {}: {}", (Object)directory, (Object)e.getMessage());
                                return "#error " + e.getMessage();
                            }
                        }
                    };
                    source = String.join((CharSequence)"", preprocessor.method_34229(source));
                    boolean vertex = path.method_12832().endsWith(".vsh");
                    String processed = SimpleShaderProcessor.modify(shader.method_35787(), path, vertexFormat, vertex ? 35633 : 35632, source);
                    RenderSystem.recordRenderCall(() -> extension.veil$recompile(vertex, processed));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Throwable t) {
                Veil.LOGGER.error("Couldn't load vanilla shader from {}", (Object)path, (Object)t);
            }
        }
        SimpleShaderProcessor.free();
    }

    public CompletableFuture<?> reload(Collection<class_5944> shaders) {
        ThreadTaskScheduler scheduler;
        if (this.scheduler != null) {
            this.scheduler.cancel();
        }
        ConcurrentHashMap<String, class_5944> shaderMap = new ConcurrentHashMap<String, class_5944>(shaders.size());
        for (class_5944 shader : shaders) {
            shaderMap.put(shader.method_35787(), shader);
        }
        this.scheduler = scheduler = new ThreadTaskScheduler("VeilShaderCompile", Math.max(1, Runtime.getRuntime().availableProcessors() / 4), () -> {
            for (String lastFrameShader : LAST_FRAME_SHADERS) {
                class_5944 shader = (class_5944)shaderMap.remove(lastFrameShader);
                if (shader == null) continue;
                return () -> this.compileShader(shader);
            }
            Iterator iterator = shaderMap.values().iterator();
            if (iterator.hasNext()) {
                class_5944 shader = (class_5944)iterator.next();
                iterator.remove();
                return () -> this.compileShader(shader);
            }
            return null;
        });
        CompletableFuture<?> future = scheduler.getCompletedFuture();
        future.thenRunAsync(() -> {
            if (!scheduler.isCancelled()) {
                Veil.LOGGER.info("Compiled {} vanilla shaders", (Object)shaders.size());
            }
        }, (Executor)class_310.method_1551());
        return future;
    }

    public boolean isCompilingShaders() {
        return this.scheduler != null && !this.scheduler.getCompletedFuture().isDone();
    }

    public static void markRendered(String shaderInstace) {
        if (VeilRenderSystem.renderer().getVanillaShaderCompiler().isCompilingShaders()) {
            LAST_FRAME_SHADERS.add(shaderInstace);
        }
    }

    public static void clear() {
        LAST_FRAME_SHADERS.clear();
    }
}

