/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.dynamicbuffer;

import foundry.veil.Veil;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import foundry.veil.impl.glsl.GlslInjectionPoint;
import foundry.veil.impl.glsl.GlslParser;
import foundry.veil.impl.glsl.grammar.GlslSpecifiedType;
import foundry.veil.impl.glsl.grammar.GlslTypeQualifier;
import foundry.veil.impl.glsl.grammar.GlslTypeSpecifier;
import foundry.veil.impl.glsl.grammar.GlslVersion;
import foundry.veil.impl.glsl.node.GlslConstantNode;
import foundry.veil.impl.glsl.node.GlslNode;
import foundry.veil.impl.glsl.node.GlslTree;
import foundry.veil.impl.glsl.node.expression.GlslAssignmentNode;
import foundry.veil.impl.glsl.node.expression.GlslOperationNode;
import foundry.veil.impl.glsl.node.function.GlslFunctionNode;
import foundry.veil.impl.glsl.node.function.GlslInvokeFunctionNode;
import foundry.veil.impl.glsl.node.variable.GlslNewNode;
import foundry.veil.impl.glsl.node.variable.GlslVariableNode;
import foundry.veil.impl.glsl.visitor.GlslStringWriter;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_293;
import net.minecraft.class_296;

public class DynamicBufferProcessor
implements ShaderPreProcessor {
    private static final String[] VECTOR_ELEMENTS = new String[]{".x", ".y", ".z", ".w"};
    private static final Set<String> BLOCK_SHADERS = Set.of("rendertype_solid", "rendertype_cutout", "rendertype_cutout_mipped", "rendertype_translucent");
    private final DynamicBufferType[] types;
    private final Object2IntMap<String> validBuffers;

    public DynamicBufferProcessor(DynamicBufferType[] types) {
        this.types = types;
        this.validBuffers = new Object2IntArrayMap();
    }

    @Override
    public void prepare() {
        this.validBuffers.clear();
    }

    @Override
    public String modify(ShaderPreProcessor.Context ctx, String source) throws IOException {
        class_293 vertexFormat = ctx.vertexFormat();
        if (ctx.definition() == null && (vertexFormat == null || ctx.name() == null)) {
            return source;
        }
        try {
            int i;
            GlslTree tree = GlslParser.parse(source);
            Map<String, GlslNode> markers = tree.getMarkers();
            GlslFunctionNode mainFunction = tree.mainFunction().orElseThrow();
            List<GlslNode> mainFunctionBody = Objects.requireNonNull(mainFunction.getBody());
            GlslVersion version = tree.getVersion();
            if (version.getVersion() < 330) {
                version.setVersion(330);
            }
            version.setCore(true);
            GlslNode sampler = null;
            GlslNode lightmapUV = null;
            boolean blockLightmap = false;
            boolean injectLightmap = !markers.containsKey("veil:" + DynamicBufferType.LIGHT_COLOR.getName()) || !markers.containsKey("veil:" + DynamicBufferType.LIGHT_UV.getName());
            boolean vertexShader = ctx.type() == 35633;
            boolean fragmentShader = ctx.type() == 35632;
            boolean modified = false;
            if (vertexFormat != null) {
                if (vertexShader && injectLightmap) {
                    Optional<GlslNode> texelFetchOptional;
                    Optional<GlslNode> sampleLightmapOptional = mainFunction.stream().filter(node -> {
                        GlslVariableNode variableNode;
                        GlslInvokeFunctionNode invokeFunctionNode;
                        if (!(node instanceof GlslInvokeFunctionNode) || (invokeFunctionNode = (GlslInvokeFunctionNode)node).getParameters().size() != 2) {
                            return false;
                        }
                        GlslNode patt0$temp = invokeFunctionNode.getHeader();
                        return patt0$temp instanceof GlslVariableNode && "minecraft_sample_lightmap".equals((variableNode = (GlslVariableNode)patt0$temp).getName());
                    }).findFirst();
                    if (sampleLightmapOptional.isPresent()) {
                        List<GlslNode> parameters = ((GlslInvokeFunctionNode)sampleLightmapOptional.get()).getParameters();
                        sampler = parameters.get(0);
                        lightmapUV = parameters.get(1);
                        blockLightmap = true;
                    } else if (vertexFormat.method_60836(class_296.field_52112) && (texelFetchOptional = mainFunction.stream().filter(node -> {
                        if (!(node instanceof GlslInvokeFunctionNode)) return false;
                        GlslInvokeFunctionNode invokeFunctionNode = (GlslInvokeFunctionNode)node;
                        if (invokeFunctionNode.getParameters().size() != 3) {
                            return false;
                        }
                        List<GlslNode> parameters = invokeFunctionNode.getParameters();
                        GlslNode patt0$temp = invokeFunctionNode.getHeader();
                        if (!(patt0$temp instanceof GlslVariableNode)) return false;
                        GlslVariableNode functionName = (GlslVariableNode)patt0$temp;
                        if (!"texelFetch".equals(functionName.getName())) return false;
                        GlslNode patt1$temp = parameters.get(1);
                        if (!(patt1$temp instanceof GlslOperationNode)) return false;
                        GlslOperationNode operation = (GlslOperationNode)patt1$temp;
                        GlslNode patt2$temp = operation.getFirst();
                        if (!(patt2$temp instanceof GlslVariableNode)) return false;
                        GlslVariableNode variableNode = (GlslVariableNode)patt2$temp;
                        GlslNode patt3$temp = operation.getSecond();
                        if (!(patt3$temp instanceof GlslConstantNode)) return false;
                        GlslConstantNode constantNode = (GlslConstantNode)patt3$temp;
                        if (constantNode.intValue() != 16) return false;
                        if (operation.getOperand() != GlslOperationNode.Operand.DIVIDE) return false;
                        if (!vertexFormat.method_60837(class_296.field_52112).equals(variableNode.getName())) return false;
                        return true;
                    }).findFirst()).isPresent()) {
                        List<GlslNode> parameters = ((GlslInvokeFunctionNode)texelFetchOptional.get()).getParameters();
                        sampler = parameters.get(0);
                        lightmapUV = ((GlslOperationNode)parameters.get(1)).getFirst();
                    }
                }
                for (i = 0; i < this.types.length; ++i) {
                    DynamicBufferType type = this.types[i];
                    String sourceName = type.getSourceName();
                    String output = "layout(location = " + (1 + i) + ") out " + type.getType().getSourceString() + " " + sourceName;
                    if (injectLightmap) {
                        if (type == DynamicBufferType.LIGHT_UV) {
                            if (markers.containsKey("veil:" + DynamicBufferType.LIGHT_UV.getName())) continue;
                            if (vertexShader) {
                                if (lightmapUV != null) {
                                    tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression("out vec2 Pass" + type.getSourceName()));
                                    if (blockLightmap) {
                                        mainFunctionBody.add(GlslParser.parseExpression("vec2 veilTexCoord2 = clamp(" + lightmapUV.getSourceString() + " / 256.0, vec2(0.5 / 16.0), vec2(15.5 / 16.0))"));
                                        mainFunctionBody.add(new GlslAssignmentNode(new GlslVariableNode("Pass" + type.getSourceName()), new GlslVariableNode("veilTexCoord2"), GlslAssignmentNode.Operand.EQUAL));
                                    } else {
                                        mainFunctionBody.add(new GlslAssignmentNode(new GlslVariableNode("Pass" + type.getSourceName()), GlslParser.parseExpression("vec2(" + lightmapUV.getSourceString() + " / 256.0)"), GlslAssignmentNode.Operand.EQUAL));
                                    }
                                    modified = true;
                                    this.validBuffers.computeInt((Object)ctx.shaderInstance(), (unused, mask) -> (mask != null ? mask : 0) | type.getMask());
                                }
                            } else if ((this.validBuffers.getInt((Object)ctx.shaderInstance()) & type.getMask()) != 0) {
                                tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression("in vec2 Pass" + type.getSourceName()));
                                tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression(output));
                                mainFunctionBody.add(new GlslAssignmentNode(new GlslVariableNode(type.getSourceName()), GlslParser.parseExpression("vec4(Pass" + type.getSourceName() + ", 0.0, 1.0)"), GlslAssignmentNode.Operand.EQUAL));
                                modified = true;
                            }
                        } else if (type == DynamicBufferType.LIGHT_COLOR) {
                            if (markers.containsKey("veil:" + DynamicBufferType.LIGHT_COLOR.getName())) continue;
                            if (vertexShader) {
                                if (lightmapUV != null && sampler != null) {
                                    tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression("out vec3 Pass" + type.getSourceName()));
                                    if (blockLightmap) {
                                        mainFunctionBody.add(new GlslAssignmentNode(new GlslVariableNode("Pass" + type.getSourceName()), GlslParser.parseExpression("texture(" + sampler.getSourceString() + ", veilTexCoord2).rgb"), GlslAssignmentNode.Operand.EQUAL));
                                    } else {
                                        mainFunctionBody.add(new GlslAssignmentNode(new GlslVariableNode("Pass" + type.getSourceName()), GlslParser.parseExpression("texelFetch(" + sampler.getSourceString() + ", " + lightmapUV.getSourceString() + " / 16, 0).rgb"), GlslAssignmentNode.Operand.EQUAL));
                                    }
                                    modified = true;
                                    this.validBuffers.computeInt((Object)ctx.shaderInstance(), (unused, mask) -> (mask != null ? mask : 0) | type.getMask());
                                }
                            } else if ((this.validBuffers.getInt((Object)ctx.shaderInstance()) & type.getMask()) != 0) {
                                tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression("in vec3 Pass" + type.getSourceName()));
                                tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression(output));
                                mainFunctionBody.add(new GlslAssignmentNode(new GlslVariableNode(type.getSourceName()), GlslParser.parseExpression("vec4(Pass" + type.getSourceName() + ", 1.0)"), GlslAssignmentNode.Operand.EQUAL));
                                modified = true;
                            }
                        }
                    }
                    if (type == DynamicBufferType.NORMAL && !markers.containsKey("veil:" + DynamicBufferType.NORMAL.getName())) {
                        if (fragmentShader && ("particle".equals(ctx.shaderInstance()) || "rendertype_leash".equals(ctx.shaderInstance()) || "rendertype_text".equals(ctx.shaderInstance()))) {
                            tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression(output));
                            mainFunctionBody.add(new GlslAssignmentNode(new GlslVariableNode(type.getSourceName()), GlslParser.parseExpression("vec4(0.0, 0.0, 1.0, 1.0)"), GlslAssignmentNode.Operand.EQUAL));
                            modified = true;
                        }
                        if (vertexFormat.method_60836(class_296.field_52113)) {
                            if (vertexShader) {
                                Optional<GlslNewNode> fieldOptional = tree.field(vertexFormat.method_60837(class_296.field_52113));
                                if (fieldOptional.isPresent()) {
                                    tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression("uniform mat3 NormalMat"));
                                    tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression("out vec3 Pass" + type.getSourceName()));
                                    mainFunctionBody.add(new GlslAssignmentNode(new GlslVariableNode("Pass" + type.getSourceName()), GlslParser.parseExpression("NormalMat * " + fieldOptional.get().getName()), GlslAssignmentNode.Operand.EQUAL));
                                    modified = true;
                                    this.validBuffers.computeInt((Object)ctx.shaderInstance(), (unused, mask) -> (mask != null ? mask : 0) | type.getMask());
                                }
                            } else if (fragmentShader && (this.validBuffers.getInt((Object)ctx.shaderInstance()) & type.getMask()) != 0) {
                                tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression("in vec3 Pass" + type.getSourceName()));
                                tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression(output));
                                mainFunctionBody.add(new GlslAssignmentNode(new GlslVariableNode(type.getSourceName()), GlslParser.parseExpression("vec4(Pass" + type.getSourceName() + ", 1.0)"), GlslAssignmentNode.Operand.EQUAL));
                                modified = true;
                            }
                        }
                    }
                    if (type != DynamicBufferType.ALBEDO || markers.containsKey("veil:" + DynamicBufferType.ALBEDO.getName())) continue;
                    if (vertexShader) {
                        Optional<GlslNewNode> fieldOptional;
                        Optional<GlslNode> mixLightOptional;
                        if (BLOCK_SHADERS.contains(ctx.shaderInstance())) {
                            // empty if block
                        }
                        if ((mixLightOptional = mainFunction.stream().filter(node -> {
                            GlslVariableNode variableNode;
                            GlslInvokeFunctionNode invokeFunctionNode;
                            if (!(node instanceof GlslInvokeFunctionNode) || (invokeFunctionNode = (GlslInvokeFunctionNode)node).getParameters().size() != 4) {
                                return false;
                            }
                            GlslNode patt0$temp = invokeFunctionNode.getHeader();
                            return patt0$temp instanceof GlslVariableNode && "minecraft_mix_light".equals((variableNode = (GlslVariableNode)patt0$temp).getName());
                        }).findFirst()).isPresent()) {
                            GlslNode color = ((GlslInvokeFunctionNode)mixLightOptional.get()).getParameters().get(3);
                            tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression("out vec4 Pass" + type.getSourceName()));
                            mainFunctionBody.add(new GlslAssignmentNode(new GlslVariableNode("Pass" + type.getSourceName()), color, GlslAssignmentNode.Operand.EQUAL));
                            modified = true;
                            this.validBuffers.computeInt((Object)ctx.shaderInstance(), (unused, mask) -> (mask != null ? mask : 0) | type.getMask());
                            continue;
                        }
                        if (!vertexFormat.method_60836(class_296.field_52108) || !(fieldOptional = tree.field(vertexFormat.method_60837(class_296.field_52108))).isPresent()) continue;
                        tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression("out vec4 Pass" + type.getSourceName()));
                        mainFunctionBody.add(new GlslAssignmentNode(new GlslVariableNode("Pass" + type.getSourceName()), new GlslVariableNode(fieldOptional.get().getName()), GlslAssignmentNode.Operand.EQUAL));
                        modified = true;
                        this.validBuffers.computeInt((Object)ctx.shaderInstance(), (unused, mask) -> (mask != null ? mask : 0) | type.getMask());
                        continue;
                    }
                    if ((this.validBuffers.getInt((Object)ctx.shaderInstance()) & type.getMask()) == 0) continue;
                    tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression("in vec4 Pass" + type.getSourceName()));
                    tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression(output));
                    boolean hasColorModulator = tree.field("ColorModulator").isPresent();
                    boolean inserted = false;
                    for (int j = 0; j < mainFunctionBody.size(); ++j) {
                        GlslNode body = mainFunctionBody.get(i);
                        Optional<GlslNode> textureOptional = body.stream().filter(node -> {
                            GlslVariableNode textureSampler;
                            GlslNode patt1$temp;
                            GlslVariableNode variableNode;
                            GlslInvokeFunctionNode invokeFunctionNode;
                            if (!(node instanceof GlslInvokeFunctionNode) || (invokeFunctionNode = (GlslInvokeFunctionNode)node).getParameters().size() != 2) {
                                return false;
                            }
                            GlslNode patt0$temp = invokeFunctionNode.getHeader();
                            return patt0$temp instanceof GlslVariableNode && "texture".equals((variableNode = (GlslVariableNode)patt0$temp).getName()) && (patt1$temp = invokeFunctionNode.getParameters().getFirst()) instanceof GlslVariableNode && "Sampler0".equals((textureSampler = (GlslVariableNode)patt1$temp).getName());
                        }).findFirst();
                        if (!textureOptional.isPresent()) continue;
                        if (hasColorModulator) {
                            mainFunctionBody.add(new GlslAssignmentNode(new GlslVariableNode(type.getSourceName()), GlslParser.parseExpression(textureOptional.get().getSourceString() + " * ColorModulator * Pass" + type.getSourceName()), GlslAssignmentNode.Operand.EQUAL));
                        } else {
                            mainFunctionBody.add(new GlslAssignmentNode(new GlslVariableNode(type.getSourceName()), GlslParser.parseExpression(textureOptional.get().getSourceString() + " * Pass" + type.getSourceName()), GlslAssignmentNode.Operand.EQUAL));
                        }
                        inserted = true;
                        break;
                    }
                    if (!inserted) {
                        if (hasColorModulator) {
                            mainFunctionBody.add(new GlslAssignmentNode(new GlslVariableNode(type.getSourceName()), GlslParser.parseExpression("Pass" + type.getSourceName() + " * ColorModulator"), GlslAssignmentNode.Operand.EQUAL));
                        } else {
                            mainFunctionBody.add(new GlslAssignmentNode(new GlslVariableNode(type.getSourceName()), new GlslVariableNode("Pass" + type.getSourceName()), GlslAssignmentNode.Operand.EQUAL));
                        }
                    }
                    modified = true;
                }
            }
            if (fragmentShader) {
                for (i = 0; i < this.types.length; ++i) {
                    GlslNode expression;
                    GlslTypeSpecifier.BuiltinType nodeType;
                    GlslTypeSpecifier inserted;
                    DynamicBufferType bufferType = this.types[i];
                    GlslNode node2 = markers.get("veil:" + bufferType.getName());
                    if (node2 == null) continue;
                    GlslSpecifiedType specifiedType = node2.getType();
                    if (specifiedType == null || !((inserted = specifiedType.getSpecifier()) instanceof GlslTypeSpecifier.BuiltinType) || !(nodeType = (GlslTypeSpecifier.BuiltinType)inserted).isPrimitive() && !nodeType.isVector() || !nodeType.isFloat() && !nodeType.isInteger() && !nodeType.isUnsignedInteger()) {
                        Veil.LOGGER.warn("Invalid node marked '#veil:{}' in shader: {}", (Object)bufferType.getName(), (Object)ctx.name());
                        continue;
                    }
                    modified = true;
                    String fieldName = bufferType.getSourceName();
                    GlslTypeSpecifier.BuiltinType outType = bufferType.getType();
                    tree.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression("layout(location = " + (1 + i) + ") out " + outType.getSourceString() + " " + fieldName));
                    if (!(node2 instanceof GlslNewNode)) continue;
                    GlslNewNode newNode = (GlslNewNode)node2;
                    String cast = switch (outType) {
                        case GlslTypeSpecifier.BuiltinType.FLOAT, GlslTypeSpecifier.BuiltinType.VEC2, GlslTypeSpecifier.BuiltinType.VEC3, GlslTypeSpecifier.BuiltinType.VEC4 -> {
                            if (!nodeType.isFloat()) {
                                yield "float";
                            }
                            yield null;
                        }
                        case GlslTypeSpecifier.BuiltinType.INT, GlslTypeSpecifier.BuiltinType.IVEC2, GlslTypeSpecifier.BuiltinType.IVEC3, GlslTypeSpecifier.BuiltinType.IVEC4 -> {
                            if (!nodeType.isInteger()) {
                                yield "int";
                            }
                            yield null;
                        }
                        case GlslTypeSpecifier.BuiltinType.UINT, GlslTypeSpecifier.BuiltinType.UVEC2, GlslTypeSpecifier.BuiltinType.UVEC3, GlslTypeSpecifier.BuiltinType.UVEC4 -> {
                            if (!nodeType.isUnsignedInteger()) {
                                yield "uint";
                            }
                            yield null;
                        }
                        default -> null;
                    };
                    String name = newNode.getName();
                    if (nodeType == outType) {
                        expression = new GlslVariableNode(name);
                    } else if (nodeType.getComponents() < outType.getComponents()) {
                        int j;
                        String padding;
                        StringBuilder builder = new StringBuilder(outType.getSourceString()).append("(");
                        String string = outType.isFloat() ? "0.0" : (padding = outType.isUnsignedInteger() ? "0u" : "0");
                        if (nodeType.getComponents() == 1) {
                            builder.append(cast != null ? cast + "(" + name + "), " : name + ", ");
                        } else {
                            for (j = 0; j < nodeType.getComponents(); ++j) {
                                builder.append(cast != null ? cast + "(" + name + VECTOR_ELEMENTS[j] + "), " : name + VECTOR_ELEMENTS[j] + ", ");
                            }
                        }
                        for (j = nodeType.getComponents(); j < 3; ++j) {
                            builder.append(padding).append(", ");
                        }
                        builder.append(outType.isFloat() ? "1.0" : (outType.isUnsignedInteger() ? "1u" : "1"));
                        builder.append(')');
                        expression = GlslParser.parseExpression(builder.toString());
                    } else {
                        expression = GlslParser.parseExpression((cast != null ? outType.getSourceString() : "") + "(" + name + ")");
                    }
                    mainFunctionBody.add(new GlslAssignmentNode(new GlslVariableNode(fieldName), expression, GlslAssignmentNode.Operand.EQUAL));
                }
            }
            if (modified) {
                if (fragmentShader) {
                    ArrayList outputs = new ArrayList();
                    tree.fields().forEach(node -> {
                        block10: {
                            GlslSpecifiedType type = node.getType();
                            boolean valid = false;
                            for (GlslTypeQualifier qualifier : type.getQualifiers()) {
                                if (qualifier != GlslTypeQualifier.StorageType.OUT) continue;
                                valid = true;
                                break;
                            }
                            if (!valid) {
                                return;
                            }
                            block5: for (GlslTypeQualifier qualifier : type.getQualifiers()) {
                                List<GlslTypeQualifier.LayoutId> patt1$temp;
                                if (!(qualifier instanceof GlslTypeQualifier.Layout)) continue;
                                GlslTypeQualifier.Layout $b$0 = (GlslTypeQualifier.Layout)qualifier;
                                List<GlslTypeQualifier.LayoutId> layoutIds = patt1$temp = $b$0.layoutIds();
                                for (GlslTypeQualifier.LayoutId layoutId : layoutIds) {
                                    GlslNode expression;
                                    if (!"location".equals(layoutId.identifier()) || (expression = layoutId.expression()) == null) continue;
                                    try {
                                        int location = Integer.parseInt(expression.getSourceString());
                                        if (location == 0) {
                                            outputs.clear();
                                            return;
                                        }
                                        valid = false;
                                        continue block5;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                    }
                                }
                            }
                            if (valid) {
                                outputs.add(node);
                            }
                            break block10;
                            catch (Throwable throwable) {
                                throw new MatchException(throwable.toString(), throwable);
                            }
                        }
                    });
                    for (GlslNewNode output : outputs) {
                        output.getType().addLayoutId("location", GlslNode.intConstant(0));
                    }
                }
                GlslStringWriter writer = new GlslStringWriter();
                tree.visit(writer);
                return writer.toString();
            }
        }
        catch (Throwable t) {
            Veil.LOGGER.error("Failed to transform shader: {}", (Object)ctx.name(), (Object)t);
        }
        return source;
    }
}

