/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.AdvancedFboAttachment;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_6367;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30;

@ApiStatus.Internal
public class AdvancedFboImpl
implements AdvancedFbo {
    private static final Map<Integer, String> ERRORS = Map.of(36054, "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT", 36055, "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT", 36059, "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER", 36060, "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER", 36061, "GL_FRAMEBUFFER_UNSUPPORTED", 36182, "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE", 33305, "GL_FRAMEBUFFER_UNDEFINED", 1285, "GL_OUT_OF_MEMORY");
    public static final AdvancedFbo MAIN_WRAPPER = VeilRenderBridge.wrap(() -> ((class_310)class_310.method_1551()).method_1522());
    private int id = -1;
    private int width;
    private int height;
    private final AdvancedFboAttachment[] colorAttachments;
    private final AdvancedFboAttachment depthAttachment;
    private final int clearMask;
    private final int[] drawBuffers;
    private final Supplier<Wrapper> wrapper;

    public AdvancedFboImpl(int width, int height, AdvancedFboAttachment[] colorAttachments, @Nullable AdvancedFboAttachment depthAttachment) {
        this.width = width;
        this.height = height;
        this.colorAttachments = colorAttachments;
        this.depthAttachment = depthAttachment;
        int mask = 0;
        if (this.hasColorAttachment(0)) {
            mask |= 0x4000;
        }
        if (this.hasDepthAttachment()) {
            mask |= 0x100;
        }
        this.clearMask = mask;
        this.drawBuffers = IntStream.range(0, this.colorAttachments.length).map(i -> 36064 + i).toArray();
        this.wrapper = Suppliers.memoize(() -> new Wrapper(this));
    }

    @Override
    public void create() {
        int status;
        for (AdvancedFboAttachment attachment : this.colorAttachments) {
            attachment.create();
        }
        if (this.depthAttachment != null) {
            this.depthAttachment.create();
        }
        this.id = GL30.glGenFramebuffers();
        this.bind(false);
        for (int i = 0; i < this.colorAttachments.length; ++i) {
            this.colorAttachments[i].attach(i);
        }
        if (this.depthAttachment != null) {
            this.depthAttachment.attach(0);
        }
        if ((status = GL30.glCheckFramebufferStatus((int)36160)) != 36053) {
            Object error = ERRORS.containsKey(status) ? ERRORS.get(status) : "0x" + Integer.toHexString(status).toUpperCase(Locale.ROOT);
            throw new IllegalStateException("Advanced FBO status did not return GL_FRAMEBUFFER_COMPLETE. " + (String)error);
        }
        GL20C.glDrawBuffers((int[])this.drawBuffers);
        AdvancedFbo.unbind();
    }

    @Override
    public void clear() {
        if (this.clearMask != 0) {
            GlStateManager._clear((int)this.clearMask, (boolean)class_310.field_1703);
        }
    }

    @Override
    public void bind(boolean setViewport) {
        GL30.glBindFramebuffer((int)36160, (int)this.id);
        if (setViewport) {
            RenderSystem.viewport((int)0, (int)0, (int)this.width, (int)this.height);
        }
    }

    @Override
    public void bindRead() {
        GL30.glBindFramebuffer((int)36008, (int)this.id);
    }

    @Override
    public void bindDraw(boolean setViewport) {
        GL30.glBindFramebuffer((int)36009, (int)this.id);
        if (setViewport) {
            RenderSystem.viewport((int)0, (int)0, (int)this.width, (int)this.height);
        }
    }

    public void free() {
        if (this.id == -1) {
            return;
        }
        GL30.glDeleteFramebuffers((int)this.id);
        this.id = -1;
        for (AdvancedFboAttachment attachment : this.colorAttachments) {
            attachment.free();
        }
        if (this.depthAttachment != null) {
            this.depthAttachment.free();
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getColorAttachments() {
        return this.colorAttachments.length;
    }

    @Override
    public int getClearMask() {
        return this.clearMask;
    }

    @Override
    public int[] getDrawBuffers() {
        return this.drawBuffers;
    }

    @Override
    public boolean hasColorAttachment(int attachment) {
        return attachment >= 0 && attachment < this.colorAttachments.length;
    }

    @Override
    public boolean hasDepthAttachment() {
        return this.depthAttachment != null;
    }

    @Override
    public AdvancedFboAttachment getColorAttachment(int attachment) {
        Validate.isTrue((boolean)this.hasColorAttachment(attachment), (String)("Color attachment " + attachment + " does not exist."), (Object[])new Object[0]);
        return this.colorAttachments[attachment];
    }

    @Override
    public AdvancedFboAttachment getDepthAttachment() {
        return Objects.requireNonNull(this.depthAttachment, "Depth attachment does not exist.");
    }

    public Wrapper toRenderTarget() {
        return this.wrapper.get();
    }

    @ApiStatus.Internal
    public static AdvancedFbo.Builder copy(class_276 parent) {
        if (parent instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)parent;
            AdvancedFboImpl fbo = wrapper.fbo();
            return new AdvancedFbo.Builder(fbo.getWidth(), fbo.getHeight()).addAttachments(fbo);
        }
        return new AdvancedFbo.Builder(parent.field_1482, parent.field_1481).addAttachments(parent);
    }

    public static class Wrapper
    extends class_6367 {
        private final AdvancedFboImpl fbo;

        private Wrapper(AdvancedFboImpl fbo) {
            super(fbo.width, fbo.height, fbo.hasDepthAttachment(), class_310.field_1703);
            this.fbo = fbo;
            this.method_1231(this.fbo.getWidth(), this.fbo.getHeight(), class_310.field_1703);
        }

        public void method_1234(int width, int height, boolean onMac) {
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.method_1231(width, height, onMac));
            } else {
                this.method_1231(width, height, onMac);
            }
        }

        public void method_1238() {
            this.fbo.close();
        }

        public void method_1231(int width, int height, boolean onMac) {
            this.field_1480 = width;
            this.field_1477 = height;
            if (this.fbo == null) {
                return;
            }
            this.fbo.width = width;
            this.fbo.height = height;
            this.field_1482 = width;
            this.field_1481 = height;
        }

        public void method_58226(int framebufferFilter) {
            RenderSystem.assertOnRenderThreadOrInit();
            this.field_1483 = framebufferFilter;
            for (int i = 0; i < this.fbo.getColorAttachments(); ++i) {
                this.fbo.getColorAttachment(i).bindAttachment();
                GlStateManager._texParameter((int)3553, (int)10241, (int)framebufferFilter);
                GlStateManager._texParameter((int)3553, (int)10240, (int)framebufferFilter);
                GlStateManager._texParameter((int)3553, (int)10242, (int)10496);
                GlStateManager._texParameter((int)3553, (int)10243, (int)10496);
                this.fbo.getColorAttachment(i).unbindAttachment();
            }
        }

        public void method_35610() {
            if (this.fbo.hasColorAttachment(0)) {
                this.fbo.getColorAttachment(0).bindAttachment();
            }
        }

        public void method_1242() {
            if (this.fbo.hasColorAttachment(0)) {
                this.fbo.getColorAttachment(0).unbindAttachment();
            }
        }

        public void method_1235(boolean setViewport) {
            this.fbo.bind(setViewport);
        }

        public AdvancedFboImpl fbo() {
            return this.fbo;
        }
    }
}

